<?php

namespace App\Http\Controllers\Frontend\User;

use App\Helpers\General\Time;
use App\Http\Controllers\Controller;
use App\Models\Auth\BatchStudents;
use App\Models\Auth\StudentOnlineCourse;
use App\Models\Auth\OnlineCourse;
use Illuminate\Http\Request;

/**
 * Class MyOnlineCoursesController.
 */
class MyOnlineCoursesController extends Controller
{

    public function onlineCourseInfo(Request $request, $id)
    {
        \Log::debug("**** online course: $id **");
        $userId = \Auth::user()->id;

        //check if purchased the online course or else find if it exists in students batch
        if(StudentOnlineCourse::where('student_id', $userId)->where('online_course_id', $id)->first()) {
            $onlineCourseObj = OnlineCourse::getCourseWithChaptersObjById($id);
        } else {
            $onlineCourseObj = BatchStudents::getOnlineCourseObjByStudentIdAndOnlineCourseId($userId, $id);
        }
        if (!empty($onlineCourseObj) && isset($onlineCourseObj->id)) {
            $chaptersCount = (!empty($onlineCourseObj->chapters)) ? $onlineCourseObj->chapters->count() : 0;
            $totalDurationInHour = "00:00:00";
            $chapters = array();
            if ($chaptersCount > 0) {
                $totalMinutes = 0;
                foreach ($onlineCourseObj->chapters as $key=>$chapter) {
                    $totalMinutes += floor($chapter->duration);
                    $chapters[$key]['id'] = $chapter->id;
                    $chapters[$key]['title'] = $chapter->title;
                    $chapters[$key]['duration'] = ($chapter->duration > 0) ? Time::secToHR(floor($chapter->duration) * 60) : "00:00:00";
                }
                $totalDurationInHour = ($totalMinutes > 0) ? Time::secToHR($totalMinutes * 60) : "00:00:00";
            }
            return view('frontend.user.online_course_info', ['onlineCourseObj' => $onlineCourseObj, 'chaptersCount' => $chaptersCount,'totalDurationInHour'=>$totalDurationInHour,'chapters'=>$chapters,'courseId'=>$id]);
        }
        return redirect()->route('frontend.home');
    }

    public function onlineCourseDetail(Request $request, $id)
    {
        $userId = \Auth::user()->id;
        $chapterId = \Request::get('chapter_id',1);

        //check if purchased the online course or else find if it exists in students batch
        if(StudentOnlineCourse::where('student_id', $userId)->where('online_course_id', $id)->first()) {
            $onlineCourseObj = OnlineCourse::getCourseWithChaptersObjById($id);
        } else {
            $onlineCourseObj = BatchStudents::getOnlineCourseObjByStudentIdAndOnlineCourseId($userId, $id);
        }
        if (!empty($onlineCourseObj) && isset($onlineCourseObj->id)) {
            $chaptersCount = (!empty($onlineCourseObj->chapters)) ? $onlineCourseObj->chapters->count() : 0;
            $chapters = array();
            $selectedChapterObj = array();
            if ($chaptersCount > 0) {
                foreach ($onlineCourseObj->chapters as $key => $chapter) {
                    $chapters[$key]['id'] = $chapter->id;
                    $chapters[$key]['title'] = $chapter->title;
                    $chapters[$key]['duration'] = ($chapter->duration > 0) ? floor($chapter->duration) : "00";
                    if ($chapterId == $chapter->id) {
                        $selectedChapterObj['id'] = $chapter->id;
                        $selectedChapterObj['title'] = $chapter->title;
                        $selectedChapterObj['summary'] = $chapter->summary;
                        
                        if (strpos($chapter->file1, 'vimeo.com') !== false) {
                            $video_code_arr = explode('/',$chapter->file1);
                            $selectedChapterObj['vimeo_video_code'] = $video_code_arr[3];
                        }
                        else{
                            $selectedChapterObj['vimeo_video_code'] = '';
                        }
                        
                        $selectedChapterObj['files'] = array($chapter->file1_type => $chapter->file1, $chapter->file2_type => $chapter->file2, $chapter->file3_type => $chapter->file3);
                        $selectedChapterObj['duration'] = $chapters[$key]['duration'];
                    }
                }
            }
            
            return view('frontend.user.online_course_detail', ['onlineCourseObj' => $onlineCourseObj, 'chaptersCount' => $chaptersCount,'selected_chapter'=>$chapterId,'chapters'=>$chapters,'courseId'=>$id,'chapterObj'=>$selectedChapterObj]);
        }
        return redirect()->route('frontend.home');
    }

}
