<?php

namespace App\Http\Controllers\Frontend\User;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Models\Auth\Products;
use App\Models\Auth\ProductCategories;
use App\Models\Auth\Categories;
use App\Models\Auth\ProductImages;
use App\Models\Auth\CurrencyRate;
use App\Models\Auth\ProductDownloads;
use App\Models\Auth\UserShippingAddress;
use App\Models\Auth\Orders;
use App\Models\Auth\OrderItems;
use App\Models\Auth\OrderStatus;
use App\Models\Auth\PaymentGatewayTrans;
use App\Models\Auth\User;
use App\Models\Auth\OnlineCourse;
use App\Models\Auth\Course;
use App\Models\Auth\Country;
use App\Models\Auth\Shipping;
use App\Models\Auth\Downloads;
use App\Models\Auth\State;
use App\Models\Auth\City;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;

class MyOrdersController extends Controller
{
  public function index()
  {
    return view('frontend.my-orders.index');
  }

  public function orders_list()
  {
    $id = auth()->user()->id;

    $data = Orders::where('user_id', '=', $id)->latest()->get();
    return Datatables::of($data)
      ->editColumn('date', function ($data) {
        $date = strtotime($data->created_at);
        $new_date = date('d/m/Y', $date);
        return $new_date;
      })
      ->editColumn('order_id', function ($data) {
        return $data->id;
      })
      ->editColumn('amount', function ($data) {
        $cur = CurrencyRate::where('code', '=', $data->currency)->first();
        if ($data->status == "pending") {
          $st = "Pending";
        } else {
          $st = '';
        }
        $res = $cur->symbol . $data->total;
        return view("frontend.my-orders.amount", compact('res', 'st'));
      })
      // ->editColumn('delivery_status', function ($data) {
      //   $sta = OrderItems::where('order_id', '=', $data->id)->first();
      //   if($sta->product_id!=0){
      //       $prod = Products::where('id', '=', $sta->product_id)->first();
      //       if ($prod->type == "digital") {
      //         return "-";
      //       } else {
      //         return ucfirst($sta->status);
      //       }
      //   }
      //   else{
      //         return "-";
      //     }
      // })
      ->addColumn('action', function ($data) {
        $type = "all-orders";
        return view("frontend.my-orders.btn", compact('data', 'type'));
      })
      ->rawColumns(['action'])
      ->make(true);
  }

  public function view_order($id)
  {
    $userid = auth()->user()->id;
    $order_det = Orders::where('id', '=', $id)->where('user_id', $userid)->first();
    $user_det = User::where('id', '=', $order_det->user_id)->first();
    $country = Country::where('id', '=', $user_det->country)->first();
    $state = State::where('id', '=', $user_det->state)->first();
    $city = City::where('id', '=', $user_det->city)->first();
    $currency = CurrencyRate::where('code', '=', $order_det->currency)->first();
    $items = OrderItems::where('order_id', '=', $id)->get();
    $items_det = array();
    $sellers = array();
    for ($i = 0; $i < count($items); $i++) {
      if($items[$i]->product_id!=0){
          $item_id = $items[$i]->product_id;
          $items_det[] = Products::where('id', '=', $item_id)->first();
          $img[] = ProductImages::where('product_id', '=', $item_id)->where('is_default', '=', 1)->first();
          $prod_type = Products::where('id', '=', $item_id)->first(['type']);
      }else if($items[$i]->coaching_id!=0){
          $item_id = $items[$i]->coaching_id;
          $items_det[] = Course::where('id', '=', $item_id)->first();
          $img[] = Course::where('id', '=', $item_id)->first(['image']);
          $prod_type = 'coaching';
      }
      else if($items[$i]->online_course_id!=0){
          $item_id = $items[$i]->online_course_id;
          $items_det[] = OnlineCourse::where('id', '=', $item_id)->first();
          $img[] = OnlineCourse::where('id', '=', $item_id)->first(['image']);
          $prod_type = 'online_course';
      }
      
    }
    for ($i = 0; $i < count($items_det); $i++) {
      if($items_det[$i]->seller){
        $sellers[] = User::where('id', '=', $items_det[$i]->seller)->first();
      }else{
        $sellers[] = 1;
      }
      
    }
    $activities = OrderStatus::where('orderid', '=', $id)->get();
    $products = array();
    for ($i = 0; $i < count($activities); $i++) {
      $products[] = Products::where('id', '=', $activities[$i]->p_id)->first();
    }
    return view(
      "frontend.my-orders.view-order",
      compact('user_det', 'country', 'state', 'city', 'order_det', 'currency', 'items_det', 'prod_type', 'items', 'img', 'activities', 'sellers', 'products')
    );
  }


  public function digi_prod_download($file)
  {
    $digi = Downloads::where('product_id', $file)->first();
    $filename = $digi->file;
    $file = asset('storage/downloads/' . $filename);
    // echo $file;
    // exit();
    if (file_exists($file)) {
      return response()->download(asset('storage/downloads/') . $filename, $filename, 
      ['Content-Type' => 'image/jpg/jpeg/png/docx/doc/pdf']);
    } else {
      echo ('File not found.');
    }
  }
}
