<?php

namespace App\Http\Controllers\Frontend\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\Frontend\User\StudyAbroadDocsRequest;
use Illuminate\Support\Facades\DB;
use App\Models\Auth\Country;
use App\Models\Auth\UniversityCourseCategories;
use App\Models\Auth\UniversityCourses;
use App\Recipients\AdminRecipient;
use App\Notifications\Frontend\AdminAlert;
use App\Models\Auth\Posts;
use App\Models\Auth\UserDetails;
use App\Models\UserActivity;
use App\Models\CourseShortlisted;
use App\Models\VisaServiceType;
use App\Models\VisaLetterType;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;
use App\Mail\MailSend;
use File;
use App\Models\Auth\User;
use App\Exceptions\GeneralException;
use App\Models\ProfileTravelHistory;
use App\Models\ProfileVisaApplicationHistory;

/**
 * Class OverseasController.
 */
class OverseasController extends Controller
{
    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */

    public function appNotification($doc_type, $user_id)
    {
        $subject = "";
        $user = User::find($user_id);
        $message = $doc_type . " uploaded by " . _label('backend_student') . " <strong>" . get_user_full_name_by_id(\Auth::user()->id) . "</strong> (" . \Auth::user()->id . ")";
        $email_message = "Hi, <br><br>Doc (" . $doc_type . ") uploaded by" . _label('backend_student') . ": " . get_user_full_name_by_id(\Auth::user()->id) . " (" . \Auth::user()->id . ")";
        $subject = $doc_type . " uploaded by " . _label('backend_student') . ": " . get_user_full_name_by_id(\Auth::user()->id);

        //Sending email Notification
        send_mail_notification($user->id, "", "DOCUMENT_UPLOAD_BY_STUDENT", $subject, $email_message);

        //Sending In App Notification
        $subject = "";
        send_in_app_notification(
            $user->id,
            $user->id,
            "DOCUMENT_UPLOAD_BY_STUDENT",
            $subject,
            $message,
            "student"
        );
    }

    public function showProfilePage()
    {
        $userid = \Auth::user()->id;
        $profile_academics = DB::table('user_academics')->where('userid', $userid)->get();
        $profile_family = DB::table('user_family')->where('userid', $userid)->get();
        $profile_employment_details = DB::table('employment_detail')->where('userid', $userid)->get();
        $profile_travel_historys = DB::table('travel_history')->where('userid', $userid)->get();
        $profile_visa_application_historys = DB::table('visa_application_history')->where('user_id', $userid)->get();

        $countries = Country::orderBy('title_en')->select('id', 'title_en as name')->get();

        $academic_years = array();
        $s_yr = date("Y") + 3;
        $e_yr = $s_yr - 60;
        for ($i = $s_yr; $i >= $e_yr; $i--) {
            $academic_years[] = $i;
        }

        $academics = array();
        $rows = DB::table('user_academics')->where('userid', $userid)->get();
        foreach ($rows as $row) {
            $academics[$row->education_level]['percent_cgpa'] = $row->percent_cgpa;
            $academics[$row->education_level]['pass_year'] = $row->pass_year;
            $academics[$row->education_level]['specialization'] = $row->specialization;
            $academics[$row->education_level]['school_college'] = $row->school_college;
            $academics[$row->education_level]['university'] = $row->university;
            $academics[$row->education_level]['backlogs'] = $row->backlogs;
        }

        $eng = array();
        $rows = DB::table('user_certification_eng')->where('userid', $userid)->get();
        foreach ($rows as $row) {
            $eng[$row->exam]['overall_score'] = $row->overall_score;
            $eng[$row->exam]['speaking'] = $row->speaking;
            $eng[$row->exam]['reading'] = $row->reading;
            $eng[$row->exam]['writing'] = $row->writing;
            $eng[$row->exam]['listening'] = $row->listening;
            $eng[$row->exam]['expiry_date'] = $row->expiry_date;
        }

        $lang = array();
        $rows = DB::table('user_certification_lang')->where('userid', $userid)->get();
        foreach ($rows as $row) {
            $lang[$row->language]['level'] = $row->level;
            $lang[$row->language]['overall_score'] = $row->overall_score;
            $lang[$row->language]['speaking'] = $row->speaking;
            $lang[$row->language]['reading'] = $row->reading;
            $lang[$row->language]['writing'] = $row->writing;
            $lang[$row->language]['listening'] = $row->listening;
            $lang[$row->language]['institute'] = $row->institute;
        }

        $exam = array('gre' => array('total_score' => '', 'verbal' => '', 'quantitative' => '', 'analytical' => '', 'integrated' => '', 'expiry_date' => ''), 'gmat' => array('total_score' => '', 'verbal' => '', 'quantitative' => '', 'analytical' => '', 'integrated' => '', 'expiry_date' => ''));
        $rows = DB::table('user_gre_gmat')->where('userid', $userid)->get();
        foreach ($rows as $row) {
            if ($row->exam == 'GRE') {
                $exam['gre']['total_score'] = $row->total_score;
                $exam['gre']['verbal'] = $row->verbal;
                $exam['gre']['quantitative'] = $row->quantitative;
                $exam['gre']['analytical'] = $row->analytical;
                $exam['gre']['integrated'] = $row->integrated;
                $exam['gre']['expiry_date'] = $row->expiry_date;
            } elseif ($row->exam == 'GMAT') {
                $exam['gmat']['total_score'] = $row->total_score;
                $exam['gmat']['verbal'] = $row->verbal;
                $exam['gmat']['quantitative'] = $row->quantitative;
                $exam['gmat']['analytical'] = $row->analytical;
                $exam['gmat']['integrated'] = $row->integrated;
                $exam['gmat']['expiry_date'] = $row->expiry_date;
            }
        }

        $internships = array();
        $rows = DB::table('user_internship')->where('userid', $userid)->get();
        foreach ($rows as $row) {
            $internships[] = array('company' => $row->company, 'duration' => $row->duration, 'place' => $row->place, 'id' => $row->id, 'userid' => $row->userid);
        }

        $courses = array();
        $rows = DB::table('user_courses')->where('userid', $userid)->get();
        foreach ($rows as $row) {
            $courses[] = array('course' => $row->course, 'duration' => $row->duration, 'hours' => $row->hours, 'institute' => $row->institute, 'id' => $row->id, 'userid' => $row->userid);
        }

        $experience = array();
        $rows = DB::table('user_experience')->where('userid', $userid)->get();
        foreach ($rows as $row) {
            $experience[] = array('company' => $row->company, 'designation' => $row->designation, 'start_date' => $row->start_date, 'end_date' => $row->end_date);
        }

        $userDetails = DB::table('user_details')->where('userid', $userid)->first();

        if (!$userDetails) {
            DB::table('user_details')->insert(['userid' => $userid]);
            $userDetails = DB::table('user_details')->where('userid', $userid)->first();
        }

        //Det
        $det = DB::table('user_certification_eng')->where('userid', $userid)->where('exam', 'DET')->first();
        if ($det) {
            $det_overall_score = $det->overall_score;
            $det_expiry_date = $det->expiry_date;
        } else {
            $det_overall_score = "";
            $det_expiry_date = "";
        }
        //Act
        $act = DB::table('user_certification_eng')->where('userid', $userid)->where('exam', 'ACT')->first();
        if ($act) {
            $act_overall_score = $act->overall_score;
            $act_math = $act->math;
            $act_reading = $act->reading;
            $act_writing = $act->writing;
            $act_science = $act->science;
            $act_english = $act->english;
            $act_expiry_date = $act->expiry_date;
        } else {
            $act_overall_score = "";
            $act_math = "";
            $act_reading = "";
            $act_writing = "";
            $act_science = "";
            $act_english = "";
            $act_expiry_date = "";
        }
        //Sat
        $sat = DB::table('user_certification_eng')->where('userid', $userid)->where('exam', 'SAT')->first();
        if ($sat) {
            $sat_overall_score = $sat->overall_score;
            $sat_math = $sat->math;
            $sat_reading = $sat->reading;
            $sat_writing = $sat->writing;
            $sat_essay = $sat->essay;
            $sat_expiry_date = $sat->expiry_date;
        } else {
            $sat_overall_score = "";
            $sat_math = "";
            $sat_reading = "";
            $sat_writing = "";
            $sat_essay = "";
            $sat_expiry_date = "";
        }

        $custom_attributes = DB::table('custom_attributes')->where('for_student', 1)->orderBy('display_order', 'asc')->get(["custom_attributes.*"]);

        $user = User::where('id', $userid)->first();
        $country_of_interest = explode(',', $user->country_interested);
        $study_countries = Country::where('overseas_status', 1)->orderBy('title_en', 'ASC')->get();
        return view('frontend.user.studyabroad_apply.profile', compact(
            'countries',
            'study_countries',
            'academic_years',
            'academics',
            'eng',
            'lang',
            'exam',
            'internships',
            'courses',
            'experience',
            'userDetails',
            'det_overall_score',
            'det_expiry_date',
            'act_overall_score',
            'act_math',
            'act_reading',
            'act_writing',
            'act_science',
            'act_english',
            'act_expiry_date',
            'sat_overall_score',
            'sat_math',
            'sat_writing',
            'sat_reading',
            'sat_essay',
            'sat_expiry_date',
            'country_of_interest',
            'profile_academics',
            'profile_family',
            'profile_employment_details',
            'profile_travel_historys',
            'profile_visa_application_historys',
            'custom_attributes'
        ));
    }

    public function showCoursePreference()
    {
        $user = \Auth::user();
        if ($user->profile_complete == 'documents') {
            $profile_pending = false;
            $can_edit = false;
        } elseif ($user->profile_complete == 'course') {
            $profile_pending = false;
            $can_edit = true;
        } elseif ($user->profile_complete == 'personal') {
            $profile_pending = false;
            $can_edit = true;
        } else {
            //Without profile details cannot add course preferences or study level
            $profile_pending = true;
            $can_edit = false;
        }

        $courseprefs = array();
        $rows = DB::table('course_preference')->groupBy('country_id')->where('userid', $user->id)->get();
        foreach ($rows as $row) {
            $intakes = array();
            if ($row->intake) {
                // $intakes = explode(",", $row->intake);
                $intakes = explode(",", $row->intake . ' ' . $row->intake_year);
            }
            $courseprefs[] = array('country_id' => $row->country_id, 'course_id' => $row->course_id, 'university_id' => $row->university_id, 'country' => $row->country, 'course_name' => $row->course, 'university' => $row->university, 'intakes' => $intakes, 'intake_year' => $row->intake_year);
        }
        $countries = Country::orderBy('title_en')->where('overseas_status', 1)->select('id', 'title_en as name')->get();
        return view('frontend.user.studyabroad_apply.course_preference', compact('countries', 'profile_pending', 'can_edit', 'courseprefs'));
    }

    public function showVisaPreference()
    {
        $user = \Auth::user();
        if ($user->profile_complete == 'documents') {
            $profile_pending = false;
            $can_edit = false;
        } elseif ($user->profile_complete == 'course') {
            $profile_pending = false;
            $can_edit = true;
        } elseif ($user->profile_complete == 'personal') {
            $profile_pending = false;
            $can_edit = true;
        } else {
            $profile_pending = true;
            $can_edit = false;
        }

        $service_types = VisaServiceType::where('status', 1)->orderBy('display_order')->get();

        $visaprefs = DB::table('visa_preference')
            ->join('visa_letter_types', 'visa_letter_types.id', '=', 'visa_preference.letter_type')
            ->where('visa_preference.userid', $user->id)
            ->select('visa_preference.*', 'visa_letter_types.title as letter_type_title')
            ->get();
        return view('frontend.user.visa_apply.visa_preference', compact('profile_pending', 'can_edit', 'visaprefs', 'service_types'));
    }

    public function showDocumentsUpload()
    {
        $user = \Auth::user();
        $userid = $user->id;
        $data = array();

        if ($user->profile_complete == 'documents') {
            $coursepref_pending = false;
            $can_edit = false;
        } elseif ($user->profile_complete == 'course') {
            $coursepref_pending = false;
            $can_edit = true;
        } elseif ($user->profile_complete == 'personal') {
            $coursepref_pending = true;
            $can_edit = false;
        } else {
            $coursepref_pending = true;
            $can_edit = false;
        }
        $data['coursepref_pending'] = $coursepref_pending;
        $data['can_edit'] = $can_edit;

        if (!DB::table('user_documents')->where('userid', $userid)->exists()) {
            DB::table('user_documents')->insert(['userid' => $userid]);
        }

        $row = DB::table('user_documents')->where('userid', $userid)->first();
        $data['class10'] = $row->class10;
        $data['class10_marks_sheet'] = $row->class10_marks_sheet;
        $data['class12'] = $row->class12;
        $data['class12_marks_sheet'] = $row->class12_marks_sheet;
        $data['diploma'] = $row->diploma;
        $data['diploma_marks_sheet'] = $row->diploma_marks_sheet;
        $data['grad_all_sem'] = $row->grad_all_sem;
        $data['grad_degree'] = $row->grad_degree;
        $data['grad_transcripts'] = $row->grad_transcripts;
        $data['pg_all_sem'] = $row->pg_all_sem;
        $data['pg_degree'] = $row->pg_degree;
        $data['pg_transcripts'] = $row->pg_transcripts;
        $data['lang_ielts'] = $row->lang_ielts;
        $data['lang_pte'] = $row->lang_pte;
        $data['gre'] = $row->gre;
        $data['gmat'] = $row->gmat;
        $data['toefl'] = $row->toefl;
        $data['duolingo'] = $row->duolingo;
        $data['grad_provisional'] = $row->grad_provisional;
        $data['pg_provisional'] = $row->pg_provisional;
        $data['cmm'] = $row->cmm;

        //$data['cv'] = $user->cv;

        // $row_sop = DB::table('user_docs_other')->where('userid', $userid)->where('doc_type', 'sop')->first();
        // $row_lor = DB::table('user_docs_other')->where('userid', $userid)->where('doc_type', 'letter_of_recommendation')->first();
        // $data['sop'] = $row_sop ? $row_sop->file : '';
        // $data['letter_recom'] = $row_lor ? $row_lor->file : '';

        $cv = "";
        $sops = array();
        $lors = array();
        $internships = array();
        $offerletters = array();
        $experience = array();
        $passports = array();
        $payslips = array();
        $otherdocs = array();

        $rows = DB::table('user_docs_other')->where('userid', $userid)->get();
        if ($rows) {
            foreach ($rows as $row) {
                if ($row->doc_type == 'passport') {
                    $passports[] = $row;
                } elseif ($row->doc_type == 'cv') {
                    $cv = $row->file;
                } elseif ($row->doc_type == 'sop') {
                    $sops[] = $row->file;
                } elseif ($row->doc_type == 'letter_of_recommendation') {
                    $lors[] = $row;
                } elseif ($row->doc_type == 'internship') {
                    $internships[] = $row->file;
                } elseif ($row->doc_type == 'offer') {
                    $offerletters[] = $row->file;
                } elseif ($row->doc_type == 'experience') {
                    $experience[] = $row;
                } elseif ($row->doc_type == 'payslip') {
                    $payslips[] = $row->file;
                } elseif ($row->doc_type == 'other') {
                    $otherdocs[] = $row;
                }
            }
        }

        $data['passports'] = $passports;
        $data['cv'] = $cv;
        $data['sops'] = $sops;
        $data['lors'] = $lors;
        $data['internships'] = $internships;
        $data['offerletters'] = $offerletters;
        $data['experience'] = $experience;
        $data['payslips'] = $payslips;
        $data['otherdocs'] = $otherdocs;

        $terms_content = "";
        if (get_site_config('student_application_terms_page')) {
            $page = Posts::find(get_site_config('student_application_terms_page'));
            if ($page) {
                $terms_content = $page->intro . $page->content;
            }
        }
        $data['terms_content'] = $terms_content;
        $course_pref = DB::table('course_preference')->where('userid', $userid)->get();
        $data['course_pref'] = $course_pref;

        $countries = DB::table('university_application')->where('userid', $userid)->get(['country']);
        $user_countries = array();
        foreach ($countries as $country) {
            $user_countries[] = $country->country;
        }


        $additional_docs_one = DB::table('additional_docs_configs')
            ->when(count($user_countries), function ($query) use ($user_countries) {
                return $query->Where(function ($query) use ($user_countries) {
                    foreach ($user_countries as $key) {
                        $query->orwhere('countries', 'LIKE', "%$key%");
                    }
                    $query->orWhere('countries', 'all');
                });
            })
            ->when(!count($user_countries), function ($query) use ($user_countries) {
                return $query->Where('countries', 'all');
            })
            ->where('status', 1)
            ->where('section_id', 1)
            ->orderBy('display_order')
            ->get();
        $additional_docs_two = DB::table('additional_docs_configs')
            ->when(count($user_countries), function ($query) use ($user_countries) {
                return $query->Where(function ($query) use ($user_countries) {
                    foreach ($user_countries as $key) {
                        $query->orwhere('countries', 'LIKE', "%$key%");
                    }
                    $query->orWhere('countries', 'all');
                });
            })
            ->when(!count($user_countries), function ($query) use ($user_countries) {
                return $query->Where('countries', 'all');
            })
            ->where('status', 1)
            ->where('section_id', 2)
            ->orderBy('display_order')
            ->get();
        $additional_docs_three = DB::table('additional_docs_configs')
            ->when(count($user_countries), function ($query) use ($user_countries) {
                return $query->Where(function ($query) use ($user_countries) {
                    foreach ($user_countries as $key) {
                        $query->orwhere('countries', 'LIKE', "%$key%");
                    }
                    $query->orWhere('countries', 'all');
                });
            })
            ->when(!count($user_countries), function ($query) use ($user_countries) {
                return $query->Where('countries', 'all');
            })
            ->where('status', 1)
            ->where('section_id', 3)
            ->orderBy('display_order')
            ->get();

        $data['additional_docs_one'] = $additional_docs_one;
        $data['additional_docs_two'] = $additional_docs_two;
        $data['additional_docs_three'] = $additional_docs_three;


        return view('frontend.user.studyabroad_apply.docs_upload', $data);
    }


    public function showVisaDocumentsUpload()
    {
        $user = \Auth::user();
        $userid = $user->id;
        $data = array();

        if ($user->profile_complete == 'documents') {
            $coursepref_pending = false;
            $can_edit = false;
        } elseif ($user->profile_complete == 'course') {
            $coursepref_pending = false;
            $can_edit = true;
        } elseif ($user->profile_complete == 'personal') {
            $coursepref_pending = true;
            $can_edit = false;
        } else {
            $coursepref_pending = true;
            $can_edit = false;
        }
        $data['coursepref_pending'] = $coursepref_pending;
        $data['can_edit'] = $can_edit;

        if (!DB::table('user_documents')->where('userid', $userid)->exists()) {
            DB::table('user_documents')->insert(['userid' => $userid]);
        }

        $row = DB::table('user_documents')->where('userid', $userid)->first();
        $data['class10'] = $row->class10;
        $data['class10_marks_sheet'] = $row->class10_marks_sheet;
        $data['class12'] = $row->class12;
        $data['class12_marks_sheet'] = $row->class12_marks_sheet;
        $data['diploma'] = $row->diploma;
        $data['diploma_marks_sheet'] = $row->diploma_marks_sheet;
        $data['grad_all_sem'] = $row->grad_all_sem;
        $data['grad_degree'] = $row->grad_degree;
        $data['grad_transcripts'] = $row->grad_transcripts;
        $data['pg_all_sem'] = $row->pg_all_sem;
        $data['pg_degree'] = $row->pg_degree;
        $data['pg_transcripts'] = $row->pg_transcripts;
        $data['lang_ielts'] = $row->lang_ielts;
        $data['lang_pte'] = $row->lang_pte;
        $data['gre'] = $row->gre;
        $data['gmat'] = $row->gmat;

        $passport = $cv = "";
        $sops = array();
        $lors = array();
        $internships = array();
        $offerletters = array();
        $experience = array();
        $payslips = array();
        $otherdocs = array();

        $rows = DB::table('user_docs_other')->where('userid', $userid)->get();
        if ($rows) {
            foreach ($rows as $row) {
                if ($row->doc_type == 'passport') {
                    $passport = $row->file;
                } elseif ($row->doc_type == 'cv') {
                    $cv = $row->file;
                } elseif ($row->doc_type == 'sop') {
                    $sops[] = $row;
                } elseif ($row->doc_type == 'letter_of_recommendation') {
                    $lors[] = $row;
                } elseif ($row->doc_type == 'internship') {
                    $internships[] = $row->file;
                } elseif ($row->doc_type == 'offer') {
                    $offerletters[] = $row->file;
                } elseif ($row->doc_type == 'experience') {
                    $experience[] = $row;
                } elseif ($row->doc_type == 'payslip') {
                    $payslips[] = $row->file;
                } elseif ($row->doc_type == 'other') {
                    $otherdocs[] = $row;
                }
            }
        }

        $data['passport'] = $passport;
        $data['cv'] = $cv;
        $data['sops'] = $sops;
        $data['lors'] = $lors;
        $data['internships'] = $internships;
        $data['offerletters'] = $offerletters;
        $data['experience'] = $experience;
        $data['payslips'] = $payslips;
        $data['otherdocs'] = $otherdocs;

        // $terms_content = "";
        // if (get_site_config('student_application_terms_page')) {
        //     $page = Posts::find(get_site_config('student_application_terms_page'));
        //     if ($page) {
        //         $terms_content = $page->intro . $page->content;
        //     }
        // }
        // $data['terms_content'] = $terms_content;
        //$course_pref = DB::table('course_preference')->where('userid', $userid)->get();
        //$data['course_pref'] = $course_pref;
        return view('frontend.user.visa_apply.docs_upload', $data);
    }


    /** Profile */
    public function storeBasicProfile(Request $request)
    {
        $request->validate([
            'first_name' => 'required|max:50|regex:/^[\pL\s]+$/u',
            'middle_name' => 'nullable|max:50|regex:/^[\pL\s]+$/u',
            'last_name' => 'required|max:50|regex:/^[\pL\s]+$/u',
            'gender' => 'required',
            'dob' => 'required|date_format:d-m-Y|before:' . now()->subYears(16)->toDateString(),
            'country' => 'required',
            'state' => 'required',
            'city' => 'required',
            'address' => 'required|max:200',
            'country_interested' => 'required',
            'whatsapp_dialcode'  => 'nullable|numeric|digits_between:' . config('app.USER_MOBILE_MIN_LENGTH') . ',' . config('app.USER_MOBILE_MAX_LENGTH'),

            'nationality' => 'required',
            'citizenship' => 'required',
            'country_of_education' => 'required',
            'highest_level_education' => 'required',

            'post_code' => 'nullable|max:20',
            'name_passport' => 'nullable|max:150',
            'passport_num' => 'nullable|max:50',
        ]);
        //Checking custom attributes
        $custom_attributes = DB::table('custom_attributes')->where('for_student', 1)->orderBy('display_order', 'asc')->get(["custom_attributes.*"]);
        $attributes_json = "";
        // echo "<pre>";
        if (count($custom_attributes)) {
            $all_atts = array();
            //print_r($custom_attributes);

            foreach ($custom_attributes as $attrs) {
                $name = $attrs->attr_name;
                $all_atts[$attrs->attr_name] = $request->$name;
                if ($attrs->laravel_rules) {
                    $request->validate([
                        "$attrs->attr_name" => "$attrs->laravel_rules",
                    ]);
                }
            }
            $attributes_json = json_encode($all_atts);
        }
        //exit();
        //Checking custom attributes

        if ($request->input('dual_citizenship') == '1') {
            $request->validate([
                'dual_citizenship_country' => 'required',
            ]);
        }
        if ($request->input('studying_abroad') == '1') {
            $request->validate([
                'studying_abroad_country' => 'required',
            ]);
        }
        if ($request->input('immigration') == '1') {
            $request->validate([
                'immigration_country' => 'required',
            ]);
        }
        if ($request->input('visa_refusal') == '1') {
            $request->validate([
                'visa_refusal_country' => 'required',
            ]);
        }

        $user = \Auth::user();
        $image = "";
        if ($request->has('avatar_location')) {
            $request->validate([
                'avatar_location' => 'image|mimes:jpeg,jpg',
            ]);
            $image = $request->file('avatar_location');
        } else {
            $image = false;
        }

        $service_interested = "";
        $service_pref = $request->input('services');
        if (!empty($service_pref) && count($service_pref)) {
            $service_interested = implode(",", $request->get('services'));
        }

        $country_interested_in = "";
        $country_pref = $request->input('country_interested');
        if (!empty($country_pref) && count($country_pref)) {
            $country_interested_in = implode(",", $request->get('country_interested'));
        }

        $user->first_name = $request->input('first_name');
        $user->middle_name = $request->input('middle_name');
        $user->last_name = $request->input('last_name');
        $user->gender = $request->input('gender');
        $user->birthday = substr($request->input('dob'), 6, 4) . "-" . substr($request->input('dob'), 3, 2) . "-" . substr($request->input('dob'), 0, 2);
        $user->country = $request->input('country');
        $user->address_1 = $request->input('address');
        $user->state = $request->input('state');
        $user->city = $request->input('city');
        $user->post_code = $request->input('post_code');
        $user->country_interested = $country_interested_in;
        $user->services = $service_interested;
        $user->profile_complete = 'personal';

        $study_degre = NULL;
        if ($request->input('overseas_study_level')) {
            $study_degree = get_study_level_degree_level($request->input('overseas_study_level'));
        }

        $user->overseas_study_level = $study_degree;
        $user->overseas_study_level_selection = $request->input('overseas_study_level');

        if ($image) {
            $user->avatar_type = 'storage';
            $extension = $image->extension();
            if (in_array($extension, array('jpg', 'jpeg'))) {
                if ($image->getSize() < 2048000) { //max size 2MB
                    $filename = pathinfo($image->getClientOriginalName(), PATHINFO_FILENAME);
                    if (strlen($filename) > 100) {
                        $filename = substr($filename, 0, 100);
                    }
                    $filename = $filename . Str::random(10) . "." . $image->getClientOriginalExtension();
                    $user->avatar_location = $image->storeAs('/avatars', $filename, 'public');
                } else {
                    throw new GeneralException('Profile pic size must not exceed 2MB');
                }
            } else {
                throw new GeneralException('You must upload a valid profile pic (jpg/png).');
            }
        } else {
            // If there is no existing image
            //if (! strlen()->user()->avatar_location)) {
            //    throw new GeneralException('You must supply a profile image.');
            //}
        }

        $user->save();

        //Saving User Details
        // $details = UserDetails::find($user->id);
        $details = UserDetails::firstOrNew(array('userid' => $user->id));
        $details->marital_status = $request->input('marital_status');
        $details->name_passport = $request->input('name_passport');
        $details->passport_num = $request->input('passport_num');
        $details->user_data_js = $attributes_json;

        if (!empty($request->input('issue_date'))) {
            $details->passport_issue_date = substr($request->input('issue_date'), 6, 4) . "-" . substr($request->input('issue_date'), 3, 2) . "-" . substr($request->input('issue_date'), 0, 2);
        }
        if (!empty($request->input('expiry_date'))) {
            $details->passport_expiry_date = substr($request->input('expiry_date'), 6, 4) . "-" . substr($request->input('expiry_date'), 3, 2) . "-" . substr($request->input('expiry_date'), 0, 2);
        }
        $details->passport_country = $request->input('passport_country');
        $details->city_of_birth = $request->input('city_of_birth');
        $details->country_of_birth = $request->input('country_of_birth');
        $details->nationality = $request->input('nationality');
        $details->citizenship = $request->input('citizenship');

        $details->dual_citizenship = $request->input('dual_citizenship');
        if ($request->input('dual_citizenship') == '1') {
            $details->dual_citizenship_country = $request->input('dual_citizenship_country');
        } else {
            $details->dual_citizenship_country = '';
        }

        $details->studying_abroad = $request->input('studying_abroad');
        if ($request->input('studying_abroad') == '1') {
            $details->studying_abroad_country = $request->input('studying_abroad_country');
        } else {
            $details->studying_abroad_country = '';
        }

        $details->immigration = $request->input('immigration');
        if ($request->input('immigration') == '1') {
            $details->immigration_country = $request->input('immigration_country');
        } else {
            $details->immigration_country = '';
        }

        $details->medical_condition = $request->input('medical_condition');
        $details->visa_refusal = $request->input('visa_refusal');
        if ($request->input('visa_refusal') == '1') {
            $details->visa_refusal_country = $request->input('visa_refusal_country');
        } else {
            $details->visa_refusal_country = '';
        }

        $details->criminal_offence = $request->input('criminal_offence');

        if ($request->input('same_as_current') == 1) {
            // $details->same_address = $request->input('same_as_current');
            $details->permanent_address = $request->input('address');
            $details->permanent_city = $request->input('city');
            $details->permanent_state = $request->input('state');
            $details->permanent_country = $request->input('country');
            $details->permanent_post_code = $request->input('post_code');
        } else {
            // $details->same_address = $request->input('same_as_current');
            $details->permanent_address = $request->input('permanent_address');
            $details->permanent_city = $request->input('permanent_city');
            $details->permanent_state = $request->input('permanent_state');
            $details->permanent_country = $request->input('permanent_country');
            $details->permanent_post_code = $request->input('permanent_post_code');
        }

        $details->emergency_name = $request->input('emergency_name');
        $details->emergency_phone = $request->input('emergency_phone');
        $details->emergency_email = $request->input('emergency_email');
        $details->emergency_relation = $request->input('emergency_relation');
        $details->emergency_address = $request->input('emergency_address');
        $details->emergency_country = $request->input('emergency_country');
        $details->emergency_state = $request->input('emergency_state');
        $details->emergency_city = $request->input('emergency_city');
        $details->emergency_postalcode = $request->input('emergency_postalcode');

        $details->study_permit = $request->input('study_permit');

        $details->accommodation = $request->input('accommodation');
        $details->education_loan = $request->input('education_loan');
        $details->country_of_education = $request->input('country_of_education');
        $details->highest_level_education = $request->input('highest_level_education');

        $details->save();

        //Sending email Notification
        $subject = "Student Profile Updated";
        $email_message = "Hi, <br><br>Student Profile Updated by " . _label('backend_student') . ": " . $user->full_name . " (" . $user->id . ")<br><strong>Student Details:</strong><br/>Name: " . $user->first_name . " " . $user->last_name . "<br />Mob: " . $user->mobile . "<br />Email: " . $user->email;
        send_mail_notification($user->id, "", "STUDENT_PROFILE_UPDATED", $subject, $email_message);

        // Send Push App Notification
        $subject = "";
        $message = "Profile updated by " . _label('backend_student') . " <strong>" . $user->full_name . "</strong> (" . $user->id . ")";
        send_in_app_notification(
            $user->id,
            $user->id,
            "STUDENT_PROFILE_UPDATED",
            $subject,
            $message,
            "student",
        );

        if ($user->overseas_status == "Pending") {
            update_student_overseas_status($user->id);
        }

        return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess(__('labels.frontend.user.profile.profile_updated_successfully'));
    }

    // public function storeAcademicProfile(Request $request)
    // {
    //     $userid = \Auth::user()->id;
    //     $data = $request->all();

    //     $aca_level = array('10', '12', 'Diploma', 'Bachelors', 'Masters', 'Other');
    //     for ($i = 0; $i < count($aca_level); $i++) {
    //         $exam_name = $aca_level[$i];
    //         $percent_cgpa = $data['aca'][$exam_name]['percent_cgpa'];
    //         $pass_year = $data['aca'][$exam_name]['pass_year'];
    //         $specialization = $data['aca'][$exam_name]['specialization'];
    //         $school_college = $data['aca'][$exam_name]['school_college'];
    //         $university = $data['aca'][$exam_name]['university'];
    //         //$backlogs = $data['aca'][$exam_name]['backlogs'];

    //         DB::table('user_academics')
    //             ->updateOrInsert(
    //                 ['userid' => $userid, 'education_level' => $exam_name],
    //                 [
    //                     'percent_cgpa' => $percent_cgpa,
    //                     'pass_year' => $pass_year,
    //                     'specialization' => $specialization,
    //                     'school_college' => $school_college,
    //                     'university' => $university,
    //                     //'backlogs' => $backlogs
    //                 ]
    //             );
    //     }
    //     return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess(__('labels.frontend.user.profile.academic_details_updated_successfully'));

    // }

    //add acedemic details
    public function storeAcademicProfile(Request $request)
    {

        $request->validate([
            'education_level' => 'required|max:100',
            'course_name' => 'max:100',
            'institute' => 'required|max:100',
            'university' => 'required|max:100',
            'institute_country' => 'required|numeric',
            'campus_city' => 'max:100',
            'postal_code' => 'max:45',
            'start_year' => 'nullable|numeric|before_or_equal:' . now()->year,
            'pass_year' => 'required|numeric|before_or_equal:' . now()->year,
            'percent_cgpa' => 'required|numeric',
            'course_name' => 'required|max:100',
            'course_status' => 'required|max:50',
        ]);
        if ($request->start_year) {

            $request->validate(['pass_year' => 'after_or_equal:' . $request->start_year]);
        }
        if ($request->academics_id) {
            $userAcademicsDetail = DB::table('user_academics')->where('id', $request->academics_id)->update([
                'userid'    => $request->get('userid'),
                'education_level' => $request->get('education_level'),
                'course_name' => $request->get('course_name'),
                'institute' => $request->get('institute'),
                'university' => $request->get('university'),
                'institute_country' => $request->get('institute_country'),
                'campus_city' => $request->get('campus_city'),
                'postal_code' => $request->get('postal_code'),
                'start_year' => $request->get('start_year'),
                'pass_year' => $request->get('pass_year'),
                'course_status' => $request->get('course_status'),
                'percent_cgpa' => $request->get('percent_cgpa'),
            ]);
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess("Academics Details Updated Successfully");
        } else {
            $userAcademicsDetail = DB::table('user_academics')->insert([
                'userid'    => $request->get('user_id'),
                'education_level' => $request->get('education_level'),
                'course_name' => $request->get('course_name'),
                'institute' => $request->get('institute'),
                'university' => $request->get('university'),
                'institute_country' => $request->get('institute_country'),
                'campus_city' => $request->get('campus_city'),
                'postal_code' => $request->get('postal_code'),
                'start_year' => $request->get('start_year'),
                'pass_year' => $request->get('pass_year'),
                'course_status' => $request->get('course_status'),
                'percent_cgpa' => $request->get('percent_cgpa'),
            ]);
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess("Academics Details Added Successfully");
        }
    }

    // public function storeLanguagesProfile(Request $request)
    // {
    //     $userid = \Auth::user()->id;
    //     $data = $request->all();

    //     $eng_exam = array('IELTS', 'TOEFL', 'PTE');
    //     for ($i = 0; $i < count($eng_exam); $i++) {
    //         $exam_name = $eng_exam[$i];
    //         $overall_score = $data['eng'][$exam_name]['overall_score'];
    //         $speaking = $data['eng'][$exam_name]['speaking'];
    //         $reading = $data['eng'][$exam_name]['reading'];
    //         $listening = $data['eng'][$exam_name]['listening'];
    //         $writing = $data['eng'][$exam_name]['writing'];
    //         $expiry_date = $data['eng'][$exam_name]['expiry_date'];
    //         if ($expiry_date) {
    //             $expiry_date_db = date("Y-m-d", strtotime(substr($expiry_date, 6, 4) . "-" . substr($expiry_date, 3, 2) . "-" . substr($expiry_date, 0, 2)));
    //         } else {
    //             $expiry_date_db = NULL;
    //         }

    //         DB::table('user_certification_eng')
    //             ->updateOrInsert(
    //                 ['userid' => $userid, 'exam' => $exam_name],
    //                 [
    //                     'overall_score' => $overall_score,
    //                     'speaking' => $speaking,
    //                     'reading' => $reading,
    //                     'listening' => $listening,
    //                     'writing' => $writing,
    //                     'expiry_date' => $expiry_date_db
    //                 ]
    //             );
    //     }

    //     //DET
    //     if (!empty($request->input('det_overall_score'))) {
    //         $det_expiry_date = $request->input('det_expiry_date');
    //         if ($det_expiry_date) {
    //             $det_expiry_date_db = date("Y-m-d", strtotime(substr($det_expiry_date, 6, 4) . "-" . substr($det_expiry_date, 3, 2) . "-" . substr($det_expiry_date, 0, 2)));
    //         } else {
    //             $det_expiry_date_db = NULL;
    //         }
    //         DB::table('user_certification_eng')
    //             ->updateOrInsert(
    //                 ['userid' => $userid, 'exam' => 'DET'],
    //                 [
    //                     'overall_score' => $request->input('det_overall_score'),
    //                     'expiry_date' => $det_expiry_date_db
    //                 ]
    //             );
    //     }

    //     //ACT
    //     if (!empty($request->input('act_overall_score'))) {
    //         $act_expiry_date = $request->input('act_expiry_date');
    //         if ($act_expiry_date) {
    //             $act_expiry_date_db = date("Y-m-d", strtotime(substr($act_expiry_date, 6, 4) . "-" . substr($act_expiry_date, 3, 2) . "-" . substr($act_expiry_date, 0, 2)));
    //         } else {
    //             $act_expiry_date_db = NULL;
    //         }
    //         DB::table('user_certification_eng')
    //             ->updateOrInsert(
    //                 ['userid' => $userid, 'exam' => 'ACT'],
    //                 [
    //                     'overall_score' => $request->input('act_overall_score'),
    //                     'math' => $request->input('act_math'),
    //                     'reading' => $request->input('act_reading'),
    //                     'writing' => $request->input('act_writing'),
    //                     'science' => $request->input('act_science'),
    //                     'english' => $request->input('act_english'),
    //                     'expiry_date' => $act_expiry_date_db
    //                 ]
    //             );
    //     }

    //     //SAT
    //     if (!empty($request->input('sat_overall_score'))) {
    //         $sat_expiry_date = $request->input('sat_expiry_date');
    //         if ($sat_expiry_date) {
    //             $sat_expiry_date_db = date("Y-m-d", strtotime(substr($sat_expiry_date, 6, 4) . "-" . substr($sat_expiry_date, 3, 2) . "-" . substr($sat_expiry_date, 0, 2)));
    //         } else {
    //             $sat_expiry_date_db = NULL;
    //         }
    //         DB::table('user_certification_eng')
    //             ->updateOrInsert(
    //                 ['userid' => $userid, 'exam' => 'SAT'],
    //                 [
    //                     'overall_score' => $request->input('sat_overall_score'),
    //                     'math' => $request->input('sat_math'),
    //                     'reading' => $request->input('sat_reading'),
    //                     'writing' => $request->input('sat_writing'),
    //                     'essay' => $request->input('sat_essay'),
    //                     'expiry_date' => $sat_expiry_date_db
    //                 ]
    //             );
    //     }

    //     $lang_exam = array('German', 'French', 'Spanish', 'Japanese');
    //     for ($i = 0; $i < count($lang_exam); $i++) {
    //         $exam_name = $lang_exam[$i];
    //         $level = $data['lang'][$exam_name]['level'];
    //         $overall_score = $data['lang'][$exam_name]['overall_score'];
    //         $speaking = $data['lang'][$exam_name]['speaking'];
    //         $reading = $data['lang'][$exam_name]['reading'];
    //         $listening = $data['lang'][$exam_name]['listening'];
    //         $writing = $data['lang'][$exam_name]['writing'];
    //         $institute = $data['lang'][$exam_name]['institute'];

    //         if (!empty($level)) {
    //             DB::table('user_certification_lang')
    //                 ->updateOrInsert(
    //                     ['userid' => $userid, 'language' => $exam_name, 'level' => $level],
    //                     [
    //                         'overall_score' => $overall_score,
    //                         'speaking' => $speaking,
    //                         'reading' => $reading,
    //                         'listening' => $listening,
    //                         'writing' => $writing,
    //                         'institute' => $institute
    //                     ]
    //                 );
    //         }
    //     }
    //     return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess(__('labels.frontend.user.profile.language_certification_details_updated_successfully'));
    // }
    public function storeLanguagesProfile(Request $request)
    {
        $userid = \Auth::user()->id;
        $data = $request->all();

        $eng_exam = array('IELTS', 'TOEFL', 'PTE');
        for ($i = 0; $i < count($eng_exam); $i++) {
            $exam_name = $eng_exam[$i];
            $overall_score = $data['eng'][$exam_name]['overall_score'];
            $speaking = $data['eng'][$exam_name]['speaking'];
            $reading = $data['eng'][$exam_name]['reading'];
            $listening = $data['eng'][$exam_name]['listening'];
            $writing = $data['eng'][$exam_name]['writing'];
            $expiry_date = $data['eng'][$exam_name]['expiry_date'];
            if ($expiry_date) {
                $expiry_date_db = date("Y-m-d", strtotime(substr($expiry_date, 6, 4) . "-" . substr($expiry_date, 3, 2) . "-" . substr($expiry_date, 0, 2)));
            } else {
                $expiry_date_db = NULL;
            }

            DB::table('user_certification_eng')
                ->updateOrInsert(
                    ['userid' => $userid, 'exam' => $exam_name],
                    [
                        'overall_score' => $overall_score,
                        'speaking' => $speaking,
                        'reading' => $reading,
                        'listening' => $listening,
                        'writing' => $writing,
                        'expiry_date' => $expiry_date_db
                    ]
                );
        }

        //DET
        if (!empty($request->input('det_overall_score'))) {
            $det_expiry_date = $request->input('det_expiry_date');
            if ($det_expiry_date) {
                $det_expiry_date_db = date("Y-m-d", strtotime(substr($det_expiry_date, 6, 4) . "-" . substr($det_expiry_date, 3, 2) . "-" . substr($det_expiry_date, 0, 2)));
            } else {
                $det_expiry_date_db = NULL;
            }
            DB::table('user_certification_eng')
                ->updateOrInsert(
                    ['userid' => $userid, 'exam' => 'DET'],
                    [
                        'overall_score' => $request->input('det_overall_score'),
                        'expiry_date' => $det_expiry_date_db
                    ]
                );
        }

        //ACT
        if (!empty($request->input('act_overall_score'))) {
            $act_expiry_date = $request->input('act_expiry_date');
            if ($act_expiry_date) {
                $act_expiry_date_db = date("Y-m-d", strtotime(substr($act_expiry_date, 6, 4) . "-" . substr($act_expiry_date, 3, 2) . "-" . substr($act_expiry_date, 0, 2)));
            } else {
                $act_expiry_date_db = NULL;
            }
            DB::table('user_certification_eng')
                ->updateOrInsert(
                    ['userid' => $userid, 'exam' => 'ACT'],
                    [
                        'overall_score' => $request->input('act_overall_score'),
                        'math' => $request->input('act_math'),
                        'reading' => $request->input('act_reading'),
                        'writing' => $request->input('act_writing'),
                        'science' => $request->input('act_science'),
                        'english' => $request->input('act_english'),
                        'expiry_date' => $act_expiry_date_db
                    ]
                );
        }

        //SAT
        if (!empty($request->input('sat_overall_score'))) {
            $sat_expiry_date = $request->input('sat_expiry_date');
            if ($sat_expiry_date) {
                $sat_expiry_date_db = date("Y-m-d", strtotime(substr($sat_expiry_date, 6, 4) . "-" . substr($sat_expiry_date, 3, 2) . "-" . substr($sat_expiry_date, 0, 2)));
            } else {
                $sat_expiry_date_db = NULL;
            }
            DB::table('user_certification_eng')
                ->updateOrInsert(
                    ['userid' => $userid, 'exam' => 'SAT'],
                    [
                        'overall_score' => $request->input('sat_overall_score'),
                        'math' => $request->input('sat_math'),
                        'reading' => $request->input('sat_reading'),
                        'writing' => $request->input('sat_writing'),
                        'essay' => $request->input('sat_essay'),
                        'expiry_date' => $sat_expiry_date_db
                    ]
                );
        }

        $lang_exam = array('German', 'French', 'Spanish', 'Japanese');
        for ($i = 0; $i < count($lang_exam); $i++) {
            $exam_name = $lang_exam[$i];
            $level = $data['lang'][$exam_name]['level'];
            $overall_score = $data['lang'][$exam_name]['overall_score'];
            $speaking = $data['lang'][$exam_name]['speaking'];
            $reading = $data['lang'][$exam_name]['reading'];
            $listening = $data['lang'][$exam_name]['listening'];
            $writing = $data['lang'][$exam_name]['writing'];
            $institute = $data['lang'][$exam_name]['institute'];

            if (!empty($level)) {
                DB::table('user_certification_lang')
                    ->updateOrInsert(
                        ['userid' => $userid, 'language' => $exam_name, 'level' => $level],
                        [
                            'overall_score' => $overall_score,
                            'speaking' => $speaking,
                            'reading' => $reading,
                            'listening' => $listening,
                            'writing' => $writing,
                            'institute' => $institute
                        ]
                    );
            }
        }

        // $userid = $request->input('user_id');
        // $data = $request->all();

        if ($data['exam']['gre']['expiry_date']) {
            $gre_exp_dt = $data['exam']['gre']['expiry_date'];
            $gre_exp_dt_db = date("Y-m-d", strtotime(substr($gre_exp_dt, 6, 4) . "-" . substr($gre_exp_dt, 3, 2) . "-" . substr($gre_exp_dt, 0, 2)));
        } else {
            $gre_exp_dt_db = NULL;
        }

        if ($data['exam']['gmat']['expiry_date']) {
            $gmat_exp_dt = $data['exam']['gmat']['expiry_date'];
            $gmat_exp_dt_db = date("Y-m-d", strtotime(substr($gmat_exp_dt, 6, 4) . "-" . substr($gmat_exp_dt, 3, 2) . "-" . substr($gmat_exp_dt, 0, 2)));
        } else {
            $gmat_exp_dt_db = NULL;
        }

        DB::table('user_gre_gmat')
            ->updateOrInsert(
                ['userid' => $userid, 'exam' => 'GRE'],
                [
                    'total_score' => $data['exam']['gre']['total_score'],
                    'verbal' => $data['exam']['gre']['verbal'],
                    'quantitative' => $data['exam']['gre']['quantitative'],
                    'analytical' => $data['exam']['gre']['analytical'],
                    'integrated' => $data['exam']['gre']['integrated'],
                    'expiry_date' => $gre_exp_dt_db
                ]
            );

        DB::table('user_gre_gmat')
            ->updateOrInsert(
                ['userid' => $userid, 'exam' => 'GMAT'],
                [
                    'total_score' => $data['exam']['gmat']['total_score'],
                    'verbal' => $data['exam']['gmat']['verbal'],
                    'quantitative' => $data['exam']['gmat']['quantitative'],
                    'analytical' => $data['exam']['gmat']['analytical'],
                    'integrated' => $data['exam']['gmat']['integrated'],
                    'expiry_date' => $gmat_exp_dt_db
                ]
            );

        return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess("Language certification details updated successfully");
    }

    public function storeGreGmatProfile(Request $request)
    {
        $userid = \Auth::user()->id;
        $data = $request->all();

        if ($data['exam']['gre']['expiry_date']) {
            $gre_exp_dt = $data['exam']['gre']['expiry_date'];
            $gre_exp_dt_db = date("Y-m-d", strtotime(substr($gre_exp_dt, 6, 4) . "-" . substr($gre_exp_dt, 3, 2) . "-" . substr($gre_exp_dt, 0, 2)));
        } else {
            $gre_exp_dt_db = NULL;
        }

        if ($data['exam']['gmat']['expiry_date']) {
            $gmat_exp_dt = $data['exam']['gmat']['expiry_date'];
            $gmat_exp_dt_db = date("Y-m-d", strtotime(substr($gmat_exp_dt, 6, 4) . "-" . substr($gmat_exp_dt, 3, 2) . "-" . substr($gmat_exp_dt, 0, 2)));
        } else {
            $gmat_exp_dt_db = NULL;
        }

        DB::table('user_gre_gmat')
            ->updateOrInsert(
                ['userid' => $userid, 'exam' => 'GRE'],
                [
                    'total_score' => $data['exam']['gre']['total_score'],
                    'verbal' => $data['exam']['gre']['verbal'],
                    'quantitative' => $data['exam']['gre']['quantitative'],
                    'analytical' => $data['exam']['gre']['analytical'],
                    'integrated' => $data['exam']['gre']['integrated'],
                    'expiry_date' => $gre_exp_dt_db
                ]
            );

        DB::table('user_gre_gmat')
            ->updateOrInsert(
                ['userid' => $userid, 'exam' => 'GMAT'],
                [
                    'total_score' => $data['exam']['gmat']['total_score'],
                    'verbal' => $data['exam']['gmat']['verbal'],
                    'quantitative' => $data['exam']['gmat']['quantitative'],
                    'analytical' => $data['exam']['gmat']['analytical'],
                    'integrated' => $data['exam']['gmat']['integrated'],
                    'expiry_date' => $gmat_exp_dt_db
                ]
            );

        return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess(__('labels.frontend.user.profile.GRE/GMAT_details_updated_successfully'));
    }

    // public function storeInternshipsProfile(Request $request)
    // {
    //     $userid = \Auth::user()->id;
    //     $data = $request->all();

    //     for ($i = 0; $i < count($data['internship']); $i++) {
    //         $internship = $data['internship'][$i];
    //         $company = $internship['company'];
    //         $duration = $internship['duration'];
    //         $place = $internship['place'];

    //         if (!empty($company) && !empty($duration)) {
    //             DB::table('user_internship')
    //                 ->updateOrInsert(
    //                     ['userid' => $userid, 'company' => $company],
    //                     [
    //                         'duration' => $duration,
    //                         'place' => $place
    //                     ]
    //                 );
    //         }
    //     }

    //     for ($i = 0; $i < count($data['course']); $i++) {
    //         $course = $data['course'][$i];
    //         $course_name = $course['course'];
    //         $duration = $course['duration'];
    //         $institute = $course['institute'];

    //         if (!empty($course_name)) {
    //             DB::table('user_courses')
    //                 ->updateOrInsert(
    //                     ['userid' => $userid, 'course' => $course_name],
    //                     [
    //                         'duration' => $duration,
    //                         'institute' => $institute
    //                     ]
    //                 );
    //         }
    //     }
    //     return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess(__('labels.frontend.user.profile.internship_details_updated_successfully'));

    // }
    //add internship profile
    public function storeInternshipProfile(Request $request)
    {

        $request->validate([
            'company' => 'required|max:100',
            'duration' => 'required|max:100',
            'place' => 'required|max:100',

        ]);
        if ($request->internship_id) {
            $userAcademicsDetail = DB::table('user_internship')->where('id', $request->internship_id)->update([
                'userid'    => $request->get('userid'),
                'company' => $request->get('company'),
                'duration' => $request->get('duration'),
                'place' => $request->get('place'),

            ]);
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess("Internship Details Updated Successfully");
        } else {
            $userAcademicsDetail = DB::table('user_internship')->insert([
                'userid'    => $request->get('userid'),
                'company' => $request->get('company'),
                'duration' => $request->get('duration'),
                'place' => $request->get('place'),

            ]);
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess("Internship Details Added Successfully");
        }
    }

    public function storeExperienceProfile(Request $request)
    {
        $userid = \Auth::user()->id;
        $data = $request->all();

        for ($i = 0; $i < count($data['experience']); $i++) {
            $experience = $data['experience'][$i];
            $company = $experience['company'];
            $designation = $experience['designation'];
            $start_date = $experience['start_date'];
            $end_date = $experience['end_date'];
            if ($start_date) {
                $start_date_db = date("Y-m-d", strtotime(substr($start_date, 6, 4) . "-" . substr($start_date, 3, 2) . "-" . substr($start_date, 0, 2)));
            } else {
                $start_date_db = NULL;
            }
            if ($end_date) {
                $end_date_db = date("Y-m-d", strtotime(substr($end_date, 6, 4) . "-" . substr($end_date, 3, 2) . "-" . substr($end_date, 0, 2)));
            } else {
                $end_date_db = NULL;
            }

            if (!empty($company)) {
                DB::table('user_experience')
                    ->updateOrInsert(
                        ['userid' => $userid, 'company' => $company],
                        [
                            'designation' => $designation,
                            'start_date' => $start_date_db,
                            'end_date' => $end_date_db
                        ]
                    );
            }
        }

        return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess(__('labels.frontend.user.profile.experience_details_updated_successfully'));
    }


    /** Study Level */
    public function updateStudyLevel(Request $request)
    {
        $request->validate([
            'overseas_study_level' => 'required',
        ]);

        $user = \Auth::user();
        // $s_level =  $request->input('overseas_study_level');
        // if($s_level == "UG Diploma/ Certificate/ Associate Degree"
        // || $s_level == "UG"
        // || $s_level == "UG+PG (Accelerated) Degree" 
        // || $s_level == "Twinning Programmes (UG)"){
        //     $s_level = "Bachelors";
        // }
        // elseif($s_level == "PG Diploma/Certificate" 
        // || $s_level == "PG"
        // || $s_level == "Twinning Programmes (PG)"){
        //     $s_level = "Masters";
        // }
        // elseif($s_level == "PhD"){
        //     $s_level = "Ph.D";
        // }
        // else{
        //     $s_level = "Others";
        // }

        if ($request->input('overseas_study_level')) {
            $s_level = get_study_level_degree_level($request->input('overseas_study_level'));
        } else {
            $s_level = NULL;
        }

        $user->overseas_study_level = $s_level;
        $user->overseas_study_level_selection = $request->input('overseas_study_level');
        $user->save();

        return redirect()->back()->withFlashSuccess(__('labels.frontend.user.profile.experience_details_updated_successfully'));
    }

    public function addCoursePreference($id)
    {
        $course = CourseShortlisted::join('university_courses', 'university_courses.id', '=', 'course_shortlisted.course_id')
            ->join('universities', 'universities.id', '=', 'university_courses.university')
            ->select('course_shortlisted.*', 'university_courses.course_name', 'university_courses.university', 'university_courses.study_level', 'university_courses.campus', 'university_courses.duration', 'university_courses.intakes', 'university_courses.intakes', 'university_courses.year', 'universities.university_name', 'universities.country', 'universities.id')
            ->where('course_shortlisted.id', $id)
            ->first();

        if ($course) {
            $nmonth = date('m', strtotime($course->intakes));

            if (!DB::table('course_preference')
                ->where('userid', $course->student_id)
                ->where('course_id', $course->course_id)
                ->where('university_id', $course->university)
                ->where('country_id', $course->country)
                ->where('intake_year', $course->year)
                ->where('intake', $nmonth)
                ->exists()) {
                DB::table('course_preference')
                    ->insert([
                        'userid' => $course->student_id,
                        'course_id' => $course->course_id,
                        'university_id' => $course->university,
                        'country_id' => $course->country,
                        'intake_year' => $course->year,
                        'intake' => $nmonth,
                        'created_by' => \Auth::user()->id,
                    ]);

                return redirect()->route('frontend.user.coursesuggestion')->withFlashSuccess("Course Preferences Added Successfully");
            } else {
                return redirect()->route('frontend.user.coursesuggestion')->withFlashDanger("Course Preferences Already Exists!");
            }
        } else {
            return redirect()->route('frontend.user.coursesuggestion')->withFlashDanger("Course Not Found!");
        }
    }

    /** Course Preferences */
    public function storeCoursePreference(Request $request)
    {
        $request->validate([
            // 'course.0.country'  => 'required',
            // 'course.0.course_name'  => 'required',
            // // 'course.0.intake_year'  => 'required',
            // 'course.0.intake'  => 'required',
            'country'  => 'required',
            'university'  => 'required',
            'course'  => 'required',
            'intake'  => 'required',
        ]);

        if (filter_var($request->input('course'), FILTER_VALIDATE_INT) !== false) {
            $course = $request->input('course');
            $course_other = null;
        } else {
            $course = 0;
            $course_other = $request->input('course');
        }

        if (filter_var($request->input('university'), FILTER_VALIDATE_INT) !== false) {
            $university = $request->input('university');
            $university_other = null;
        } else {
            $university = 0;
            $university_other = $request->input('university');
        }

        $user = \Auth::user();
        $userid = $user->id;

        $intake = $request->input('intake');
        $inta =  explode(" ", $intake);
        $country = $request->input('country');
        // $university = $request->input('university');

        // $chk_pref = DB::table('course_preference')
        //     ->where('userid',$userid)
        //     ->where('intake',$inta[0])
        //     ->where('intake_year',$inta[1])
        //     ->where('country_id',$country)
        //     ->where('course_id',$course)
        //     ->where('university_id',$university)
        //     ->first();

        $chk_pref = DB::table('course_preference')
            ->where('userid', $userid)
            ->where('intake', $inta[0])
            ->where('intake_year', $inta[1])
            ->where('country_id', $country)
            ->where('course_id', $course)
            ->where('course_id', "!=", 0)
            ->where('university_id', $university)
            ->where('university_id', "!=", 0)
            ->first();

        if ($chk_pref) {
            return redirect()->route('frontend.user.studyabroad.coursepreference')->withFlashDanger("Course preferences already exists!");
        } else {

            DB::table('course_preference')
                ->insert(
                    [
                        'userid' => $userid,
                        'country_id' => $country,
                        'course_id' => $course,
                        'course_other' => $course_other,
                        'university_other' => $university_other,
                        'university_id' => $university,
                        'intake_year' => $inta[1],
                        'intake' => $inta[0],
                        'created_by' => \Auth::user()->id,
                        'created_at' => now()
                    ]
                );


            //DB::table('course_preference')->where('userid', $userid)->delete();

            // $data = $request->all();

            // for ($i = 0; $i < count($data['course']); $i++) {
            //     $intake_csv = "";
            //     $course = $data['course'][$i];
            //     $course_name = $course['course_name'];
            //     $country = $course['country'];
            //     $university = $course['university'];

            //         if (isset($course['intake'])) {
            //             $intake = $course['intake'];
            //             for ($g = 0; $g < count($intake); $g++) {
            //                 $inta =  explode(" ",$intake[$g]);
            //                 $chk_pref = DB::table('course_preference')
            //                 ->where('userid',$userid)
            //                 ->where('intake',$inta[0])
            //                 ->where('intake_year',$inta[1])
            //                 ->where('country',$country)
            //                 ->where('course',$course_name)
            //                 ->where('university',$university)
            //                 ->first();

            //                 if(!$chk_pref){
            //                     DB::table('course_preference')
            //                     ->insert(
            //                         [
            //                             'userid' => $userid,
            //                             'country' => $country,
            //                             'course' => $course_name,
            //                             'university' => $university,
            //                             'intake_year' => $inta[1],
            //                             'intake' => $inta[0]
            //                         ]
            //                     );
            //                 }
            //             }
            //         }

            // }

            $user->profile_complete = 'course';
            $user->save();

            update_student_overseas_status($user->id);

            //store event in user activity
            UserActivity::create(['user_id' => $user->id, 'type' => 'user_event', 'title' => "Student Added Course Preferences", 'detail' => ""]);

            //Sending email Notification
            $subject = "Course Preference Added by " . _label('backend_student') . ": " . $user->full_name . " (" . $user->id . ")";
            $email_message = "Hi, <br><br>Course Preference Added by " . _label('backend_student') . "<br /><strong>" . _label('backend_student') . " Details:</strong><br/>Name: " . $user->first_name . " " . $user->last_name . "<br />Mob: " . $user->mobile . "<br />Email: " . $user->email;
            send_mail_notification($userid, "", "COURSE_PREFERENCE_ADDED_BY_STUDENT", $subject, $email_message);

            // Send Push App Notification
            $subject = "";
            $message = "Course Preference added by " . _label('backend_student') . " <strong>" . $user->full_name . "</strong> (" . $user->id . ")";
            send_in_app_notification(
                $user->id,
                $user->id,
                "COURSE_PREFERENCE_ADDED_BY_STUDENT",
                $subject,
                $message,
                "student",
            );

            return redirect()->route('frontend.user.studyabroad.documents')->withFlashSuccess(__('labels.frontend.user.profile.course_preferences_updated_successfully'));
        }
    }


    /** Visa Preferences */
    public function storeVisaPreference(Request $request)
    {
        $request->validate([
            'visa.0.country'  => 'required',
            'visa.0.service_type'  => 'required',
            'visa.0.letter_type'  => 'required',
        ]);

        $user = \Auth::user();
        $userid = $user->id;

        DB::table('visa_preference')->where('userid', $userid)->delete();
        $data = $request->all();

        for ($i = 0; $i < count($data['visa']); $i++) {
            $row = $data['visa'][$i];
            $country = $row['country'];
            //ignore blank rows
            if ($country) {
                $service_type = $row['service_type'];
                $letter_type = $row['letter_type'];

                DB::table('visa_preference')
                    ->insert(
                        [
                            'userid' => $userid,
                            'country' => $country,
                            'service_type' => $service_type,
                            'letter_type' => $letter_type,
                            'created_at' => date("Y-m-d H:i:s"),
                        ]
                    );
            }
        }

        //?
        $user->profile_complete = 'course';
        $user->save();

        //?
        update_student_overseas_status($user->id);

        //store event in user activity
        UserActivity::create(['user_id' => $user->id, 'type' => 'user_event', 'title' => "User Updated Visa Preferences", 'detail' => ""]);

        return redirect()->route('frontend.user.visa.documents')->withFlashSuccess(__('labels.frontend.user.profile.visa_preferences_updated_successfully'));
    }


    /** Documents */
    public function storeDocuments(Request $request)
    {
        $message = "";
        $userid = \Auth::user()->id;
        \Log::debug("----- StoreDocuments(UID:$userid) START");
        // $single_file_max = config('app.doc_single_max_size') * 1024;
        // $allsem_file_max = config('app.doc_allsem_max_size') * 1024;
        //$size_msg = $single_file_max / pow(1024, 1);

        if ($request->input('type') == 'grad_all_sem' || $request->input('type') == 'pg_all_sem') {
            $max_size = config('app.doc_allsem_max_size') * 1024;
            $size_msg = $max_size / pow(1024, 1);
        } else {
            $max_size = config('app.doc_single_max_size') * 1024;
            $size_msg = $max_size / pow(1024, 1);
        }

        $request->validate(
            [
                'file' => 'required|mimes:pdf,jpeg,jpg|max:' . $max_size,
            ],
            [
                'max' => __('strings.frontend.general.the_files_may_not_be_greater_than') . $size_msg . ' MB.',
            ]
        );

        if (!DB::table('user_documents')->where('userid', $userid)->exists()) {
            DB::table('user_documents')->insert(['userid' => $userid]);
        }

        if ($request->input('type') == 'class10') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');

            DB::table('user_documents')->where('userid', $userid)->update(['class10' => $path]);

            $this->appNotification("class_10_certificate", $userid);

            return response()->json(['res' => 'success', 'message' => __('strings.frontend.general.x_document_uploaded_successfully', ['x' => _label('class_10_certificate')])]);
        }
        if ($request->input('type') == 'class10_marks_sheet') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');

            DB::table('user_documents')->where('userid', $userid)->update(['class10_marks_sheet' => $path]);

            $this->appNotification(_label('class_10_marks_sheet'), $userid);

            return response()->json(['res' => 'success', 'message' => __('strings.frontend.general.x_document_uploaded_successfully', ['x' => _label('class_10_marks_sheet')])]);
        }

        if ($request->input('type') == 'class12') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');

            DB::table('user_documents')->where('userid', $userid)->update(['class12' => $path]);

            $this->appNotification(_label('class_12_certificate'), $userid);

            return response()->json(['res' => 'success', 'message' => __('strings.frontend.general.x_document_uploaded_successfully', ['x' => _label('class_12_certificate')])]);
        }
        if ($request->input('type') == 'class12_marks_sheet') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');

            DB::table('user_documents')->where('userid', $userid)->update(['class12_marks_sheet' => $path]);

            $this->appNotification(_label('class_12_marks_sheet'), $userid);

            return response()->json(['res' => 'success', 'message' => __('strings.frontend.general.x_document_uploaded_successfully', ['x' => _label('class_12_marks_sheet')])]);
        }


        if ($request->input('type') == 'diploma') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');

            DB::table('user_documents')->where('userid', $userid)->update(['diploma' => $path]);

            $this->appNotification(_label('diploma_certificate'), $userid);

            return response()->json(['res' => 'success', 'message' => __('strings.frontend.general.x_document_uploaded_successfully', ['x' => _label('diploma_certificate')])]);
        }
        if ($request->input('type') == 'diploma_marks_sheet') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');

            DB::table('user_documents')->where('userid', $userid)->update(['diploma_marks_sheet' => $path]);

            $this->appNotification(_label('diploma_marks_sheet'), $userid);

            return response()->json(['res' => 'success', 'message' => __('strings.frontend.general.x_document_uploaded_successfully', ['x' => _label('diploma_marks_sheet')])]);
        }

        if ($request->input('type') == 'grad_all_sem') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');

            DB::table('user_documents')->where('userid', $userid)->update(['grad_all_sem' => $path]);

            $this->appNotification(_label('bachelors_marks_sheets_all_semesters'), $userid);

            return response()->json(['res' => 'success', 'message' => __('strings.frontend.general.x_document_uploaded_successfully', ['x' => _label('bachelors_marks_sheets_all_semesters')])]);
        }

        if ($request->input('type') == 'grad_provisional') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);
            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');

            DB::table('user_documents')->where('userid', $userid)->update(['grad_provisional' => $path]);

            $this->appNotification(_label('bachelors_provisional_certificate'), $userid);

            return response()->json(['res' => 'success', 'message' => __('strings.frontend.general.x_document_uploaded_successfully', ['x' => _label('bachelors_provisional_certificate')])]);
        }

        if ($request->input('type') == 'cmm') {
            //is this used?
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);
            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');

            DB::table('user_documents')->where('userid', $userid)->update(['cmm' => $path]);

            $this->appNotification("Consolidated Marks Memo", $userid);

            return response()->json(['res' => 'success', 'message' => __('strings.frontend.general.x_document_uploaded_successfully', ['x' => 'Consolidated Marks Memo'])]);
        }

        if ($request->input('type') == 'grad_degree') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');

            DB::table('user_documents')->where('userid', $userid)->update(['grad_degree' => $path]);

            $this->appNotification(_label('bachelors_certificate'), $userid);

            return response()->json(['res' => 'success', 'message' => __('strings.frontend.general.x_document_uploaded_successfully', ['x' => _label('bachelors_certificate')])]);
        }

        if ($request->input('type') == 'pg_provisional') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);
            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');

            DB::table('user_documents')->where('userid', $userid)->update(['pg_provisional' => $path]);

            $this->appNotification(_label('masters_provisional_certificate'), $userid);

            return response()->json(['res' => 'success', 'message' => __('strings.frontend.general.x_document_uploaded_successfully', ['x' => _label('masters_provisional_certificate')])]);
        }

        if ($request->input('type') == 'grad_transcripts') {
            //marks_sheets
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');

            DB::table('user_documents')->where('userid', $userid)->update(['grad_transcripts' => $path]);

            $this->appNotification(_label('bachelors_marks_sheet'), $userid);

            return response()->json(['res' => 'success', 'message' => __('strings.frontend.general.x_document_uploaded_successfully', ['x' => _label('bachelors_marks_sheet')])]);
        }

        if ($request->input('type') == 'pg_all_sem') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');

            DB::table('user_documents')->where('userid', $userid)->update(['pg_all_sem' => $path]);

            $this->appNotification(_label('masters_marks_sheets_all_semesters'), $userid);

            return response()->json(['res' => 'success', 'message' => __('strings.frontend.general.x_document_uploaded_successfully', ['x' => _label('masters_marks_sheets_all_semesters')])]);
        }

        if ($request->input('type') == 'pg_degree') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');

            DB::table('user_documents')->where('userid', $userid)->update(['pg_degree' => $path]);

            $this->appNotification(_label('masters_certificate'), $userid);

            return response()->json(['res' => 'success', 'message' => __('strings.frontend.general.x_document_uploaded_successfully', ['x' => _label('masters_certificate')])]);
        }

        if ($request->input('type') == 'pg_transcripts') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');

            DB::table('user_documents')->where('userid', $userid)->update(['pg_transcripts' => $path]);

            $this->appNotification(_label('masters_marks_sheet'), $userid);

            return response()->json(['res' => 'success', 'message' => __('strings.frontend.general.x_document_uploaded_successfully', ['x' => _label('masters_marks_sheet')])]);
        }

        if ($request->input('type') == 'lang_ielts') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['lang_ielts' => $path]);
            $message .= " IELTS Document Uploaded Successfully.";

            $this->appNotification("IELTS", $userid);

            return response()->json(['res' => 'success', 'message' => __('strings.frontend.general.ielts_document_uploaded_successfully')]);
        }

        if ($request->input('type') == 'lang_pte') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['lang_pte' => $path]);
            $message .= " PTE Document Uploaded Successfully.";

            $this->appNotification("PTE", $userid);

            return response()->json(['res' => 'success', 'message' => __('strings.frontend.general.pte_document_uploaded_successfully')]);
        }

        if ($request->input('type') == 'gre') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['gre' => $path]);
            $message .= " GRE Document Uploaded Successfully.";

            $this->appNotification("GRE", $userid);

            return response()->json(['res' => 'success', 'message' => __('strings.frontend.general.gre_document_uploaded_successfully')]);
        }

        if ($request->input('type') == 'gmat') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['gmat' => $path]);
            $message .= " GMAT Document Uploaded Successfully.";

            $this->appNotification("GMAT", $userid);

            return response()->json(['res' => 'success', 'message' => __('strings.frontend.general.gmat_document_uploaded_successfully')]);
        }

        if ($request->input('type') == 'toefl') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['toefl' => $path]);
            $message .= " TOEFL Document Uploaded Successfully.";

            $this->appNotification("TOEFL", $userid);

            return response()->json(['res' => 'success', 'message' => __('strings.frontend.general.toefl_document_uploaded_successfully')]);
        }

        if ($request->input('type') == 'duolingo') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['duolingo' => $path]);
            $message .= " Duolingo Document Uploaded Successfully.";

            $this->appNotification("Duolingo", $userid);

            return response()->json(['res' => 'success', 'message' => __('strings.frontend.general.duolingo_document_uploaded_successfully')]);
        }



        // \Log::debug("------StoreDocuments: END : " . $message);

        // return redirect()->route('frontend.user.studyabroad.documents')->withFlashSuccess("Documents uploaded successfully");
    }

    public function storeDocumentsCv(Request $request)
    {
        $single_file_max = config('app.doc_single_max_size') * 1024;

        $size_msg = $single_file_max / pow(1024, 1);
        $request->validate(
            [
                'file' => 'required',
                'file' => 'mimes:doc,docx|max:' . $single_file_max,
            ],
            [
                'max' => __('strings.frontend.general.the_file_may_not_be_greater_than') . $size_msg . ' MB.',
            ]
        );

        $userid = \Auth::user()->id;

        $file = $request->file('file');
        $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
        $filename = str_replace(" ", "-", $filename);
        $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
        if (strlen($filename) > 20) {
            $filename = substr($filename, 0, 20);
        }
        $filename .= "-" . round(microtime(true) * 1000);
        $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
        if (DB::table('user_docs_other')->where(["userid" => $userid, "doc_type" => "cv"])->exists()) {
            DB::table('user_docs_other')->where(["userid" => $userid, "doc_type" => "cv"])->update(["file" => $path]);
        } else {
            DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => "cv", "file" => $path]);
        }
        $this->appNotification("CV", $userid);
        return "success";
    }




    public function storeDocumentsPassport(Request $request)
    {
        $single_file_max = config('app.doc_single_max_size') * 1024;
        $size_msg = $single_file_max / pow(1024, 1);
        $request->validate(
            [
                'files' => 'required',
                'files.*' => 'mimes:pdf,jpeg,jpg|max:' . $single_file_max,
            ],
            [
                'max' => __('strings.frontend.general.the_file_may_not_be_greater_than') . $size_msg . ' MB.',
            ]
        );

        $userid = \Auth::user()->id;
        if ($request->hasFile('files')) {
            foreach ($request->file('files') as $file) {
                $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
                $filename = str_replace(" ", "-", $filename);
                $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
                if (strlen($filename) > 20) {
                    $filename = substr($filename, 0, 20);
                }
                $filename .= "-" . round(microtime(true) * 1000);
                $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
                DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => "passport", "file" => $path]);
            }
            $this->appNotification("Passport", $userid);
            return 'success';
        } else {
            return "error";
        }
    }


    // public function storeDocumentsSop(Request $request)
    // {
    //     $single_file_max = config('app.doc_single_max_size') * 1024;

    //     $request->validate([
    //         'file' => 'required|mimes:doc,docx|max:' . $single_file_max,
    //     ]);

    //     $userid = \Auth::user()->id;

    //     $file = $request->file('file');
    //     $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
    //     $filename = str_replace(" ", "-", $filename);
    //     $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
    //     if (strlen($filename) > 20) {
    //         $filename = substr($filename, 0, 20);
    //     }
    //     $filename .= "-".round(microtime(true) * 1000);
    //     $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
    //     DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => "sop", "file" => $path]);
    // }
    public function storeDocumentsEssay(Request $request)
    {
        $single_file_max = config('app.doc_single_max_size') * 1024;

        $size_msg = $single_file_max / pow(1024, 1);
        $request->validate(
            [
                'files' => 'required',
                'files.*' => 'mimes:pdf,doc,docx|max:' . $single_file_max,
            ],
            [
                'max' => __('strings.frontend.general.the_file_may_not_be_greater_than') . $size_msg . ' MB.',
            ]
        );

        $userid = \Auth::user()->id;
        $course_pref_id = $request->course_pref_id;
        $chk_essay = DB::table('user_docs_other')->where('userid', $userid)->where("course_pref_id", $request->course_pref_id)->where("doc_type", 'essay')->count();
        if ($chk_essay >= env("MAX_ESSAY_FILES")) {
            return "error_max_files";
        } elseif ($request->totalFiles > env("MAX_ESSAY_FILES")) {
            return "error_max_files";
        } else {
            if ($request->hasFile('files')) {
                foreach ($request->file('files') as $file) {
                    $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);

                    $filename = str_replace(" ", "-", $filename);
                    $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
                    if (strlen($filename) > 20) {
                        $filename = substr($filename, 0, 20);
                    }
                    $filename .= "-" . round(microtime(true) * 1000);
                    $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
                    DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => "essay", "course_pref_id" => $course_pref_id, "file" => $path]);
                }
                $this->appNotification("Essay", $userid);
                return 'success';
            } else {
                return "error";
            }
        }
    }

    public function storeDocumentsSop(Request $request)
    {
        $single_file_max = config('app.doc_single_max_size') * 1024;

        $size_msg = $single_file_max / pow(1024, 1);
        $request->validate(
            [
                'file' => 'required',
                'file' => 'mimes:doc,docx|max:' . $single_file_max,
            ],
            [
                'max' => __('strings.frontend.general.the_file_may_not_be_greater_than') . $size_msg . ' MB.',
            ]
        );

        $userid = \Auth::user()->id;
        $course_pref_id = $request->course_pref_id;
        $file = $request->file('file');
        $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
        $filename = str_replace(" ", "-", $filename);
        $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
        if (strlen($filename) > 20) {
            $filename = substr($filename, 0, 20);
        }
        $filename .= "-" . round(microtime(true) * 1000);
        $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
        DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => "sop", "course_pref_id" => $course_pref_id, "file" => $path]);
        $this->appNotification("SOP", $userid);
        return "success";
    }

    public function storeDocumentsLor(Request $request)
    {
        $single_file_max = config('app.doc_single_max_size') * 1024;
        $size_msg = $single_file_max / pow(1024, 1);
        $request->validate(
            [
                'files' => 'required',
                'files.*' => 'mimes:pdf,jpeg,jpg|max:' . $single_file_max,
            ],
            [
                'max' => __('strings.frontend.general.the_files_may_not_be_greater_than') . $size_msg . ' MB.',
            ]
        );

        $userid = \Auth::user()->id;

        if ($request->hasFile('files')) {
            foreach ($request->file('files') as $file) {
                $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);

                $filename = str_replace(" ", "-", $filename);
                $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
                if (strlen($filename) > 20) {
                    $filename = substr($filename, 0, 20);
                }
                $filename .= "-" . round(microtime(true) * 1000);
                $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
                DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => "letter_of_recommendation", "file" => $path]);
            }
            $this->appNotification("Lor", $userid);
            return 'success';
        } else {
            return "error";
        }
    }

    public function storeDocumentsExperience(Request $request)
    {
        $single_file_max = config('app.doc_single_max_size') * 1024;

        $size_msg = $single_file_max / pow(1024, 1);
        $request->validate(
            [
                'files' => 'required',
                'files.*' => 'mimes:pdf,jpeg,jpg|max:' . $single_file_max,
            ],
            [
                'max' => __('strings.frontend.general.the_files_may_not_be_greater_than') . $size_msg . ' MB.',
            ]
        );

        $userid = \Auth::user()->id;

        if ($request->hasFile('files')) {
            foreach ($request->file('files') as $file) {
                $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);

                $filename = str_replace(" ", "-", $filename);
                $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
                if (strlen($filename) > 20) {
                    $filename = substr($filename, 0, 20);
                }
                $filename .= "-" . round(microtime(true) * 1000);
                $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
                DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => "experience", "file" => $path]);
            }
            $this->appNotification("Experience", $userid);
            return 'success';
        } else {
            return "error";
        }
    }

    public function storeDocumentsOther(Request $request)
    {
        $single_file_max = config('app.doc_single_max_size') * 1024;

        $size_msg = $single_file_max / pow(1024, 1);
        $request->validate(
            [
                'files' => 'required',
                'files.*' => 'mimes:pdf,jpeg,jpg|max:' . $single_file_max,
            ],
            [
                'max' => __('strings.frontend.general.the_files_may_not_be_greater_than') . $size_msg . ' MB.',
            ]
        );

        $userid = \Auth::user()->id;

        if ($request->hasFile('files')) {
            foreach ($request->file('files') as $file) {
                $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);

                $filename = str_replace(" ", "-", $filename);
                $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
                if (strlen($filename) > 20) {
                    $filename = substr($filename, 0, 20);
                }
                $filename .= "-" . round(microtime(true) * 1000);
                $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
                DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => "other", "file" => $path]);
            }
            $this->appNotification("Other", $userid);
            return 'success';
        } else {
            return "error";
        }
    }


    public function storeDocumentsAdditional(Request $request)
    {
        $single_file_max = config('app.doc_single_max_size') * 1024;
        $allowed_types = str_replace(".", "", $request->file_types);
        $allowed_types = str_replace(" ", "", $allowed_types);

        $size_msg = $single_file_max / pow(1024, 1);
        $request->validate(
            [
                'files' => 'required',
                'files.*' => 'mimes:' . $allowed_types . '|max:' . $single_file_max,
            ],
            [
                'max' => __('strings.frontend.general.the_files_may_not_be_greater_than') . $size_msg . ' MB.',
            ]
        );

        //return $request->doc_type."<br>".$request->file_types;

        $userid = \Auth::user()->id;

        if ($request->hasFile('files')) {
            foreach ($request->file('files') as $file) {
                $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);

                $filename = str_replace(" ", "-", $filename);
                $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
                if (strlen($filename) > 20) {
                    $filename = substr($filename, 0, 20);
                }
                $filename .= "-" . round(microtime(true) * 1000);
                $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
                DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => $request->doc_type, "file" => $path]);
            }
            $this->appNotification(str_replace("_", " ", $request->doc_type), $userid);
            return 'success';
        } else {
            return "error";
        }
    }

    public function deleteDocumentsPass(Request $request)
    {
        $pass = DB::table('user_docs_other')->where('id', $request->pass_id)->first();

        File::delete("storage/" . $pass->file);

        DB::table('user_docs_other')->where('id', $request->pass_id)->delete();
        return response()->json(['message' => 'Passport Document Deleted']);
    }


    public function deleteDocumentsLor(Request $request)
    {
        $lor = DB::table('user_docs_other')->where('id', $request->lor_id)->first();

        File::delete("storage/" . $lor->file);

        DB::table('user_docs_other')->where('id', $request->lor_id)->delete();
        return response()->json(['message' => 'LOR Document Deleted']);
    }

    public function deleteDocumentsExp(Request $request)
    {
        $exp = DB::table('user_docs_other')->where('id', $request->exp_id)->first();

        File::delete("storage/" . $exp->file);

        DB::table('user_docs_other')->where('id', $request->exp_id)->delete();
        return response()->json(['message' => 'Experience Document Deleted']);
    }

    public function deleteDocumentsOther(Request $request)
    {
        $other = DB::table('user_docs_other')->where('id', $request->other_id)->first();
        File::delete("storage/" . $other->file);

        DB::table('user_docs_other')->where('id', $request->other_id)->delete();
        return response()->json(['message' => 'Other Document Deleted']);
    }

    public function deleteDocumentsAdditional(Request $request)
    {
        $other = DB::table('user_docs_other')->where('id', $request->additional_id)->first();
        File::delete("storage/" . $other->file);

        DB::table('user_docs_other')->where('id', $request->additional_id)->delete();
        return response()->json(['message' => 'Document Deleted']);
    }

    public function deleteDocumentsEssay(Request $request)
    {
        $essay = DB::table('user_docs_other')->where('id', $request->id)->first();
        File::delete("storage/" . $essay->file);

        DB::table('user_docs_other')->where('id', $request->id)->delete();
        return response()->json(['message' => 'Essay Document Deleted']);
    }

    public function submitApplication(Request $request)
    {
        \Log::debug("submitApplication Start");
        $user = \Auth::user();
        $docs_conf = get_student_doc_configs();
        $my_study_level = get_my_study_level($user);

        //Check if already submitted
        if ($user->profile_complete == 'documents') {
            return redirect()->route('frontend.user.studyabroad.documents')->withFlashDanger("You have already submitted application");
        }
        if ($user->profile_complete != 'course') {
            return redirect()->route('frontend.user.studyabroad.documents')->withFlashDanger("You must complete profile & course preference details before you can submit application");
        }

        if (!$user->overseas_study_level) {
            return redirect()->route('frontend.user.studyabroad.documents')->withFlashDanger("Overseas study level preference required before you can submit application");
        }

        //Check all mandatory docs submitted
        $user_docs = DB::table('user_documents')->where('userid', $user->id)->first();
        if (!$user_docs) {
            return redirect()->route('frontend.user.studyabroad.documents')->withFlashDanger("Documents not found! You must upload all required documents before you can submit application");
        }

        $error_message = "";

        if ($docs_conf[$my_study_level]['class10']['certificate']['enable'] && $docs_conf[$my_study_level]['class10']['certificate']['mandatory'] && !$user_docs->class10) {
            $error_message = "10th Certificate Required";
        } elseif ($docs_conf[$my_study_level]['class10']['marks_sheet']['enable'] && $docs_conf[$my_study_level]['class10']['marks_sheet']['mandatory'] && !$user_docs->class10_marks_sheet) {
            $error_message = "10th Marks Sheet Required";
        } elseif ($docs_conf[$my_study_level]['class12']['certificate']['enable'] && $docs_conf[$my_study_level]['class12']['certificate']['mandatory'] && !$user_docs->class12) {
            $error_message = "12th Certificate Required";
        } elseif ($docs_conf[$my_study_level]['class12']['marks_sheet']['enable'] && $docs_conf[$my_study_level]['class12']['marks_sheet']['mandatory'] && !$user_docs->class10_marks_sheet) {
            $error_message = "12th Marks Sheet Required";
        } elseif ($docs_conf[$my_study_level]['diploma']['certificate']['enable'] && $docs_conf[$my_study_level]['diploma']['certificate']['mandatory'] && !$user_docs->diploma) {
            $error_message = "Diploma Certificate Required";
        } elseif ($docs_conf[$my_study_level]['diploma']['marks_sheet']['enable'] && $docs_conf[$my_study_level]['diploma']['marks_sheet']['mandatory'] && !$user_docs->diploma_marks_sheet) {
            $error_message = "Diploma Marks Sheet Required";
        } elseif ($docs_conf[$my_study_level]['degree']['certificate']['enable'] && $docs_conf[$my_study_level]['degree']['certificate']['mandatory'] && !$user_docs->grad_degree) {
            $error_message = "Bachelors Certificate Required";
        } elseif ($docs_conf[$my_study_level]['degree']['marks_sheet']['enable'] && $docs_conf[$my_study_level]['degree']['marks_sheet']['mandatory'] && !$user_docs->grad_transcripts) {
            $error_message = "Bachelors Marks Sheet/Transcripts Required";
        } elseif ($docs_conf[$my_study_level]['degree']['provisional']['enable'] && $docs_conf[$my_study_level]['degree']['provisional']['mandatory'] && !$user_docs->grad_provisional) {
            $error_message = "Bachelors Provisional Certificate Required";
        } elseif ($docs_conf[$my_study_level]['degree']['all_sem']['enable'] && $docs_conf[$my_study_level]['degree']['all_sem']['mandatory'] && !$user_docs->grad_all_sem) {
            $error_message = "Bachelors All Semesters Marks Sheets";
        } elseif ($docs_conf[$my_study_level]['pg_degree']['certificate']['enable'] && $docs_conf[$my_study_level]['pg_degree']['certificate']['mandatory'] && !$user_docs->pg_degree) {
            $error_message = "Masters Certificate Required";
        } elseif ($docs_conf[$my_study_level]['pg_degree']['marks_sheet']['enable'] && $docs_conf[$my_study_level]['pg_degree']['marks_sheet']['mandatory'] && !$user_docs->pg_transcripts) {
            $error_message = "Masters Marks Sheet/Transcripts Required";
        } elseif ($docs_conf[$my_study_level]['pg_degree']['provisional']['enable'] && $docs_conf[$my_study_level]['pg_degree']['provisional']['mandatory'] && !$user_docs->pg_provisional) {
            $error_message = "Masters Provisional Certificate Required";
        } elseif ($docs_conf[$my_study_level]['pg_degree']['all_sem']['enable'] && $docs_conf[$my_study_level]['pg_degree']['all_sem']['mandatory'] && !$user_docs->pg_all_sem) {
            $error_message = "Masters All Semesters Marks Sheets";
        }

        if ($error_message) {
            return redirect()->route('frontend.user.studyabroad.documents')->withFlashDanger($error_message);
        }

        if ($docs_conf[$my_study_level]['passport']['enable'] && $docs_conf[$my_study_level]['passport']['mandatory'] && !DB::table('user_docs_other')->where('userid', $user->id)->where('doc_type', 'passport')->exists()) {
            return redirect()->route('frontend.user.studyabroad.documents')->withFlashDanger("Passport Document is Required");
        }

        if ($docs_conf[$my_study_level]['cv']['enable'] && $docs_conf[$my_study_level]['cv']['mandatory'] && !DB::table('user_docs_other')->where('userid', $user->id)->where('doc_type', 'cv')->exists()) {
            return redirect()->route('frontend.user.studyabroad.documents')->withFlashDanger("CV is Required");
        }

        if ($docs_conf[$my_study_level]['lor']['enable'] && $docs_conf[$my_study_level]['lor']['mandatory'] && !DB::table('user_docs_other')->where('userid', $user->id)->where('doc_type', 'letter_of_recommendation')->exists()) {
            return redirect()->route('frontend.user.studyabroad.documents')->withFlashDanger("LOR Document is Required");
        }

        if ($docs_conf[$my_study_level]['sop']['enable'] && $docs_conf[$my_study_level]['sop']['mandatory'] && !DB::table('user_docs_other')->where('userid', $user->id)->where('doc_type', 'sop')->exists()) {
            return redirect()->route('frontend.user.studyabroad.documents')->withFlashDanger("SOP Document is Required");
        }

        if ($docs_conf[$my_study_level]['experience']['enable'] && $docs_conf[$my_study_level]['experience']['mandatory'] && !DB::table('user_docs_other')->where('userid', $user->id)->where('doc_type', 'experience')->exists()) {
            return redirect()->route('frontend.user.studyabroad.documents')->withFlashDanger("Experience Letter is Required");
        }

        if ($docs_conf[$my_study_level]['other_cert']['enable'] && $docs_conf[$my_study_level]['other_cert']['mandatory'] && !DB::table('user_docs_other')->where('userid', $user->id)->where('doc_type', 'other')->exists()) {
            return redirect()->route('frontend.user.studyabroad.documents')->withFlashDanger("Other Document is Required");
        }

        \Log::debug("submitApplication Docs Ok");
        //create_new_ticket($user->id, "Documents Uploaded", $message);


        //Sending email Notification
        $subject = "Document upload by " . _label('backend_student') . "(all docs upload completed)";
        $message = "Hi, <br><br>Study abroad application submitted by " . _label('backend_student') . ".<br /><br /><strong>" . _label('backend_student') . " Details:</strong><br /><br />" . $user->first_name . " " . $user->last_name . " (" . $user->id . ") <br />Mob: " . $user->mobile . "<br />Email: " . $user->email;
        send_mail_notification($user->id, "", "STUDENT_SUBMIT_APPLICATION", $subject, $message);

        // Send Push App Notification
        $subject = "";
        $message = "Study abroad application submitted by " . _label('backend_student') . ": " . $user->full_name . " (" . $user->id . ")";
        send_in_app_notification(
            $user->id,
            $user->id,
            "STUDENT_SUBMIT_APPLICATION",
            $subject,
            $message,
            "student",
        );

        // if ($message) {
        //     // $email_message = "Dear Admin,<br><br>" . $message;
        //     // $recipient = new AdminRecipient();
        //     // try {
        //     //     $recipient->notify(new AdminAlert("New Study abroad application", $email_message));
        //     // } catch (\Exception $e) {
        //     //     $message = $e->getMessage();
        //     //     \Log::debug("Mail Error: (New Study abroad application) " . $message);
        //     // }

        //     //Notify Staff
        //     if($user->assigned_to != 0){
        //         $staff_email = get_user_email_by_id($user->assigned_to);
        //         $staff_name = get_user_name_by_id($user->assigned_to);
        //         try {
        //             $staff_message = $message;
        //             $email_message = "Dear ".$staff_name.",<br><br>" . $staff_message;
        //             Mail::to($staff_email)->send(new MailSend("New study abroad application submitted by student", $email_message));
        //         } catch (\Exception $e) {
        //             $message = $e->getMessage();
        //             \Log::debug("Mail Error: (New Study abroad application submitted by student) " . $message);
        //         }
        //     }


        //     // $notify_ids = env('EVENT_NOTIFY_EMAILS');
        //     // $tos = explode(",", $notify_ids);
        //     // foreach ($tos as $to) {
        //     //     try {
        //     //         Mail::to($to)->send(new MailSend("New Study abroad application", $email_message));
        //     //     } catch (\Exception $e) {
        //     //         $message = $e->getMessage();
        //     //         \Log::debug("Mail Error: (New Study abroad application) " . $message);
        //     //     }
        //     // }
        // }

        $user->profile_complete = 'documents';
        $user->application_submit_date = date("Y-m-d");
        $user->save();

        update_student_overseas_status($user->id);

        //store event in user activity
        UserActivity::create(['user_id' => $user->id, 'type' => 'user_event', 'title' => "Student uploaded documents & submitted application", 'detail' => ""]);
        \Log::debug("submitApplication End");
        return redirect()->route('frontend.user.studyabroad.documents')->withFlashSuccess(__('labels.frontend.user.profile.your_application_details_submitted_successfully'));
    }

    public function submitVisaApplication(Request $request)
    {
        $user = \Auth::user();

        //Check if already submitted
        // if ($user->profile_complete == 'documents') {
        //     return redirect()->route('frontend.user.studyabroad.documents')->withFlashDanger("You have already submitted application");
        // }
        // if ($user->profile_complete != 'course') {
        //     return redirect()->route('frontend.user.studyabroad.documents')->withFlashDanger("You must complete profile & course preference details before you can submit application");
        // }

        // if (!$user->overseas_study_level) {
        //     return redirect()->route('frontend.user.studyabroad.documents')->withFlashDanger("Overseas study level preference required before you can submit application");
        // }

        //Check all mandatory docs submitted
        $user_docs = DB::table('user_documents')->where('userid', $user->id)->first();
        if (!$user_docs) {
            return redirect()->route('frontend.user.visa.documents')->withFlashDanger("Documents not found! You must upload all required documents before you can submit application");
        }

        $error_message = "";
        // if (!($user_docs->class10 || $user_docs->class10_marks_sheet)) {
        //     $error_message = "10th Certificate or Marksheet Required";
        // } elseif (!($user_docs->class12 || $user_docs->class12_marks_sheet)) {
        //     $error_message = "12th Certificate or Marksheet Required";
        // }
        // if ($error_message) {
        //     return redirect()->route('frontend.user.visa.documents')->withFlashDanger($error_message);
        // }

        // if ($user->overseas_study_level == 'Masters') {
        //     if (!$user_docs->grad_degree) {
        //         $error_message = "Bachelors Certificate Required";
        //     } elseif (!$user_docs->grad_transcripts) {
        //         $error_message = "Bachelors Marksheet/Transcripts Required";
        //     }
        //     if ($error_message) {
        //         return redirect()->route('frontend.user.visa.documents')->withFlashDanger($error_message);
        //     }
        // }

        // if ($user->overseas_study_level == 'Ph.D') {
        //     if (!$user_docs->pg_degree) {
        //         $error_message = "Masters Certificate Required";
        //     } elseif (!$user_docs->pg_transcripts) {
        //         $error_message = "Masters Marksheet/Transcripts Required";
        //     }
        //     if ($error_message) {
        //         return redirect()->route('frontend.user.visa.documents')->withFlashDanger($error_message);
        //     }
        // }

        //@todo: how to validate gre, gmat, pte, ielts requirements?

        // if (get_site_config('student_cv_mandatory_in_profile') && !DB::table('user_docs_other')->where('userid', $user->id)->where('doc_type', 'cv')->exists()) {
        //     return redirect()->route('frontend.user.visa.documents')->withFlashDanger("CV is Required");
        // }

        if (!DB::table('user_docs_other')->where('userid', $user->id)->where('doc_type', 'passport')->exists()) {
            return redirect()->route('frontend.user.visa.documents')->withFlashDanger("Passport Document is Required");
        }

        // if (!DB::table('user_docs_other')->where('userid', $user->id)->where('doc_type', 'sop')->exists()) {
        //     return redirect()->route('frontend.user.visa.documents')->withFlashDanger("SOP Document is Required");
        // }

        // if (!DB::table('user_docs_other')->where('userid', $user->id)->where('doc_type', 'letter_of_recommendation')->exists()) {
        //     return redirect()->route('frontend.user.visa.documents')->withFlashDanger("LOR Document is Required");
        // }

        $user->profile_complete = 'documents';
        $user->application_submit_date = date("Y-m-d");
        $user->save();

        update_student_overseas_status($user->id);

        //store event in user activity
        UserActivity::create(['user_id' => $user->id, 'type' => 'user_event', 'title' => "User uploaded documents & submitted application", 'detail' => ""]);

        return redirect()->route('frontend.user.visa.documents')->withFlashSuccess(__('labels.frontend.user.profile.your_application_details_submitted_successfully'));
    }


    public function addAcademicsInformation()
    {

        $countries = Country::orderBy('title_en')->select('id', 'title_en as name')->get();
        return view('frontend.user.student-details-add-edit-modal.add_academics_detail_model', ['countries' => $countries]);
    }

    public function editAcademicsInformation($id)
    {
        $countries = Country::orderBy('title_en')->select('id', 'title_en as name')->get();
        $profile_academic = DB::table('user_academics')->where('id', $id)->first();

        return view('frontend.user.student-details-add-edit-modal.edit_academics_detail_model', compact('profile_academic'), ['countries' => $countries]);
    }

    // delete Basic academic details from user_academics table
    public function academicsInformationDelete(Request $request)
    {
        $userAcademicsDetail = DB::table('user_academics')->where('id', $request->id)->first();
        if ($userAcademicsDetail) {
            DB::table('user_academics')->where('id', $request->id)->delete();
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess("Academics Details Deleted Successfully");
        } else {
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashDanger("Academics Details Not Found!");
        }
    }

    //for get add information on the modal of the editinternship
    public function addInternshipInformation()
    {
        return view('frontend.user.student-details-add-edit-modal.add_internship_model');
    }

    //for get edit information on the modal of the editinternship
    public function editInternshipInformation($id)
    {
        $profile_internship = DB::table('user_internship')->where('id', $id)->first();

        return view('frontend.user.student-details-add-edit-modal.edit_internship_model', compact('profile_internship'));
    }

    // delete internship details from user_internship  table
    public function InternshipProfileDelete(Request $request)
    {
        $userInternshipDetail = DB::table('user_internship')->where('id', $request->id)->first();
        if ($userInternshipDetail) {
            DB::table('user_internship')->where('id', $request->id)->delete();
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess("Internship Details Deleted Successfully");
        } else {
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashDanger("Internship Details Not Found!");
        }
    }

    //for get add Course on the modal of the editinternship
    public function addCourseInformation()
    {
        return view('frontend.user.student-details-add-edit-modal.add_course_model');
    }

    // add courses
    public function storeCourseProfile(Request $request)
    {

        $request->validate([
            'course' => 'required|max:100',
            'duration' => 'required|max:100',
            'institute' => 'required|max:100',

        ]);
        if ($request->course_id) {
            $userAcademicsDetail = DB::table('user_courses')->where('id', $request->course_id)->update([
                'userid'    => $request->get('userid'),
                'course' => $request->get('course'),
                'duration' => $request->get('duration'),
                'institute' => $request->get('institute'),

            ]);
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess("Course Details Updated Successfully");
        } else {
            $userAcademicsDetail = DB::table('user_courses')->insert([
                'userid'    => $request->get('userid'),
                'course' => $request->get('course'),
                'duration' => $request->get('duration'),
                'institute' => $request->get('institute'),

            ]);
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess("Course Details Added Successfully");
        }
    }
    //for get edit information on the modal of the editcourse
    public function editCourseInformation($id)
    {
        $profile_course = DB::table('user_courses')->where('id', $id)->first();

        return view('frontend.user.student-details-add-edit-modal.edit_course_model', compact('profile_course'));
    }

    // delete other course details from user_courses  table
    public function CourseProfileDelete(Request $request)
    {
        $userCourseDetail = DB::table('user_courses')->where('id', $request->id)->first();
        if ($userCourseDetail) {
            DB::table('user_courses')->where('id', $request->id)->delete();
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess("Other Courses Details Deleted Successfully");
        } else {
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashDanger("Other Courses Details Not Found!");
        }
    }

    // Academics Details add_enrollment_history_model
    public function addFamilyInformation()
    {
        $dialcodes = Country::groupBy('tel')->orderBy('tel', 'asc')->get(['tel as code', 'title_en as name']);
        $countries = Country::orderBy('title_en')->select('id', 'title_en as name')->get();
        return view('frontend.user.student-details-add-edit-modal.add_family_detail_model', ['countries' => $countries, 'dialcodes' => $dialcodes]);
    }
    //add family details
    public function storeFamilyProfile(Request $request)
    {

        $request->validate([
            'first_name' => 'required|max:100|regex:/^[\pL\s]+$/u',
            'last_name' => 'nullable|max:100|regex:/^[\pL\s]+$/u',
            'gender' => 'required|max:10',
            'email' => 'nullable|max:100',
            'dial_code' => 'nullable|numeric',
            'mobile' => 'nullable',
            'birth_date' => 'nullable|before:' . now(),
            'birth_country' => 'nullable|max:100',
            'residence_country' => 'nullable',
            'relationship' => 'required|max:100',
        ]);
        if ($request->family_id) {
            $userAcademicsDetail = DB::table('user_family')->where('id', $request->family_id)->update([
                'userid'    => $request->get('userid'),
                'first_name' => $request->get('first_name'),
                'last_name' => $request->get('last_name'),
                'relationship' => $request->get('relationship'),
                'gender' => $request->get('gender'),
                'email' => $request->get('email'),
                'dial_code' => $request->get('dial_code'),
                'mobile' => $request->get('mobile'),
                'birth_date' => $request->get('birth_date'),
                'birth_country' => $request->get('birth_country'),
                'residence_country' => $request->get('residence_country'),
            ]);
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess("Family Details Updated Successfully");
        } else {
            $userAcademicsDetail = DB::table('user_family')->insert([
                'userid'    => $request->get('userid'),
                'first_name' => $request->get('first_name'),
                'last_name' => $request->get('last_name'),
                'relationship' => $request->get('relationship'),
                'gender' => $request->get('gender'),
                'email' => $request->get('email'),
                'dial_code' => $request->get('dial_code'),
                'mobile' => $request->get('mobile'),
                'birth_date' => $request->get('birth_date'),
                'birth_country' => $request->get('birth_country'),
                'residence_country' => $request->get('residence_country'),
            ]);
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess("Family Details Added Successfully");
        }
    }

    //for get edit information on the modal of the editinternship
    public function editFamilyInformation($id)
    {
        $profile_family = DB::table('user_family')->where('id', $id)->first();
        $dialcodes = Country::groupBy('tel')->orderBy('tel', 'asc')->get(['tel as code', 'title_en as name']);
        $countries = Country::orderBy('title_en')->select('id', 'title_en as name')->get();
        return view('frontend.user.student-details-add-edit-modal.edit_family_detail_model', compact('profile_family', 'countries', 'dialcodes'));
    }

    // delete family  details from user_family  table
    public function FamilyProfileDelete(Request $request)
    {
        $userFamilyDetail = DB::table('user_family')->where('id', $request->id)->first();
        if ($userFamilyDetail) {
            DB::table('user_family')->where('id', $request->id)->delete();
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess("Family Details Deleted Successfully");
        } else {
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashDanger("Family Details Not Found!");
        }
    }

    // Employment History
    public function addEmployment()
    {
        $countries = Country::orderBy('title_en')->select('id', 'title_en as name')->get();
        return view('frontend.user.student-details-add-edit-modal.add_employment_history_model', ['countries' => $countries]);
    }

    //store employment details
    public function employmentSave(Request $request)
    {

        $request->validate([
            "employment_histroy_type" => "required",
            "employment_history_currently_working" => "required",
            "employment_history_industry_type" => "required|max:100",
            "employment_history_organisation_name" => "required|max:100",
            "employment_history_employer_phone" => "required|max:100",
            "employment_history_address" => "required|max:100",
            "employment_history_country" => "required|max:100",
            "employment_history_state" => "required|max:100",
            "employment_history_city" => "required|max:100",
            "employment_history_postcode" => "nullable|max:10",
            "employment_history_contact_person_name" => "required|max:100",
            "employment_history_contact_person_mobile_number" => "nullable",
            "employment_history_contact_person_business_phone" => "nullable",
            "employment_history_working_position_occupation" => "required|max:100",
            "employment_history_start_date" => "required|before:" . now(),
            "employment_history_working_ended" => "nullable|before:" . now()
        ]);
        if ($request->employment_history_start_date) {
            $request->validate(["employment_history_working_ended" => "nullable|after:" . $request->employment_history_start_date]);
        }
        if (!empty($request->input('employment_history_start_date'))) {
            $employment_history_start_date = substr($request->input('employment_history_start_date'), 6, 4) . "-" . substr($request->input('employment_history_start_date'), 3, 2) . "-" . substr($request->input('employment_history_start_date'), 0, 2);
        } else {
            $employment_history_start_date = NULL;
        }

        if (!empty($request->input('employment_history_working_ended'))) {
            $employment_history_working_ended = substr($request->input('employment_history_working_ended'), 6, 4) . "-" . substr($request->input('employment_history_working_ended'), 3, 2) . "-" . substr($request->input('employment_history_working_ended'), 0, 2);
        } else {
            $employment_history_working_ended = NULL;
        }

        if ($request->employment_id) {
            $employmentHistory = DB::table('employment_detail')->where('id', $request->employment_id)->update([
                'userid' => $request->get('userid'),
                'employment_histroy_type' => $request->get('employment_histroy_type'),
                'employment_history_currently_working' => $request->get('employment_history_currently_working'),
                'employment_history_organisation_name' => $request->get('employment_history_organisation_name'),
                'employment_history_industry_type' => $request->get('employment_history_industry_type'),
                'employment_history_employer_phone' => $request->get('employment_history_employer_phone'),
                'employment_history_address' => $request->get('employment_history_address'),
                'employment_history_postcode' => $request->get('employment_history_postcode'),
                'employment_history_country' => $request->get('employment_history_country'),
                'employment_history_state' => $request->get('employment_history_state'),
                'employment_history_city' => $request->get('employment_history_city'),
                'employment_history_contact_person_name' => $request->get('employment_history_contact_person_name'),
                'employment_history_contact_person_family_name' => $request->get('employment_history_contact_person_family_name'),
                'employment_history_contact_person_mobile_number' => $request->get('employment_history_contact_person_mobile_number'),
                'employment_history_contact_person_business_phone' => $request->get('employment_history_contact_person_business_phone'),
                'employment_history_working_position_occupation' => $request->get('employment_history_working_position_occupation'),
                'employment_history_start_date' => $employment_history_start_date,
                'employment_history_working_ended' => $employment_history_working_ended,
            ]);
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess("Employment History Updated Successfully");
        } else {
            $employmentHistory = DB::table('employment_detail')->insert([
                'userid' => $request->get('userid'),
                'employment_histroy_type' => $request->get('employment_histroy_type'),
                'employment_history_currently_working' => $request->get('employment_history_currently_working'),
                'employment_history_organisation_name' => $request->get('employment_history_organisation_name'),
                'employment_history_industry_type' => $request->get('employment_history_industry_type'),
                'employment_history_employer_phone' => $request->get('employment_history_employer_phone'),
                'employment_history_address' => $request->get('employment_history_address'),
                'employment_history_postcode' => $request->get('employment_history_postcode'),
                'employment_history_country' => $request->get('employment_history_country'),
                'employment_history_state' => $request->get('employment_history_state'),
                'employment_history_city' => $request->get('employment_history_city'),
                'employment_history_contact_person_name' => $request->get('employment_history_contact_person_name'),
                'employment_history_contact_person_family_name' => $request->get('employment_history_contact_person_family_name'),
                'employment_history_contact_person_mobile_number' => $request->get('employment_history_contact_person_mobile_number'),
                'employment_history_contact_person_business_phone' => $request->get('employment_history_contact_person_business_phone'),
                'employment_history_working_position_occupation' => $request->get('employment_history_working_position_occupation'),
                'employment_history_start_date' => $employment_history_start_date,
                'employment_history_working_ended' => $employment_history_working_ended,
            ]);
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess("Employment History Added Successfully");
        }
    }

    //edit employment
    public function editEmployment($id)
    {
        $countries = Country::orderBy('title_en')->select('id', 'title_en as name')->get();
        $profile_employment_detail = DB::table('employment_detail')->where('id', $id)->first();
        return view('frontend.user.student-details-add-edit-modal.edit_employment_history_model', ['profile_employment_detail' => $profile_employment_detail, 'countries' => $countries]);
    }


    // delete Employment  details from employment_detail  table
    public function EmploymentDelete(Request $request)
    {
        $userEmploymentDetail = DB::table('employment_detail')->where('id', $request->id)->first();
        if ($userEmploymentDetail) {
            DB::table('employment_detail')->where('id', $request->id)->delete();
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess("Employment Details Deleted Successfully");
        } else {
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashDanger("Employment Details Not Found!");
        }
    }

    // Travel History
    public function addTravelHistory()
    {
        $countries = Country::orderBy('title_en')->select('id', 'title_en as name')->get();
        return view('frontend.user.student-details-add-edit-modal.add_travel_history_model', ['countries' => $countries]);
    }

    public function editTravelHistory($id)
    {
        $countries = Country::orderBy('title_en')->select('id', 'title_en as name')->get();
        $profile_travel_history = DB::table('travel_history')->where('id', $id)->first();
        return view('frontend.user.student-details-add-edit-modal.edit_travel_history_model', ['profile_travel_history' => $profile_travel_history, 'countries' => $countries]);
    }

    public function travelHistorySave(Request $request)
    {
        $request->validate([
            "country_visited" => "required",
            "name_used_on_country" => "required|regex:/^[\pL\s]+$/u",
            "visa_type" => "required|max:100",
            "visa_issue_at" => "required|max:100",
            "date_from" => "required|before:" . now(),
            "date_up_to" => "required|before:" . now() . '|after:' . $request->date_from,
        ]);
        if (!empty($request->input('date_from'))) {
            $date_from = substr($request->input('date_from'), 6, 4) . "-" . substr($request->input('date_from'), 3, 2) . "-" . substr($request->input('date_from'), 0, 2);
        } else {
            $date_from = NULL;
        }

        if (!empty($request->input('date_up_to'))) {
            $date_up_to = substr($request->input('date_up_to'), 6, 4) . "-" . substr($request->input('date_up_to'), 3, 2) . "-" . substr($request->input('date_up_to'), 0, 2);
        } else {
            $date_up_to = NULL;
        }

        if ($request->travel_id) {
            $userTravelHistory = ProfileTravelHistory::where('id', $request->travel_id)->first();
            $userTravelHistory->userid = $request->get('userid');
            $userTravelHistory->country_visited = $request->get('country_visited');
            $userTravelHistory->name_used_on_country = $request->get('name_used_on_country');
            $userTravelHistory->visa_type = $request->get('visa_type');
            $userTravelHistory->visa_issue_at = $request->get('visa_issue_at');
            $userTravelHistory->date_from = $date_from;
            $userTravelHistory->date_up_to = $date_up_to;
            $userTravelHistory->reason_of_visit = $request->get('reason_of_visit');
            $userTravelHistory->save();
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess("Travel History Updated Successfully");
        } else {
            $userTravelHistory = new ProfileTravelHistory([
                'userid'    => $request->get('user_id'),
                'country_visited' => $request->get('country_visited'),
                'name_used_on_country' => $request->get('name_used_on_country'),
                'visa_type' => $request->get('visa_type'),
                'visa_issue_at' => $request->get('visa_issue_at'),
                'date_from' => $date_from,
                'date_up_to' => $date_up_to,
                'reason_of_visit' => $request->get('reason_of_visit'),
            ]);
            $userTravelHistory->save();
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess("Travel History Added Successfully");
        }
    }

    // delete Travel history  details from ProfileTravelHistory  table
    public function travelHistoryDelete(Request $request)
    {
        $userTravelDetail = ProfileTravelHistory::where('id', $request->id)->first();
        if ($userTravelDetail) {
            ProfileTravelHistory::where('id', $request->id)->delete();
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess("Travel History Deleted Successfully");
        } else {
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashDanger("Travel History Not Found!");
        }
    }

    // Visa history
    public function addVisaHistory()
    {
        $countries = Country::orderBy('title_en')->select('id', 'title_en as name')->get();
        return view('frontend.user.student-details-add-edit-modal.add_visa_history_model', ['countries' => $countries]);
    }

    public function editVisaHistory($id)
    {
        $countries = Country::orderBy('title_en')->select('id', 'title_en as name')->get();
        $profile_visa_application_history = DB::table('visa_application_history')->where('id', $id)->first();

        return view('frontend.user.student-details-add-edit-modal.edit_visa_history_model', ['profile_visa_application_history' => $profile_visa_application_history, 'countries' => $countries]);
    }

    public function visaHistorySave(Request $request)
    {
        $request->validate([
            'country_applied_for_visa' => 'required',
            'name_used_for_visa_apply' => 'required|max:100|regex:/^[\pL\s]+$/u',
            'visa_apply_visa_type' => 'required|max:100',
            'visa_apply_application_date' => 'required|before:' . now(),
            'visa_apply_application_number' => 'required|max:100',
            'visa_apply_outcome' => 'required|max:100'
        ]);
        if (!empty($request->input('visa_apply_application_date'))) {
            $visa_apply_application_date = substr($request->input('visa_apply_application_date'), 6, 4) . "-" . substr($request->input('visa_apply_application_date'), 3, 2) . "-" . substr($request->input('visa_apply_application_date'), 0, 2);
        } else {
            $visa_apply_application_date = NULL;
        }

        if ($request->visa_id) {
            $userVisaHistory = ProfileVisaApplicationHistory::where('id', $request->visa_id)->first();
            $userVisaHistory->user_id = $request->get('user_id');
            $userVisaHistory->country_applied_for_visa = $request->get('country_applied_for_visa');
            $userVisaHistory->name_used_for_visa_apply = $request->get('name_used_for_visa_apply');
            $userVisaHistory->visa_apply_visa_type = $request->get('visa_apply_visa_type');
            $userVisaHistory->visa_apply_application_date = $visa_apply_application_date;
            $userVisaHistory->visa_apply_application_number = $request->get('visa_apply_application_number');
            $userVisaHistory->visa_apply_outcome = $request->get('visa_apply_outcome');
            $userVisaHistory->save();
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess("Visa History Updated Successfully");
        } else {
            $userVisaHistory = new ProfileVisaApplicationHistory([
                'user_id'    => $request->get('user_id'),
                'country_applied_for_visa' => $request->get('country_applied_for_visa'),
                'name_used_for_visa_apply' => $request->get('name_used_for_visa_apply'),
                'visa_apply_visa_type' => $request->get('visa_apply_visa_type'),
                'visa_apply_application_date' => $visa_apply_application_date,
                'visa_apply_application_number' => $request->get('visa_apply_application_number'),
                'visa_apply_outcome' => $request->get('visa_apply_outcome'),
            ]);
            $userVisaHistory->save();
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess("Visa History Added Successfully");
        }
    }
    // delete Visa  details from ProfileVisaApplicationHistory  table
    public function VisaDelete(Request $request)
    {
        $userVisaDetail = ProfileVisaApplicationHistory::where('id', $request->id)->first();
        if ($userVisaDetail) {
            ProfileVisaApplicationHistory::where('id', $request->id)->delete();
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashSuccess("Visa Details Deleted Successfully");
        } else {
            return redirect()->route('frontend.user.studyabroad.profile')->withFlashDanger("Visa Details Not Found!");
        }
    }
}
