<?php

namespace App\Http\Controllers\Frontend\User;

use App\Http\Controllers\Controller;
use App\Repositories\Frontend\Auth\UserRepository;
use App\Models\Auth\UserDetails;
use Illuminate\Http\Request;
/**
 * Class PaymentPreferenceController.
 */
class PaymentPreferenceController extends Controller
{
     /**
     * @var UserRepository
     */
    protected $userRepository;

    /**
     * ChangePasswordController constructor.
     *
     * @param UserRepository $userRepository
     */
    public function __construct(UserRepository $userRepository)
    {
        $this->userRepository = $userRepository;
    }

    /**
     * @param updatePaymentPreference $request
     *
     * @return mixed
     * @throws \App\Exceptions\GeneralException
     */

    public function update_payment_preference(Request $request)
    {
        $userDetails = UserDetails::where('userid', $request->user_id)->first();
        if($userDetails){
            $userDetails->payment_pref_mode = $request->mode;
            $userDetails->payment_pref_detail = $request->details;
            $userDetails->save();
            return redirect()->route('frontend.user.profile')->withFlashSuccess('Payment Preference successfully updated.');
        }else{
            return redirect()->route('frontend.user.profile')->withFlashDanger('Invalid User');
        }
        // $this->userRepository->updatePaymentPreference($request->only('mode','details','user_id'));
        
        // return redirect()->route('frontend.user.profile')->withFlashSuccess(__('strings.frontend.user.payment_preference_updated'));
        
    }
}
