<?php

namespace App\Http\Controllers\Frontend\User;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Repositories\Frontend\Auth\UserRepository;
use App\Http\Requests\Frontend\User\UpdateGreGmatRequest;
use App\Http\Requests\Frontend\User\UpdateProfileRequest;
use App\Http\Requests\Frontend\User\UpdateAcademicsRequest;
use App\Http\Requests\Frontend\User\UpdateBasicInfoRequest;
use App\Http\Requests\Frontend\User\UpdateLanguagesRequest;
use App\Http\Requests\Frontend\User\UpdateExperienceRequest;
use App\Http\Requests\Frontend\User\UpdateInternshipsRequest;

/**
 * Class ProfileController.
 */
class ProfileController extends Controller {

    /**
     * @var UserRepository
     */
    protected $userRepository;

    /**
     * ProfileController constructor.
     *
     * @param UserRepository $userRepository
     */
    public function __construct(UserRepository $userRepository) {
        $this->userRepository = $userRepository;
    }

    /**
     * @param UpdateProfileRequest $request
     *
     * @return mixed
     * @throws \App\Exceptions\GeneralException
     */
    public function update(UpdateProfileRequest $request) {
        if(auth()->user()->id != 1) {
            $output = $this->userRepository->update(
                    auth()->user()->id, $request->only('first_name', 'last_name', 'email', 'avatar_type', 'avatar_location'), $request->has('avatar_location') ? $request->file('avatar_location') : false
            );

            // E-mail address was updated, user has to reconfirm
            if (is_array($output) && $output['email_changed']) {
                auth()->logout();

                return redirect()->route('frontend.auth.login')->withFlashInfo(__('strings.frontend.user.email_changed_notice'));
            }
        }
        return redirect()->route('frontend.user.account')->withFlashSuccess(__('strings.frontend.user.profile_updated'));
    }

    /**
     * @param UpdateBasicInfoRequest $request
     *
     * @return mixed
     * @throws \App\Exceptions\GeneralException
     */
    public function updatebasicinfo(Request $request) {
        $id = auth()->user()->id;
        $validator = \Validator::make($request->all(), [
            'first_name'  => ['required', 'max:50','regex:/^[\pL\s]+$/u'],
            'last_name'  => ['required', 'max:50','regex:/^[\pL\s]+$/u'],
            'gender'  => ['required'],
            'country'  => ['required'],
            'state'  => ['required'],
            'city'  => ['required'],
        ]);
        
        if ($validator->fails()) {
            $message = $validator->getMessageBag()->toArray();

            if(isset($message['first_name'][0])){
                return response()->json(['error' => $message['first_name'][0]], 404);
            } elseif(isset($message['last_name'][0])){
                return response()->json(['error' => $message['last_name'][0]], 404);
            } elseif(isset($message['gender'][0])){
                return response()->json(['error' => $message['gender'][0]], 404);
            } elseif(isset($message['birthday'][0])){
                return response()->json(['error' => $message['birthday'][0]], 404);
            } elseif(isset($message['country'][0])){
                return response()->json(['error' => $message['country'][0]], 404);
            } 
            elseif(isset($message['state'][0])){
                return response()->json(['error' => $message['country'][0]], 404);
            } 
            elseif(isset($message['city'][0])){
                return response()->json(['error' => $message['country'][0]], 404);
            } 
        }  

        if(get_site_config('student_create_admin_mandatory') == 'email'){
            $validator = \Validator::make($request->all(), [
                'email' => 'required|email|unique:users,email,' . auth()->user()->id,
                'mobile' => ['nullable', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH')],
            ]);

            if ($validator->fails()) {
                $message = $validator->getMessageBag()->toArray();
                if(isset($message['email'][0])){
                    return response()->json(['error' => $message['email'][0]], 404);
                } 
            } 

        } elseif(get_site_config('student_create_admin_mandatory') == 'email_and_mobile'){
            $validator = \Validator::make($request->all(), [
                'email' => 'required|email|unique:users,email,' . auth()->user()->id,
                'mobile' => ['required', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH'), 'unique:users,mobile,' . auth()->user()->id],
            ]);

            if ($validator->fails()) {
                $message = $validator->getMessageBag()->toArray();
                if(isset($message['mobile'][0])){
                    return response()->json(['error' => $message['mobile'][0]], 404);
                } 
            } 
        } 

        if(env('DEMO_MODE') && in_array($request->user()->id, config('app.demo_users')))
            return redirect()->route('frontend.demo-user-restriction');   
        
        if(auth()->user()->id != 1) {
            $output = $this->userRepository->updateBasicInfo(
                    $request->user()->id, $request->all(), $request->has('avatar_location') ? $request->file('avatar_location') : false
            );
        }

        // return redirect()->route('frontend.user.profile')->withFlashSuccess(__('strings.frontend.user.profile_updated'));

        $success_msg = __('strings.frontend.user.profile_updated');
        return response()->json(['success' => $success_msg], 200);
    }

    /**
     * @param UpdateAcademicsRequest $request
     *
     * @return mixed
     * @throws \App\Exceptions\GeneralException
     */
    public function updateacademics(UpdateAcademicsRequest $request) {

        $data = $request->all();
        $userid = $request->user()->id;

        $aca_level = array('10', '12', 'Diploma', 'Bachelors', 'Masters', 'Other');
        for ($i = 0; $i < count($aca_level); $i++) {
            $exam_name = $aca_level[$i];
            $percent_cgpa = $data['aca'][$exam_name]['percent_cgpa'];
            $pass_year = $data['aca'][$exam_name]['pass_year'];
            $specialization = $data['aca'][$exam_name]['specialization'];
            $school_college = $data['aca'][$exam_name]['school_college'];
            $university = $data['aca'][$exam_name]['university'];
            $backlogs = $data['aca'][$exam_name]['backlogs'];

            DB::table('user_academics')
                    ->updateOrInsert(
                            ['userid' => $userid, 'education_level' => $exam_name], ['percent_cgpa' => $percent_cgpa,
                        'pass_year' => $pass_year,
                        'specialization' => $specialization,
                        'school_college' => $school_college,
                        'university' => $university,
                        'backlogs' => $backlogs
                            ]
            );
            //\Log::debug("::san::  userid:" . $userid . " education_level:" . $exam_name . " percent_cgpa:" . $percent_cgpa . " pass_year:" . $pass_year . " specialization:" . $specialization . " school_college:" . $school_college . " university:" . $university . " backlogs:" . $backlogs);
        }
        return redirect()->route('frontend.user.academics')->withFlashSuccess("Academics data updated successfully");
    }

    /**
     * @param UpdateLanguagesRequest $request
     *
     * @return mixed
     * @throws \App\Exceptions\GeneralException
     */
    public function updatelangs(UpdateLanguagesRequest $request) {

        $data = $request->all();
        $userid = $request->user()->id;

        $eng_exam = array('IELTS', 'TOEFL', 'PTE');
        for ($i = 0; $i < count($eng_exam); $i++) {
            $exam_name = $eng_exam[$i];
            $overall_score = $data['eng'][$exam_name]['overall_score'];
            $speaking = $data['eng'][$exam_name]['speaking'];
            $reading = $data['eng'][$exam_name]['reading'];
            $listening = $data['eng'][$exam_name]['listening'];
            $writing = $data['eng'][$exam_name]['writing'];
            $expiry_date = $data['eng'][$exam_name]['expiry_date'];
            if($expiry_date) {
                $expiry_date_db = date("Y-m-d", strtotime(substr($expiry_date, 6, 4) . "-" . substr($expiry_date, 3, 2) . "-" . substr($expiry_date, 0, 2)));
            } else {
                $expiry_date_db = NULL;
            }

            DB::table('user_certification_eng')
                    ->updateOrInsert(
                            ['userid' => $userid, 'exam' => $exam_name], ['overall_score' => $overall_score,
                        'speaking' => $speaking,
                        'reading' => $reading,
                        'listening' => $listening,
                        'writing' => $writing,
                        'expiry_date' => $expiry_date_db
                            ]
            );
            //\Log::debug("::san::  userid: . $userid ");
        }

        $lang_exam = array('German', 'French', 'Spanish', 'Japanese');
        for ($i = 0; $i < count($lang_exam); $i++) {
            $exam_name = $lang_exam[$i];
            $level = $data['lang'][$exam_name]['level'];
            $overall_score = $data['lang'][$exam_name]['overall_score'];
            $speaking = $data['lang'][$exam_name]['speaking'];
            $reading = $data['lang'][$exam_name]['reading'];
            $listening = $data['lang'][$exam_name]['listening'];
            $writing = $data['lang'][$exam_name]['writing'];
            $institute = $data['lang'][$exam_name]['institute'];

            if (!empty($level)) {
                DB::table('user_certification_lang')
                        ->updateOrInsert(
                                ['userid' => $userid, 'language' => $exam_name, 'level' => $level], ['overall_score' => $overall_score,
                            'speaking' => $speaking,
                            'reading' => $reading,
                            'listening' => $listening,
                            'writing' => $writing,
                            'institute' => $institute
                                ]
                );
            }
            //\Log::debug("::san::  userid: . $userid ");
        }

        return redirect()->route('frontend.user.langs')->withFlashSuccess("Language certification data updated successfully");
    }

    /**
     * @param UpdateGreGmatRequest $request
     *
     * @return mixed
     * @throws \App\Exceptions\GeneralException
     */
    public function updategregmat(UpdateGreGmatRequest $request) {
        $data = $request->all();
        $userid = $request->user()->id;
        //\Log::debug("::san::  uid: $userid");
        if ($data['e']['gre']['expiry_date']) {
            $gre_exp_dt = $data['e']['gre']['expiry_date'];
            $gre_exp_dt_db = date("Y-m-d", strtotime(substr($gre_exp_dt, 6, 4) . "-" . substr($gre_exp_dt, 3, 2) . "-" . substr($gre_exp_dt, 0, 2)));
        }
        else {
            $gre_exp_dt_db = NULL;
        }
        
        if ($data['e']['gmat']['expiry_date']) {
            $gmat_exp_dt = $data['e']['gmat']['expiry_date'];
            $gmat_exp_dt_db = date("Y-m-d", strtotime(substr($gmat_exp_dt, 6, 4) . "-" . substr($gmat_exp_dt, 3, 2) . "-" . substr($gmat_exp_dt, 0, 2)));            
        } else {
            $gmat_exp_dt_db = NULL;
        }

        DB::table('user_gre_gmat')
                ->updateOrInsert(
                        ['userid' => $userid, 'exam' => 'GRE'], ['total_score' => $data['e']['gre']['total_score'],
                    'verbal' => $data['e']['gre']['verbal'],
                    'quantitative' => $data['e']['gre']['quantitative'],
                    'analytical' => $data['e']['gre']['analytical'],
                    'integrated' => $data['e']['gre']['integrated'],
                    'expiry_date' => $gre_exp_dt_db
                        ]
        );

        DB::table('user_gre_gmat')
                ->updateOrInsert(
                        ['userid' => $userid, 'exam' => 'GMAT'], ['total_score' => $data['e']['gmat']['total_score'],
                    'verbal' => $data['e']['gmat']['verbal'],
                    'quantitative' => $data['e']['gmat']['quantitative'],
                    'analytical' => $data['e']['gmat']['analytical'],
                    'integrated' => $data['e']['gmat']['integrated'],
                    'expiry_date' => $gmat_exp_dt_db
                        ]
        );

        return redirect()->route('frontend.user.gregmat')->withFlashSuccess("GRE/GMAT data updated successfully");
    }

    /**
     * @param UpdateInternshipsRequest $request
     *
     * @return mixed
     * @throws \App\Exceptions\GeneralException
     */
    public function updateinternships(UpdateInternshipsRequest $request) {
        $data = $request->all();
        $userid = $request->user()->id;

        for ($i = 0; $i < count($data['internship']); $i++) {
            $internship = $data['internship'][$i];
            $company = $internship['company'];
            $duration = $internship['duration'];
            $place = $internship['place'];
            //\Log::debug("::san::  userid:  $userid company:$company duration: $duration");

            if (!empty($company) && !empty($duration)) {
                DB::table('user_internship')
                        ->updateOrInsert(
                                ['userid' => $userid, 'company' => $company], ['duration' => $duration,
                            'place' => $place
                                ]
                );
            }
        }

        for ($i = 0; $i < count($data['course']); $i++) {
            $course = $data['course'][$i];
            $course_name = $course['course'];
            $duration = $course['duration'];
            $hrs = $course['hours'];
            $institute = $course['institute'];
            //\Log::debug("::san::  userid:  $userid company:$company duration: $duration");

            if (!empty($course_name)) {
                DB::table('user_courses')
                        ->updateOrInsert(
                                ['userid' => $userid, 'course' => $course_name], ['duration' => $duration,
                            'hours' => $hrs,
                            'institute' => $institute
                                ]
                );
            }
        }

        return redirect()->route('frontend.user.internships')->withFlashSuccess("Internship data updated successfully");
    }

    /**
     * @param UpdateExperienceRequest $request
     *
     * @return mixed
     * @throws \App\Exceptions\GeneralException
     */
    public function updateexperience(UpdateExperienceRequest $request) {
        $data = $request->all();
        $userid = $request->user()->id;

        for ($i = 0; $i < count($data['experience']); $i++) {
            $experience = $data['experience'][$i];
            $company = $experience['company'];
            $designation = $experience['designation'];
            $start_date = $experience['start_date'];
            $end_date = $experience['end_date'];
            if($start_date) {
                $start_date_db = date("Y-m-d", strtotime(substr($start_date, 6, 4) . "-" . substr($start_date, 3, 2) . "-" . substr($start_date, 0, 2)));
            } else {
                $start_date_db = NULL;
            }     
            if($end_date) {
                $end_date_db = date("Y-m-d", strtotime(substr($end_date, 6, 4) . "-" . substr($end_date, 3, 2) . "-" . substr($end_date, 0, 2)));
            } else {
                $end_date_db = NULL;
            }            
            //\Log::debug("::san::  userid:  $userid company:$company duration: $duration");

            if (!empty($company)) {
                DB::table('user_experience')
                        ->updateOrInsert(
                                ['userid' => $userid, 'company' => $company], ['designation' => $designation,
                            'start_date' => $start_date_db,
                            'end_date' => $end_date_db
                                ]
                );
            }
        }

        return redirect()->route('frontend.user.experience')->withFlashSuccess("Experience data updated successfully");
    }

}
