<?php

namespace App\Http\Controllers\Frontend\User;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Auth\FileUpload;
use App\Models\Auth\Category;

class ResourcesController extends Controller {

    public function index() {
        $detail = DB::table('category')
                ->select('category.category', 'category.id')
                ->get();
        return view('frontend.user.resourseshome', ['detail' => $detail]);
    }

    public function category($category) {
        $folders = array();
        $rows = DB::table('file_upload')->select('filename', 'title', 'id')->where('category', $category)->get();
        if ($rows) {
            foreach ($rows as $row) {
                $folders[] = array("id" => $row->id, "title" => $row->title, "filename" => substr($row->filename, -3), "file" => $row->filename);
            }
        }
        return view('frontend.user.resources', ['folders' => $folders]);
    }

    public function media($id) {
        $datas = DB::table('file_upload')->select('filename')->where('id', $id)->get();
        return view('frontend.user.resoursesvideo', ['datas' => $datas]);
    }

}
