<?php
/**** This file is not used *****/
namespace App\Http\Controllers\Frontend\User;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Repositories\Frontend\Auth\UserRepository;
use App\Recipients\AdminRecipient;
use App\Notifications\Frontend\AdminAlert;

/**
 * Class SOPController.
 */
class SOPController extends Controller {

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index() {
        $data = array();
        $userid = \Auth::user()->id;

        $requested = DB::table('sop')->where('userid', $userid)->first();
        if ($requested) {
            $data = ["status" => $requested->status, "date" => $requested->date];
        }
        return view('frontend.user.sop', ['data' => $data]);
    }

    public function request() {
        $user = \Auth::user();
        $userid = $user->id;

        $requested = DB::table('sop')->where('userid', $userid)->first();
        if ($requested) {
            return redirect()->route('frontend.user.sop')->withFlashDanger("You SOP request already exists");
        }
        DB::table('sop')->insert(['userid' => $userid, 'date' => date("Y-m-d")]);
        $message = "Dear Support,<br />A New SOP Request is received from User: " . $user->first_name;
        $ticket_id = create_new_ticket($userid, "New SOP Request", $message);
        //Notify admin
        $email_message = "Ticket #$ticket_id is auto created.<br /><br /><hr>$message<hr><br /><br />View Ticket Details: <br /><a href=\"" . url("admin/ticket/" . $ticket_id) . "\">" . url("admin/ticket/" . $ticket_id) . "</a>";
        $recipient = new AdminRecipient();
        try{
            //$recipient->notify(new AdminAlert("[Ticket ID: $ticket_id] New SOP Request", $email_message));
            user_notify($recipient,"[Ticket ID: $ticket_id] New SOP Request", $email_message);
        }catch (\Exception $e) {
            $message = $e->getMessage();
            \Log::debug("Mail Error: (Ticket Autogeneration) ".$message);   
        }
        return redirect()->route('frontend.user.sop')->withFlashSuccess("Your SOP request is Submitted");
    }

}
