<?php

namespace App\Http\Controllers\Frontend\User;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Repositories\Frontend\Auth\UserRepository;
use App\Recipients\AdminRecipient;
use App\Models\Auth\ApplicationActivity;
use App\Models\Auth\UniversityApplication;
use App\Models\Auth\ApplicationMessages;
use App\Notifications\Frontend\AdminAlert;
use App\Mail\MailSend;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;
use App\Models\Auth\VisaServicesActivity;
use App\Models\Auth\ServiceApplicationMessage;
use App\Models\Auth\ServiceApplications;

/**
 * Class ApplicationsController.
 */
class ServiceAndVisaApplicationsController extends Controller{

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(){
        $data = array();
        $userid = \Auth::user()->id;

        $data = array();
        $service_applications = DB::table('service_applications')->where('user_id', $userid)->orderBy('id', 'desc')->get();
        return view('frontend.user.visa-and-services.applications', ['service_applications' => $service_applications]);
    }

    public function detail($id){
        $userid = \Auth::user()->id;
        $service_applications = DB::table('service_applications')->where('user_id', $userid)->where('id', $id)->first();
        $msgs = DB::table('service_application_messages')->where('application_id', $id)->orderBy('id', 'desc')->get();
        if ($service_applications) {
            $appActivity = VisaServicesActivity::where('appl_id',$id)->orderBy('created_at','desc')->get();
            return view('frontend.user.visa-and-services.application_detail', ['country' => $service_applications->country, 'service_applications' => $service_applications, 'app_messages' => $msgs, 'appActivity' => $appActivity]);
        } else {
            return redirect()->route('frontend.user.service-visa.applications')->withFlashDanger("Visa and Service Application ID Not Found");
        }
    }

    public function sendMessage(Request $request){
        $request->validate(
            [
                'message' => 'required',
                'attachment.*' => 'mimes:jpg,jpeg,docx,pdf,doc,png|max:8000'
            ],
            [
                'attachment.*.mimes' => 'Only pdf, doc, docx, jpeg, png files are allowed',
                'image_file.*.max' => 'Sorry! Maximum allowed file size is 8MB',
            ]
        );

        $data = $request->all();
        $msg = new ServiceApplicationMessage;

        $msg->application_id = $request->app_id;
        $msg->user_id = \Auth::user()->id;
        $msg->message = $request->message;

        if ($request->file('attachment')) {
            $cnt = 1;
            foreach ($request->file('attachment') as $file) {
                $filename = $file->getClientOriginalName();
                $filename = str_replace(" ", "-", $filename);
                $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
                if (strlen($filename) > 20) {
                    $filename = substr($filename, 0, 20);
                }
                $filename .= Str::random(10);
                $path = $file->storeAs('/app_messages', $filename . "." . $file->getClientOriginalExtension(), 'public');
                if ($cnt == 1) {
                    $msg->attachment_1 = $path;
                } elseif ($cnt == 2) {
                    $msg->attachment_2 = $path;
                } elseif ($cnt == 3) {
                    $msg->attachment_3 = $path;
                } elseif ($cnt == 4) {
                    $msg->attachment_4 = $path;
                }
                $cnt++;
            }
        }
        $msg->save();

        $application = ServiceApplications::find($request->app_id);
        
        //Notify Staff
        $subject = "New Visa and Service Application #".$application->appl_id." Message by "._label('backend_student');
        $email_message = "Hi, <br><br>New Visa and Service Application Message by "._label('backend_student').".<br>Application: #".$application->appl_id."<br> Name: ".get_user_full_name_by_id($msg->user_id)."<br>Message: ".$msg->message;
        send_mail_notification($msg->user_id,$application->id,"VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT",$subject,$email_message, true);

        // Send Push App Notification
        $subject = "";
        $message = "New Visa and Service Application #".$application->appl_id." Message by "._label('backend_student').": " . get_user_full_name_by_id(\Auth::user()->id) . 
        ", Message: ".$msg->message;
        send_in_app_notification(
            $application->user_id, 
            $application->appl_id, 
            "VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT", 
            $subject, 
            $message,
            "visa",
            true
        );

        // $row = DB::table('users')->where('id', $msg->user_id)->first();
        // try{
        //     if($row->assigned_to){
        //         // User::find($row->assigned_to);
        //         $staff = DB::table('users')->where('id', $row->assigned_to)->first();
        //         Mail::to($staff->email)->send(new MailSend("New Visa and Service Application Message by student", $email_message));
        //     }else{
        //         //No need to send to admin
        //         //$recipient = new AdminRecipient();
        //         //$recipient->notify(new AdminAlert("New Application Message by student", $email_message));
        //     }         
        // }catch (\Exception $e) {
        //     $message = $e->getMessage();
        //     \Log::debug("Mail Error: (New Message by User) ".$message);   
        // }

        return redirect()->route('frontend.user.service-visa.applications')->withFlashSuccess("Message sent successfully");
    }

}
