<?php

namespace App\Http\Controllers\Frontend\User;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Repositories\Frontend\Auth\UserRepository;
use App\Http\Requests\Frontend\User\UpdateAcademicsRequest;

/**
 * Class StudentAcademicsController.
 */
class StudentAcademicsController extends Controller
{

    
    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $data = array();
        $userid = \Auth::user()->id;

        $rows = DB::table('user_academics')->where('userid', $userid)->get();
        //var_export($rows);
        if($rows) {
            foreach($rows as $row) {
                $data[$row->education_level]['percent_cgpa'] = $row->percent_cgpa;
                $data[$row->education_level]['pass_year'] = $row->pass_year;
                $data[$row->education_level]['specialization'] = $row->specialization;
                $data[$row->education_level]['school_college'] = $row->school_college;
                $data[$row->education_level]['university'] = $row->university;
                $data[$row->education_level]['backlogs'] = $row->backlogs;
            }
        }        
        return view('frontend.user.academicsinfo', ['data' => $data]);
    }
    
    
    
}
