<?php

namespace App\Http\Controllers\Frontend\User;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Repositories\Frontend\Auth\UserRepository;
use App\Http\Requests\Frontend\User\UpdateBasicInfoRequest;
use App\Models\Auth\Country;
use Illuminate\Http\Request;

/**
 * Class StudentBasicInfoController.
 */
class StudentBasicInfoController extends Controller
{

    
    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $userid = \Auth::user()->id;
        $items = Country::pluck('title_en', 'id');
        $dialcodes = Country::groupBy('tel')->orderBy('tel','asc')->get(['tel as code', 'title_en as name']);

        $defCountryCode = env('USER_DEFAULT_DIALCODE');
        $def_dialcode = $dialcodes = Country::where('tel', $defCountryCode)->first();
        $users = DB::table('users')->where('ref_by',auth()->user()->id)->get();
        $reff_commission = DB::table('referral_commission')
        ->where('user_id',auth()->user()->id)
        ->where('paid',1)
        ->orderBy('created_at','DESC')
        ->get();
        //->select("select * from referral_commission where user_id='".auth()->user()->id."', where paid='1' order by created_at desc");

        $userDetails = DB::table('user_details')->where('userid', $userid)->first();

        // if(!$userDetails) {
        //     DB::table('user_details')->insert(['userid' => $userid]);
        //     $userDetails = DB::table('user_details')->where('userid', $userid)->first();
        // }


        return view('frontend.user.profile',compact('items', 'dialcodes', 'def_dialcode', 'defCountryCode','reff_commission','users','userDetails'));
    }
    
    public function accountRemoval(Request $request){
        // dd($request->all());
        $userId = \Auth::user()->id;
        $user = \Auth::user();
        
        if($request->confirm_delete_text == "DELETE"){

            $subject = _label('backend_student') . ": {$user->full_name} ({$user->id}) requested account deletion.";
            $email_message = "
                Hi,<br/><br/>
                The following " . _label('backend_student') . " has requested account deletion.<br/><br/>
                <strong>Student Details:</strong><br/>
                Name: {$user->first_name} {$user->last_name}<br/>
                Mobile: {$user->mobile}<br/>
                Email: {$user->email}<br/><br/>
                Please review this request and take necessary actions.<br/><br/>
            ";

            $subject = _label('backend_student').": " . $user->full_name . " (".$user->id.") requested account deletion.";

            //Sending email Notification
            send_mail_notification($user->id, "", "LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE", $subject, $email_message);

            $subject = "";
            $email_message = "
                Requested Account Deletion: The following " . _label('backend_student') . " has requested account deletion.<br/>
                <strong>Student Details:</strong><br/>
                Name: {$user->first_name} {$user->last_name}<br/>
                Mobile: {$user->mobile}<br/>
                Email: {$user->email}<br/>
                Please review this request and take necessary actions.<br/>
            ";
            send_in_app_notification(
                $user->id, 
                $user->id,
                "LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE", 
                $subject, 
                $email_message,
                "student"
            );

            $user->active = 0;
            $user->save();

            // Logout user
            auth()->logout();

            return redirect()->route('frontend.auth.login')->withFlashSuccess('Your account deletion request has been submitted successfully and it will be removed within 7 days.');
        }

        return redirect()->route('frontend.user.profile')->withFlashDanger('Please confirm account deletion by checking the box.');
    }
    
}
