<?php

namespace App\Http\Controllers\Frontend\User;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Repositories\Frontend\Auth\UserRepository;
use App\Http\Requests\Frontend\User\StudentDocsRequest;
use Illuminate\Support\Str;

/**
 * Class StudentLangsController.
 */
class StudentDocsController extends Controller {

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index() {
        $data = array();
        $userid = \Auth::user()->id;

        if (!DB::table('user_documents')->where('userid', $userid)->exists()) {
            DB::table('user_documents')->insert(['userid' => $userid]);
        }

        $row = DB::table('user_documents')->where('userid', $userid)->first();
        $row_sop = DB::table('user_docs_other')->where('userid', $userid)->where('doc_type', 'sop')->first();
        $row_lor = DB::table('user_docs_other')->where('userid', $userid)->where('doc_type', 'letter_of_recommendation')->first();
        $data['class10'] = $row->class10;
        $data['class10_marks_sheet'] = $row->class10_marks_sheet;
        $data['class12'] = $row->class12;
        $data['class12_marks_sheet'] = $row->class12_marks_sheet;
        $data['diploma'] = $row->diploma;
        $data['diploma_marks_sheet'] = $row->diploma_marks_sheet;
        $data['grad_all_sem'] = $row->grad_all_sem;
        $data['grad_degree'] = $row->grad_degree;
        $data['grad_transcripts'] = $row->grad_transcripts;
        $data['pg_all_sem'] = $row->pg_all_sem;
        $data['pg_degree'] = $row->pg_degree;
        $data['pg_transcripts'] = $row->pg_transcripts;
        $data['lang_ielts'] = $row->lang_ielts;
        $data['lang_pte'] = $row->lang_pte;
        $data['sop'] = $row_sop ? $row_sop->file : '';
        $data['letter_recom'] = $row_lor ? $row_lor->file : '';
        $data['gre'] = $row->gre;
        $data['gmat'] = $row->gmat;

        $internships = array();
        $offerletters = array();
        $experience = array();
        $payslips = array();
        $otherdocs = array();
        $rows = DB::table('user_docs_other')->where('userid', $userid)->get();
        if ($rows) {
            foreach ($rows as $row) {
                if ($row->doc_type == 'internship') {
                    $internships[] = $row->file;
                } elseif ($row->doc_type == 'offer') {
                    $offerletters[] = $row->file;
                } elseif ($row->doc_type == 'experience') {
                    $experience[] = $row->file;
                } elseif ($row->doc_type == 'payslip') {
                    $payslips[] = $row->file;
                } elseif ($row->doc_type == 'other') {
                    $otherdocs[] = $row->file;
                }
            }
        }
        $data['internships'] = $internships;
        $data['offerletters'] = $offerletters;
        $data['experience'] = $experience;
        $data['payslips'] = $payslips;
        $data['otherdocs'] = $otherdocs;

        return view('frontend.user.documents', $data);
    }

    public function upload(StudentDocsRequest $request) {
        \Log::debug("----- StudentDocsController:upload() BEGIN");
        $message = "";
        $userid = \Auth::user()->id;

        if (!DB::table('user_documents')->where('userid', $userid)->exists()) {
            DB::table('user_documents')->insert(['userid' => $userid]);
        }

        if ($request->file('class10')) {
            $file = $request->file('class10');
            $filename = $file->getClientOriginalName();
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            DB::table('user_documents')->where('userid', $userid)->update(['class10' => $path]);
            $message .= "10th Document Uploaded Successfully.";
        }
        if ($request->file('class10_marks_sheet')) {
            $file = $request->file('class10_marks_sheet');
            $filename = $file->getClientOriginalName();
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            DB::table('user_documents')->where('userid', $userid)->update(['class10_marks_sheet' => $path]);
            $message .= "10th Marksheet Uploaded Successfully.";
        }

        if ($request->file('class12')) {
            $file = $request->file('class12');
            $filename = $file->getClientOriginalName();
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            DB::table('user_documents')->where('userid', $userid)->update(['class12' => $path]);
            $message .= " 12th Document Uploaded Successfully.";
        }
        if ($request->file('class12_marks_sheet')) {
            $file = $request->file('class12_marks_sheet');
            $filename = $file->getClientOriginalName();
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            DB::table('user_documents')->where('userid', $userid)->update(['class12_marks_sheet' => $path]);
            $message .= " 12th Marks Sheet Uploaded Successfully.";
        }
        

        if ($request->file('diploma')) {
            $file = $request->file('diploma');
            $filename = $file->getClientOriginalName();
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            DB::table('user_documents')->where('userid', $userid)->update(['diploma' => $path]);
            $message .= " Diploma Document Uploaded Successfully.";
        }
        if ($request->file('diploma_marks_sheet')) {
            $file = $request->file('diploma_marks_sheet');
            $filename = $file->getClientOriginalName();
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            DB::table('user_documents')->where('userid', $userid)->update(['diploma_marks_sheet' => $path]);
            $message .= " Diploma Marks Sheet Uploaded Successfully.";
        }

        if ($request->file('grad_all_sem')) {
            $file = $request->file('grad_all_sem');
            $filename = $file->getClientOriginalName();
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            DB::table('user_documents')->where('userid', $userid)->update(['grad_all_sem' => $path]);
            $message .= " Bachelors (All Sem) Document Uploaded Successfully.";
        }

        if ($request->file('grad_degree')) {
            $file = $request->file('grad_degree');
            $filename = $file->getClientOriginalName();
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            DB::table('user_documents')->where('userid', $userid)->update(['grad_degree' => $path]);
            $message .= " Bachelors Degree Document Uploaded Successfully.";
        }

        if ($request->file('grad_transcripts')) {
            $file = $request->file('grad_transcripts');
            $filename = $file->getClientOriginalName();
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            DB::table('user_documents')->where('userid', $userid)->update(['grad_transcripts' => $path]);
            $message .= " Granduation Transcripts Uploaded Successfully.";
        }

        if ($request->file('pg_all_sem')) {
            $file = $request->file('pg_all_sem');
            $filename = $file->getClientOriginalName();
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            DB::table('user_documents')->where('userid', $userid)->update(['pg_all_sem' => $path]);
            $message .= " Masters (All Sem) Document Uploaded Successfully.";
        }

        if ($request->file('pg_degree')) {
            $file = $request->file('pg_degree');
            $filename = $file->getClientOriginalName();
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            DB::table('user_documents')->where('userid', $userid)->update(['pg_degree' => $path]);
            $message .= " Masters Degree Document Uploaded Successfully.";
        }

        if ($request->file('pg_transcripts')) {
            $file = $request->file('pg_transcripts');
            $filename = $file->getClientOriginalName();
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            DB::table('user_documents')->where('userid', $userid)->update(['pg_transcripts' => $path]);
            $message .= " Masters Transcripts Uploaded Successfully.";
        }

        if ($request->file('lang_ielts')) {
            $file = $request->file('lang_ielts');
            $filename = $file->getClientOriginalName();
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            DB::table('user_documents')->where('userid', $userid)->update(['lang_ielts' => $path]);
            $message .= " IELTS Document Uploaded Successfully.";
        }

        if ($request->file('lang_pte')) {
            $file = $request->file('lang_pte');
            $filename = $file->getClientOriginalName();
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            DB::table('user_documents')->where('userid', $userid)->update(['lang_pte' => $path]);
            $message .= " PTE Document Uploaded Successfully.";
        }

        if ($request->file('lor')) {
            $file = $request->file('lor');
            $filename = $file->getClientOriginalName();
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            DB::table('user_documents')->where('userid', $userid)->update(['lor' => $path]);
            $message .= " LOR Document Uploaded Successfully.";
        }

        if ($request->file('sop')) {
            $file = $request->file('sop');
            $filename = $file->getClientOriginalName();
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            DB::table('user_documents')->where('userid', $userid)->update(['sop' => $path]);
            $message .= " SOP Document Uploaded Successfully.";
        }

        if ($request->file('letter_recom')) {
            $file = $request->file('letter_recom');
            $filename = $file->getClientOriginalName();
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            DB::table('user_documents')->where('userid', $userid)->update(['letter_recom' => $path]);
            $message .= " Letter of Recommendation Uploaded Successfully.";
        }

        if ($request->file('gre')) {
            $file = $request->file('gre');
            $filename = $file->getClientOriginalName();
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            DB::table('user_documents')->where('userid', $userid)->update(['gre' => $path]);
            $message .= " GRE Document Uploaded Successfully.";
        }

        if ($request->file('gmat')) {
            $file = $request->file('gmat');
            $filename = $file->getClientOriginalName();
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            DB::table('user_documents')->where('userid', $userid)->update(['gmat' => $path]);
            $message .= " GMAT Document Uploaded Successfully.";
        }

        \Log::debug("------ StudentDocsController:upload() END");
        return redirect()->route('frontend.user.documents')->withFlashSuccess($message);
    }

    public function uploadInternshipDocs(StudentDocsRequest $request) {
        \Log::debug("----- StudentDocsController:uploadInternshipDocs() BEGIN");
        $userid = \Auth::user()->id;

        if ($request->file('file')) {
            $file = $request->file('file');
            $filename = $file->getClientOriginalName();
            \Log::debug("uploading:" . $filename);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);
            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => "internship", "file" => $path]);
        }

        \Log::debug("----- StudentDocsController:uploadInternshipDocs() END");
    }

    public function uploadOfferLetterDocs(StudentDocsRequest $request) {
        \Log::debug("----- StudentDocsController:uploadOfferLetterDocs() BEGIN");
        $userid = \Auth::user()->id;

        if ($request->file('file')) {
            $file = $request->file('file');
            $filename = $file->getClientOriginalName();
            \Log::debug("uploading:" . $filename);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);
            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => "offer", "file" => $path]);
        }

        \Log::debug("----- StudentDocsController:uploadOfferLetterDocs() END");
    }

    public function uploadExperienceLetterDocs(StudentDocsRequest $request) {
        \Log::debug("----- StudentDocsController:uploadExperienceLetterDocs() BEGIN");
        $userid = \Auth::user()->id;

        if ($request->file('file')) {
            $file = $request->file('file');
            $filename = $file->getClientOriginalName();
            \Log::debug("uploading:" . $filename);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);
            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => "experience", "file" => $path]);
        }

        \Log::debug("----- StudentDocsController:uploadExperienceLetterDocs() END");
    }

    public function uploadPayslipsDocs(StudentDocsRequest $request) {
        \Log::debug("----- StudentDocsController:uploadPayslipsDocs() BEGIN");
        $userid = \Auth::user()->id;

        if ($request->file('file')) {
            $file = $request->file('file');
            $filename = $file->getClientOriginalName();
            \Log::debug("uploading:" . $filename);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);
            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => "payslip", "file" => $path]);
        }

        \Log::debug("----- StudentDocsController:uploadPayslipsDocs() END");
    }

    public function uploadOtherDocs(StudentDocsRequest $request) {
        \Log::debug("----- StudentDocsController:uploadOtherDocs() BEGIN");
        $userid = \Auth::user()->id;

        if ($request->file('file')) {
            $file = $request->file('file');
            $filename = $file->getClientOriginalName();
            \Log::debug("uploading:" . $filename);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);
            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => "other", "file" => $path]);
        }

        \Log::debug("----- StudentDocsController:uploadOtherDocs() END");
    }

    public function uploadSop(StudentDocsRequest $request) {
        \Log::debug("----- StudentDocsController:uploadSop() BEGIN");
        $userid = \Auth::user()->id;

        if ($request->file('file')) {
            $file = $request->file('file');
            $filename = $file->getClientOriginalName();
            \Log::debug("uploading:" . $filename);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);
            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            if(DB::table('user_docs_other')->where('userid', $userid)->where('doc_type', 'sop')->exists()) {
                DB::table('user_docs_other')->where('userid', $userid)->where('doc_type', 'sop')->update(["file" => $path]);
            } else {
                DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => "sop", "file" => $path]);
            }
        }

        \Log::debug("----- StudentDocsController:uploadSop() END");
    }


        public function uploadLor(StudentDocsRequest $request) {
        \Log::debug("----- StudentDocsController:uploadLor() BEGIN");
        $userid = \Auth::user()->id;

        if ($request->file('file')) {
            $file = $request->file('file');
            $filename = $file->getClientOriginalName();
            \Log::debug("uploading:" . $filename);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);
            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            \Log::debug("::savedpath::$path");
            if(DB::table('user_docs_other')->where('userid', $userid)->where('doc_type', 'letter_of_recommendation')->exists()) {
                DB::table('user_docs_other')->where('userid', $userid)->where('doc_type', 'letter_of_recommendation')->update(["file" => $path]);
            } else {
                DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => "letter_of_recommendation", "file" => $path]);
            }
        }

        \Log::debug("----- StudentDocsController:uploadLor() END");
    }

}
