<?php

namespace App\Http\Controllers\Frontend\User;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Repositories\Frontend\Auth\UserRepository;
use App\Http\Requests\Frontend\User\UpdateExperienceRequest;

/**
 * Class StudentExperienceController.
 */
class StudentExperienceController extends Controller {

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index() {
        $experience = array();
        $userid = \Auth::user()->id;

        $rows = DB::table('user_experience')->where('userid', $userid)->get();
        //var_export($rows);
        if ($rows) {
            foreach ($rows as $row) {
                $experience[] = array('company' => $row->company, 'designation' => $row->designation, 'start_date' => $row->start_date, 'end_date' => $row->end_date);
            }
        }
        return view('frontend.user.experienceinfo', ['experience' => $experience]);
    }

}
