<?php

namespace App\Http\Controllers\Frontend\User;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Repositories\Frontend\Auth\UserRepository;
use App\Http\Requests\Frontend\User\UpdateGreGmatRequest;

/**
 * Class StudentAcademicsController.
 */
class StudentGreGmatController extends Controller
{

    
    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $e = array('gre' => array('total_score' => '', 'verbal' => '', 'quantitative' => '', 'analytical' => '', 'integrated' => '', 'expiry_date' => ''), 'gmat' => array('total_score' => '', 'verbal' => '', 'quantitative' => '', 'analytical' => '', 'integrated' => '', 'expiry_date' => ''));
        $userid = \Auth::user()->id;

        $rows = DB::table('user_gre_gmat')->where('userid', $userid)->get();
        //var_export($rows);
        if($rows) {
            foreach($rows as $row) {
                $exam = $row->exam;
                //\Log::debug("san:$exam");
                if($exam == 'GRE') {
                    $e['gre']['total_score'] = $row->total_score;
                    $e['gre']['verbal'] = $row->verbal;
                    $e['gre']['quantitative'] = $row->quantitative;
                    $e['gre']['analytical'] = $row->analytical;
                    $e['gre']['integrated'] = $row->integrated;
                    $e['gre']['expiry_date'] = $row->expiry_date;
                } elseif($exam == 'GMAT') {
                    $e['gmat']['total_score'] = $row->total_score;
                    $e['gmat']['verbal'] = $row->verbal;
                    $e['gmat']['quantitative'] = $row->quantitative;
                    $e['gmat']['analytical'] = $row->analytical;
                    $e['gmat']['integrated'] = $row->integrated;
                    $e['gmat']['expiry_date'] = $row->expiry_date;                    
                }
            }
        }
        
        return view('frontend.user.gregmatinfo', ['data' => $e]);
    }
    
    
    
}
