<?php

namespace App\Http\Controllers\Frontend\User;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Repositories\Frontend\Auth\UserRepository;
use App\Http\Requests\Frontend\User\UpdateInternshipsRequest;

/**
 * Class StudentInternshipsController.
 */
class StudentInternshipsController extends Controller
{

    
    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $internships = array();
        $userid = \Auth::user()->id;

        $rows = DB::table('user_internship')->where('userid', $userid)->get();
        //var_export($rows);
        if($rows) {
            foreach($rows as $row) {
                $internships[] = array('company' => $row->company, 'duration' => $row->duration, 'place' => $row->place);          
            }
        }        
        
        $courses = array();
        $rows = DB::table('user_courses')->where('userid', $userid)->get();
        //var_export($rows);
        if($rows) {
            foreach($rows as $row) {
                $courses[] = array('course' => $row->course, 'duration' => $row->duration, 'hours' => $row->hours, 'institute'=>$row->institute);          
            }
        }        
        
        return view('frontend.user.internshipsinfo', ['internships' => $internships, 'courses'=>$courses]);
    }
    
    
    
}
