<?php

namespace App\Http\Controllers\Frontend\User;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Repositories\Frontend\Auth\UserRepository;
use App\Http\Requests\Frontend\User\UpdateLanguagesRequest;

/**
 * Class StudentLangsController.
 */
class StudentLangsController extends Controller
{

    
    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $eng = array();
        $userid = \Auth::user()->id;

        $rows = DB::table('user_certification_eng')->where('userid', $userid)->get();
        //var_export($rows);
        if($rows) {
            foreach($rows as $row) {
                $eng[$row->exam]['overall_score'] = $row->overall_score;
                $eng[$row->exam]['speaking'] = $row->speaking;
                $eng[$row->exam]['reading'] = $row->reading;
                $eng[$row->exam]['writing'] = $row->writing;
                $eng[$row->exam]['listening'] = $row->listening;
                $eng[$row->exam]['expiry_date'] = $row->expiry_date;
            }
        }        
        
        $lang = array();
        $rows = DB::table('user_certification_lang')->where('userid', $userid)->get();
        //var_export($rows);
        if($rows) {
            foreach($rows as $row) {
                $lang[$row->language]['level'] = $row->level;
                $lang[$row->language]['overall_score'] = $row->overall_score;
                $lang[$row->language]['speaking'] = $row->speaking;
                $lang[$row->language]['reading'] = $row->reading;
                $lang[$row->language]['writing'] = $row->writing;
                $lang[$row->language]['listening'] = $row->listening;
                $lang[$row->language]['institute'] = $row->institute;
            }
        }
        
        return view('frontend.user.langsinfo', ['eng' => $eng, 'lang'=>$lang]);        
    }
    
    
    
}
