<?php

namespace App\Http\Controllers\Frontend\User;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Repositories\Frontend\Auth\UserRepository;
use App\Http\Requests\Frontend\User\TicketsRequest;
use App\Models\Auth\Ticket;
use Illuminate\Support\Str;
use App\Recipients\AdminRecipient;
use App\Notifications\Frontend\AdminAlert;
use App\Mail\MailSend;
use Illuminate\Support\Facades\Mail;

/**
 * Class TicketsController.
 */
class TicketsController extends Controller {

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index() {
        $userid = \Auth::user()->id;
        $tickets = Ticket::where('userid', $userid)->orderBy('updated_at', 'DESC')->orderBy('id', 'DESC')->get();
        return view('frontend.user.tickets', ['tickets' => $tickets]);
    }

    public function detail($ticket_id) {
        $userid = \Auth::user()->id;
        $messages = array();
        $ticket = Ticket::where(['userid' => $userid, 'ticket_id' => $ticket_id])->first();
        if ($ticket) {
            $rows = DB::table('ticket_reply')->where('ticket_id', $ticket_id)->orderBy('reply_timestamp', 'DESC')->get();
            if ($rows) {
                foreach ($rows as $row) {
                    $msg = html_entity_decode($row->message);
                    $messages[] = array('staff_name' => $row->staff_name, 'reply_by' => $row->reply_by, 'timestamp' => $row->reply_timestamp, 'message' => $msg, 'all_attachment' => $row->all_attachment);
                }
            }
        } else {
            return redirect()->route('frontend.user.tickets')->withFlashDanger("Ticket #" . $ticket_id . " not found!");
        }
        // dd($messages[0]['all_attachment']);
        // $all_attachments = [];    
        // if(isset($messages[0]['all_attachment'])){
        //     $all_attachments = explode("|", $messages[0]['all_attachment']);
        // }
        
        return view('frontend.user.ticketdetail', ['ticket' => $ticket, 'messages' => $messages]);
    }

    public function create(TicketsRequest $request) {
        $data = $request->all();
        $userid = $request->user()->id;
        if (!empty($data['subject'])) {
            $message = $data['message'];
            if (!empty($message)) {
                $message = nl2br($message);
                $message = str_replace(array("\n", "\r"), '', $message);

                $ticket_id = generate_ticket_id();
                $now = date("Y-m-d H:i:s");
                DB::table('tickets')->insert(["ticket_id" => $ticket_id, "userid" => $userid, "created_at" => $now, "subject" => $data['subject'], "updated_at" => $now]);
                $id = DB::table('ticket_reply')->insertGetId(["ticket_id" => $ticket_id, "reply_timestamp" => $now, "reply_by" => "user", "message" => htmlentities($message)]);
                
                //attachments
                $file_upload = $request['files'];
                $allFiles = "";
                $email_files = Array();
                if($file_upload){
                    foreach($file_upload as $file){
                        $filename = $file->getClientOriginalName();
                        $filename = str_replace(" ", "-", $filename);
                        $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
                        if (strlen($filename) > 125) {
                            $filename = substr($filename, 0, 125);
                        }
                        $filename .= Str::random(20);
            
                        $path = $file->storeAs('/tickets', $filename . "." . $file->getClientOriginalExtension(), 'public');
                        $filename = $filename.".".$file->getClientOriginalExtension();
                        $email_files[] = $filename;
                        $allFiles .= $filename."|";
                    }
                    DB::table('ticket_reply')->where("id", $id)->update(['all_attachment' => $allFiles]);
                }           

                //Notify staff
                $ticket = DB::table('tickets')->where("ticket_id", $ticket_id)->first();
                $email_message = "Hi, <br><br>Ticket #$ticket_id has been raised by " . $request->user()->first_name . " " . $request->user()->last_name . "<br /><br /><hr>$message<hr><br /><br />View Ticket Details: <br /><a href=\"" . url("admin/ticket/" . $ticket_id) . "\">" . url("admin/ticket/" . $ticket_id) . "</a>";
                $notify_emails = get_site_config('support_ticket_notification_email');
                if($notify_emails) {
                    send_event_notification_email(explode(",", $notify_emails), "[Ticket ID: $ticket_id] " . $data['subject'], $email_message);
                }
                        
                //Notify Staff
                $subject = "Ticket #$ticket_id has been raised by " . $request->user()->first_name . " " . $request->user()->last_name;
                send_mail_notification($ticket->assigned_to,"","SUPPORT_TICKET_CREATION",$subject,$email_message);

                // Send Push App Notification
                $subject = "";
                $message = "Ticket #$ticket_id has been raised by " . $request->user()->first_name . " " . $request->user()->last_name . " (" . $userid . "), Subject: " . $data['subject'];
                send_in_app_notification(
                    $userid, 
                    $userid,
                    "SUPPORT_TICKET_CREATION", 
                    $subject, 
                    $message,
                    "student"
                );

                return redirect()->route('frontend.user.tickets')->withFlashSuccess(__('labels.frontend.user.profile.ticket_created_successfully'));
            } else {
                return redirect()->route('frontend.user.tickets')->withFlashDanger(__('labels.frontend.user.profile.message_is_required'));
            }
        } else {
            return view('frontend.user.ticketnew');
        }
    }

    public function reply(TicketsRequest $request) {
        $data = $request->all();
        $userid = $request->user()->id;

        if (!empty($data['ticket_id'])) {
            $ticket_id = $data['ticket_id'];
            $ticket = Ticket::where(['userid' => $userid, 'ticket_id' => $ticket_id])->first();
            if ($ticket) {
                $message = $data['message'];
                if (!empty($message)) {
                    $message = nl2br($message);
                    $message = str_replace(array("\n", "\r"), '', $message);

                    if ($ticket->status != 'closed') {
                        $id = DB::table('ticket_reply')->insertGetId(["ticket_id" => $ticket_id, "reply_timestamp" => date("Y-m-d H:i:s"), "reply_by" => "user", "message" => htmlentities($message)]);

                        if ($ticket->status == 'staff_reply') {
                            DB::table('tickets')->where("ticket_id", $ticket_id)->update(['status' => 'customer_reply']);
                        }
                        DB::table('tickets')->where("ticket_id", $ticket_id)->update(['updated_at' => date("Y-m-d H:i:s")]);

                        //attachments
                        $file_upload = $request['files'];
                        $allFiles = "";
                        if($file_upload){
                            foreach($file_upload as $file){
                                $filename = $file->getClientOriginalName();
                                $filename = str_replace(" ", "-", $filename);
                                $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
                                if (strlen($filename) > 125) {
                                    $filename = substr($filename, 0, 125);
                                }
                                $filename .= Str::random(20);
                    
                                $path = $file->storeAs('/tickets', $filename . "." . $file->getClientOriginalExtension(), 'public');
                                $filename = $filename.".".$file->getClientOriginalExtension();
                                $allFiles .= $filename."|";
                            }
                            DB::table('ticket_reply')->where("id", $id)->update(['all_attachment' => $allFiles]);
                        }

                        //Notify staff
                        // $notify_ids = env('TICKET_NOTIFY_EMAILS');
                        // $tos = explode(",", $notify_ids);
                        // foreach ($tos as $to) {
                            //     try{
                                //         Mail::to($to)->send(new MailSend("Reply: [Ticket ID: $ticket_id] " . $ticket->subject, $email_message));
                                //     }catch (\Exception $e) {
                                    //         $message = $e->getMessage();
                                    //         \Log::debug("Mail Error: (Raised Ticket) ".$message);   
                                    //     }
                                    // }
                                    
                        $email_message = "Hi, <br><br>Ticket #$ticket_id has a new reply posted by " . $request->user()->first_name . " " . $request->user()->last_name . "<br /><br /><hr>$message<hr><br /><br />View Ticket Details: <br /><a href=\"" . url("admin/ticket/" . $ticket_id) . "\">" . url("admin/ticket/" . $ticket_id) . "</a>";
                        $subject =  "Reply: [Ticket ID: $ticket_id] ".$ticket->subject;
                        send_mail_notification($ticket->assigned_to,"","SUPPORT_TICKET_REPLY_RECEIVED",$subject,$email_message);

                        // Send Push App Notification
                        $message = "Ticket #$ticket_id has a new reply posted by " . $request->user()->first_name . " " . $request->user()->last_name . ", Subject: ".$ticket->subject.", View Ticket Details: <a href=\"" . url("admin/ticket/" . $ticket_id) . "\">" . url("admin/ticket/" . $ticket_id) . "</a>";
                        send_in_app_notification(
                            $ticket->assigned_to, 
                            $ticket->ticket_id, 
                            "SUPPORT_TICKET_REPLY_RECEIVED", 
                            $subject, 
                            $message,
                            "ticket", 
                        );

                        $notify_emails = get_site_config('support_ticket_notification_email');
                        if($notify_emails) {
                            send_event_notification_email(explode(",", $notify_emails), "Reply: [Ticket ID: $ticket_id] " . $ticket->subject, $email_message);
                        }                        

                        return redirect()->route('frontend.user.tickets')->withFlashSuccess(__('labels.frontend.user.profile.ticket_replied_successfully'));
                    } else {
                        return redirect()->route('frontend.user.tickets')->withFlashDanger(__('labels.frontend.user.profile.this_ticket_is_closed'));
                    }
                } else {
                    return redirect()->route('frontend.user.tickets')->withFlashDanger(__('labels.frontend.user.profile.message_is_required'));
                }
            } else {
                return redirect()->route('frontend.user.tickets')->withFlashDanger("Ticket #" . $ticket_id . " not found!");
            }
        } else {
            return redirect()->route('frontend.user.tickets')->withFlashDanger(__('labels.frontend.user.profile.ticket_id_required'));
        }
    }

}
