<?php

namespace App\Http\Controllers\Frontend\User;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Models\Auth\User;
use App\Models\Auth\StudentWebinar;

class WebinarStudentController extends Controller {

	public function index() {
		$userid = \Auth::user()->id;
		$ldate = date('Y-m-d');
		$datas = DB::table('webinar')
				// ->select(DB::raw('DATE_FORMAT(webinar.date, "%Y-%m-%d") as date'), DB::raw('DATE_FORMAT(webinar.date, "%d %M %y%y %h:%i %p") as datetime'), 'webinar.topic', 'webinar.image', 'webinar.description', 'courses.title', 'webinar.venue', 'webinar.link', 'webinar.id')
				->select(DB::raw('DATE_FORMAT(webinar.date, "%Y-%m-%d") as date'), DB::raw('DATE_FORMAT(webinar.date, "%d %M %Y %h:%i %p") as datetime'), 'webinar.topic', 'webinar.image', 'webinar.description', 'webinar.venue', 'webinar.link', 'webinar.id')
				// ->join('courses', 'courses.id', '=', 'webinar.course')
				->whereIn('target_user_type', ['student', 'student_agent'])
				->whereDate('webinar.date', '>=', $ldate)
				->orderby('webinar.date', "ASC")
				->get();

    	$webinars = [];
		foreach ($datas as $data) {
			$registered = 0;
			$test = DB::table('student_webinar')->where('webinar_id', $data->id)->where('student_id', $userid)->first();
			if ($test) {
				$registered = 1;
			}

			// $webinars[] = ["id" => $data->id, "date" => $data->date, "topic" => $data->topic, "image" => $data->image, "description" => $data->description, "title" => $data->title, "venue" => $data->venue, "link" => $data->link, "registered" => $registered, "datetime" => $data->datetime];
			$webinars[] = ["id" => $data->id, "date" => $data->date, "topic" => $data->topic, "image" => $data->image, "description" => $data->description, "venue" => $data->venue, "link" => $data->link, "registered" => $registered, "datetime" => $data->datetime];
		}
		// dd($webinars);
		return view('frontend.user.webinar', ['datas' => $webinars, 'ldate' => $ldate, 'userid' => $userid]);
	}

	public function register($id) {
		$userid = \Auth::user()->id;
		$rows = DB::table('webinar')->whereIn('target_user_type', ['student', 'student_agent'])->select('link', 'id')->where('webinar.id', $id)->get();
		foreach ($rows as $row) {
			$webinar_id = $row->id;
		}
		
		$user = DB::table('student_webinar')->where('student_id', $userid)->where('webinar_id', $id)->first();
		if (!$user) {
			$data = new StudentWebinar([
				'student_id' => $userid,
				'webinar_id' => $webinar_id,
			]);
			$data->save();

			// Send Push App Notification
			$webinar = DB::table('webinar')->where('id', $id)->first();
			$student = User::where('id', \Auth::user()->id)->first();
			
			//Notify Staff
			$subject = "Webinar Enrolled by " . get_user_full_name_by_id(\Auth::user()->id);
			$email_message = "Hi, <br><br>Webinar Enrolled by " . get_user_full_name_by_id(\Auth::user()->id) . 
			"<br>"._label('backend_student').": " . $student->full_name." (". $student->id. ")" .
			"<br>Webinar Date: " . $webinar->date .
			"<br>Webinar Topic: " . $webinar->topic;
			send_mail_notification($webinar->id,"","STUDENT_ENROLL_WEBINAR",$subject,$email_message);
			
			$subject = "";
			$message = "Webinar Enrolled by " . get_user_full_name_by_id(\Auth::user()->id) . 
			" ID: " .\Auth::user()->id . 
			"<br>Webinar Date: " . $webinar->date . 
			"<br>Webinar Topic: " . $webinar->topic;
			send_in_app_notification(
				\Auth::user()->id, 
				$webinar->id, 
				"STUDENT_ENROLL_WEBINAR", 
				$subject, 
				$message,
				"webinar", 
			);
			
			return redirect()->route('frontend.user.webinar.index')->withFlashSuccess("Your Registration is Successful");
		}

		return redirect()->route('frontend.user.webinar.index')->withFlashDanger('Student Already Resgistered Webinar!');
	}

}
