<?php

namespace App\Http\Controllers\Frontend;
use App\Models\CourseShortlisted;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Models\Auth\Ticket;
use App\Models\Auth\Invoice;
/**
 * Class UserHomeController.
 */
class UserHomeController extends Controller
{

    public function index()
    {
        $userid = \Auth::user()->id;
        $data = CourseShortlisted::join('university_courses', 'university_courses.id', '=', 'course_shortlisted.course_id')
        ->join('universities', 'universities.id', '=', 'university_courses.university')
        ->where('student_id', $userid)
        ->where('student_approved',0)
        ->select('course_shortlisted.*','university_courses.course_name','university_courses.university','university_courses.study_level','university_courses.campus','university_courses.duration','university_courses.intakes','universities.university_name','universities.country')
        ->orderBy('course_shortlisted.created_at', 'DESC')
        ->take(10)
        ->get();

        $dataCount = count($data);
        $takeVal = (3 - $dataCount);
        $docData = array();
        $rows = DB::table('course_recommendation')->where('userid', $userid)->orderBy('upload_date', 'desc')->where('satisfied','none')->take($takeVal)->get();
        if ($rows) {
            foreach ($rows as $row) {
                $title = $row->title;
                $upload_dt = date("j M Y", strtotime($row->upload_date));
                $filename = $row->file;
                $ext = pathinfo($filename, PATHINFO_EXTENSION);
                $file_path = url('storage/' . $filename);
                $doc = $title . " (" . $ext . ")";
                $docData[] = array('id' => $row->id, 'date' => $upload_dt, 'doc' => $doc, 'file_path' => $file_path, 'satisfied' => $row->satisfied);
            }
        }

        $applicationDocRequest = DB::table('application_doc_request')->join('university_application', 'university_application.id','=', 'application_doc_request.application_id')->where('university_application.userid', $userid)->orderBy('id', 'desc')->get(['application_doc_request.*','university_application.appl_id','university_application.id as uni_id']);



        $applicationData = array();

        $appRows = DB::table('university_application')->where('userid', $userid)->orderBy('id', 'desc')->take(3)->get();
        if ($appRows) {
            foreach ($appRows as $approw) {
                $course = "";
                // if ($approw->type == 'visa') {
                //     $visa_pref = DB::table("visa_preference")->where('id', $approw->visa_pref_id)->first();
                //     $details = get_visa_service_type_name($visa_pref->service_type)."<br />".get_visa_letter_type_name($visa_pref->letter_type);
                //     $status = $approw->visa_status;
                // } elseif ($approw->type == 'abroad_job') {
                //     $abroad_job_pref = DB::table("abroad_job_preference")->where('id', $approw->abroad_job_pref_id)->first();
                //     $details = "";
                //     $status = $approw->abroad_job_status;
                // } else {
                    $intake_str = "";
                    $intake = $approw->intake;
                    if ($intake) {
                        $str = date("Y") . "-" . $intake . "-01";
                        $intake_str = date("M", strtotime($str));
                    }
                    $details = '<a target="_blank" href="'.route('frontend.user.applications.detail',$approw->id).'">'.$approw->university.'</a>';
                    $course = $approw->course;
                    $country_code = get_country_code_by_name($approw->country);
                    $status_color = get_application_status_color($approw->status);
                    $status = $approw->status;
                // }
                array_push($applicationData, array('id' => $approw->id, 'country' => $approw->country, 'details' => $details, 'course' =>$course, 'open_date' => $approw->application_open_date, 'close_date' => $approw->application_close_date, 'status' => $status, 'status_color' => $status_color, 'appl_id' => $approw->appl_id, 'country_code' => $country_code));
            }
        }

        $tickets = Ticket::where('userid', $userid)->orderBy('updated_at', 'DESC')->orderBy('id', 'desc')->take(3)->get();

        $service_applications = DB::table('service_applications')->where('user_id', $userid)->orderBy('id', 'desc')->take(3)->get();

        $feeData = Invoice::where('student_id', '=', $userid)->latest()->take(3)->get();
        // dd($docData);
        
        return view('frontend.home', compact('data','docData','applicationDocRequest','applicationData','tickets','service_applications','feeData'));
    }  
}
