<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\Auth\User;
use App\Models\Auth\UserDetails;
use Illuminate\Support\Carbon;
use Session;
use Flash;
use Log;
use Response;
use Illuminate\Support\Facades\Mail;

class GoogleLeadsController extends Controller
{
    public function loopAllData($data) {
        $results = "";
        foreach ($data as $key => $value) {
            
                if (!is_array($value)) {
                    if($key == "column_name"){
                        $results .= $value .": ";
                    }
                    if($key=="string_value"){
                        $results .= $value . "<br>";
                    }
                }
            
                if (is_array($value)) {
                    if(!in_array("Full Name",$value) && !in_array("User Email",$value)  && !in_array("User Phone",$value)){
                     $results .= $this->loopAllData($value);
                    }
                }
            
        }
        return $results;
      }

  
    public function leads_webhook(Request $request)
    {
    
    if(get_site_config('google_lead_webhook_key')){
        Log::debug("GOOGLE LEAD WEBHOOK START");

        $data = json_decode(file_get_contents('php://input'),true);

        $name = $data['user_column_data'][0]['string_value'];
        $email = $data['user_column_data'][1]['string_value'];
        $contact_number = $data['user_column_data'][2]['string_value'];
        
        if($email==""){
            return "Email is mandatory";
        }
        if(isset($contact_number) && $contact_number!=""){
            $contact_number = str_replace( array('+',' '), '', $contact_number);
        }

        $note = $this->loopAllData($data['user_column_data']);

        Log::debug("GOOGLE LEAD WEBHOOK Data: Name:".$name);
        Log::debug("Contact:".$contact_number);
        Log::debug("Email:".$email);

        Log::debug(date('Y-m-d H:i:s').": New Google Lead: ".$email);
        
        $chklead = DB::table('users')->where('email',$email)->first();

        if(!$chklead){
            $name = explode(" ", $name);
            if(isset($name[1])){
                $last_name = $name[1];
            }
            else{
                $last_name = "";
            }
            $lead = User::create([
                'first_name' => $name[0],
                'last_name' => $last_name,
                'is_lead' => 1,
                'email' => $email,
                'mobile' => $contact_number,
                'lead_status' => get_default_lead_status(),
                'lead_source' => 'Google',
                'created_mode' => "api",
                'next_followup' => now(),
            ]);
            $leadid = DB::getPdo()->lastInsertId();
            UserDetails::create([
                'userid' => $leadid,
                'lead_notes' => $note, 
                'lead_source_detail' => "Google Lead Form", 
            ]);
            echo "\n".date('Y-m-d H:i:s').": Google Lead generated for ".$lead['email'];
            Log::debug("[GOOGLE LEAD WEBHOOK]: Google Lead generated for ".$lead['email']);
        }
        // else{
        //     echo 'Invalid verify token';
        //     Log::debug('[GOOGLE LEAD WEBHOOK]: Invalid verify token');
        // }
        else{
            echo 'Lead with this email ['.$email.'] already exists!';
            Log::debug('[GOOGLE LEAD WEBHOOK]: Lead with this email ['.$email.'] already exists!');
        }
        Log::debug("GOOGLE LEAD WEBHOOK END");
        }
    }
}
