<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Google\Client as GoogleClient;
use Google\Service\Drive;
use Google\Service\Sheets;
use App\Models\GoogleSheet;
use App\Models\Auth\User;
// use App\Models\Lead;
use Illuminate\Support\Facades\Artisan;

class GoogleSheetSyncController extends Controller{
    protected function getClient(){
        $client = new GoogleClient();
        $client->setAuthConfig(storage_path('app/google-sheet/credentials.json'));
        $client->addScope([Sheets::SPREADSHEETS_READONLY, Drive::DRIVE_METADATA_READONLY]);
        $client->setRedirectUri(env('GOOGLE_SHEET_REDIRECT_URI'));
        $client->setAccessType('offline');
        $client->setPrompt('consent');
        // if (!session('google_token')) {
        //     session(['google_token' => Auth::user()->google_token]);
        // }
        if (session('google_token')) {
            $client->setAccessToken(session('google_token'));
            // if ($client->isAccessTokenExpired()) {
            //     session()->forget('google_token');
            //     return null;
            // }
        }
        
        return $client;
    }

    public function redirect(){
        // session()->forget('google_token');
        // $client = $this->getClient();
        // if (!$client) { $client = $this->getClient(); }
        // return redirect($client->createAuthUrl());

        $client = $this->getClient();
        if (!$client) { $client = $this->getClient(); }
        return redirect($client->createAuthUrl());
    }

    public function callback(Request $req){
        $client = $this->getClient();
        $client->authenticate($req->code);
        $token = $client->getAccessToken();
        $user = User::find(Auth::user()->id);
        $user->google_token = $token['access_token'];
        $user->google_refresh_token = $token['refresh_token'] ?? $user->google_refresh_token;
        $user->google_token_expires_in = $token['expires_in'];
        $user->google_token_created_at = now();
        $user->save();
        session(['google_token' => $token['access_token']]);
        return redirect()->route('admin.google.sheets');
    }

    public function sheets(){
        $client = $this->getClient();
        if (!$client) return redirect()->route('admin.google.redirect');
        
        $drive = new Drive($client);
        $files = $drive->files->listFiles([
            'q' => "mimeType='application/vnd.google-apps.spreadsheet'",
            'fields' => 'files(id,name)'
        ])->getFiles();

        $googleSheets = GoogleSheet::select('name')->where('user_id', Auth::user()->id)->get();
        return view('backend.google.sheets', compact('files', 'googleSheets'));
    }

    public function selectSheet(Request $req){
        $req->validate(['sheet_id'=>'required', 'sheet_name'=>'required']);

        $user = Auth::user();

        // Avoid duplicates
        $exists = GoogleSheet::where('sheet_id', $req->sheet_id)->first();
        if (!$exists) {
            GoogleSheet::create([
                'sheet_id' => $req->sheet_id,
                'name'     => $req->sheet_name,
                'user_id'   => $user->id
            ]);
        }

        return redirect()->route('admin.google.sheets')->withFlashSuccess('Sheet added Successfully!');
    }

    // public function showLeads()
    // {
    //     Artisan::call('sync:google-sheets');

    //     $leads = Lead::with('user')->get();
    //     return view('leads.index', compact('leads'));
    // }

    public function getGoogleClientFromUser($user){
        $client = new GoogleClient();

        $client->setAuthConfig(storage_path('app/google-sheet/credentials.json'));
        $client->addScope([
            \Google\Service\Sheets::SPREADSHEETS_READONLY,
            \Google\Service\Drive::DRIVE_METADATA_READONLY
        ]);
        $client->setAccessType('offline');
        $client->setPrompt('consent');

        $client->setAccessToken([
            'access_token' => $user->google_token,
            'refresh_token' => $user->google_refresh_token,
            'expires_in' => $user->google_token_expires_in,
            'created' => strtotime($user->google_token_created_at)
        ]);

        if ($client->isAccessTokenExpired()) {
            $newToken = $client->fetchAccessTokenWithRefreshToken($user->google_refresh_token);
            $user->google_token = $newToken['access_token'];
            $user->google_token_expires_in = $newToken['expires_in'];
            $user->google_token_created_at = now();
            $user->save();

            $client->setAccessToken($newToken);
        }

        return $client;
    }

    public function googleUploadCredentials(Request $request){
        $request->validate([
            'credentials' => 'required|file|mimetypes:application/json,text/plain|mimes:json|max:2048',
        ]);

        $file = $request->file('credentials');

        // Path inside Laravel app directory
        $targetDir = base_path('storage/app/google-sheet');
        $targetFile = $targetDir . '/credentials.json';

        // Create directory if it doesn't exist
        if (!file_exists($targetDir)) {
            mkdir($targetDir, 0755, true);
        }

        // Delete existing file if it exists
        if (file_exists($targetFile)) {
            unlink($targetFile);
        }

        // Move new file with fixed name
        $file->move($targetDir, 'credentials.json');

        return redirect()->route('admin.integrations')->withFlashSuccess('Credentials uploaded successfully! Please connect your Google Account to sync leads with Google Sheets.');
    }
}
