<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\Auth\User;
use App\Models\Auth\PaymentGatewayTrans;
use App\Models\Auth\OrderItems;
use App\Recipients\AdminRecipient;
use App\Models\Auth\Invoice;
use App\Models\Auth\InvoicePayment;
use App\Notifications\Frontend\AdminAlert;
use App\Models\Auth\Products;
use App\Models\Auth\StudentOnlineCourse;
use App\Models\Auth\Orders;
use Srmklive\PayPal\Services\PayPal as PayPalClient;
use Log;

class PayPalPaymentController extends Controller
{
    /**
     * create transaction.
     *
     * @return \Illuminate\Http\Response
     */
    /**
     * process transaction.
     *
     * @return \Illuminate\Http\Response
     */
    public function handlePayment(Request $request)
    {
        $cart_amt = $request->fee;
        $ref_id = $request->ref_id;
        $amt = $cart_amt;
        $gtwy_currency = $request->currency;
        $order_id = $request->booking_id;
        $from = $request->from;


        $provider = new PayPalClient;
        $provider->setApiCredentials(config('paypal'));
        $paypalToken = $provider->getAccessToken();

        if (!isset($paypalToken['access_token'])) {
            Log::error(var_export($paypalToken));
            return redirect()
                ->route('frontend.home')
                ->withFlashDanger('Authentication error. Please check paypal configurations.');
        }

        if($from == "invoice_payment"){
                $response = $provider->createOrder([
                "intent" => "CAPTURE",
                "application_context" => [
                    "return_url" => route('frontend.invoice.payment.success'),
                    "cancel_url" => route('frontend.invoice.payment.cancel'),
                ],
                "purchase_units" => [
                    0 => [
                        "amount" => [
                            "currency_code" => $gtwy_currency,
                            "value" => $amt,
                        ],
                        "custom_id" => $order_id,
                    ]
                ]
                ]);
        }else{
                $response = $provider->createOrder([
                "intent" => "CAPTURE",
                "application_context" => [
                    "return_url" => route('frontend.paypal.return'),
                    "cancel_url" => route('frontend.paypal.cancel'),
                ],
                "purchase_units" => [
                    0 => [
                        "amount" => [
                            "currency_code" => $gtwy_currency,
                            "value" => $amt,
                        ],
                    ]
                ]
            ]);
        }
        

        if (isset($response['id']) && $response['id'] != null) {
            if($from == "invoice_payment"){
                //Add to payment trans table
                $trans = PaymentGatewayTrans::find($ref_id);
                $trans->gateway_trans_id = $response['id'];
                $trans->save();
            }else{
                //Add to payment trans table
                $trans = PaymentGatewayTrans::find($ref_id);
                $trans->gateway_trans_id = $response['id'];
                $trans->save();
                //Add to Orders table
                $orderData = Orders::find($order_id);
                $orderData->payment_id = $response['id'];
                $orderData->save();
            }

            // redirect to approve href
            foreach ($response['links'] as $links) {
                if ($links['rel'] == 'approve') {
                    return redirect()->away($links['href']);
                }
            }

            return redirect()
                ->route('frontend.home')
                ->withFlashDanger('Something went wrong.');
        } else {
            return redirect()
                ->route('frontend.home')
                ->withFlashDanger($response['message'] ?? 'Something went wrong.');
        }
    }

    /**
     * success transaction.
     *
     * @return \Illuminate\Http\Response
     */
    public function paymentReturn(Request $request)
    {
        \Log::debug("paymentReturn: token:" . $request['token']);
        $provider = new PayPalClient;
        $provider->setApiCredentials(config('paypal'));
        $provider->getAccessToken();
        \Log::debug("paymentReturn: capturepaymentorder");
        $response = $provider->capturePaymentOrder($request['token']);
        //\Log::debug("capture response:".var_export($response, true));
        
        if (isset($response['status']) && $response['status'] == 'COMPLETED') {
            Log::debug("Paypal payment success");
            if(isset($response['purchase_units'][0]['payments']['captures'][0]['custom_id'])){
                return redirect()->route("frontend.home")->withFlashSuccess("Thank You! Payment Received.");
            }
            return redirect()->route("frontend.home")->withFlashSuccess("Thank You! Order created. Please check 'My Orders' section for the details.");
        } else {
            Log::debug("Paypal error: " . $response['message']);
            return redirect()->route("frontend.home")->withFlashDanger($response['message'] ?? 'Something went wrong.');
        }
    }

    /**
     * cancel transaction.
     *
     * @return \Illuminate\Http\Response
     */
    public function paymentCancel(Request $request)
    {
        Log::debug("Paypal payment Canceled");
        return redirect()->route("frontend.home")->withFlashDanger("Oops! Payment Cancelled.");
    }



    public function webhook()
    {
        Log::debug("Paypal webhook start");

        //get the webhook payload
        $requestBody = file_get_contents('php://input');
        //check if webhook payload has data
        if ($requestBody) {
            //request body is set
            Log::debug("PAYPAL_WEBHOOK REQUEST: " . $requestBody);
        } else {
            //request body is not set
            Log::error("PAYPAL_WEBHOOK: Request body not set. exit!!!!");
            exit();
        }

        //Receive HTTP headers that you received from PayPal webhook.
        $headers = getallheaders();
        //need header keys to be UPPERCASE
        $headers = array_change_key_case($headers, CASE_UPPER);

        Log::debug("PAYPAL_WEBHOOK: Verify sig");
        //if any of the relevant paypal signature headers are not set exit()
        if (
            (!array_key_exists('PAYPAL-AUTH-ALGO', $headers)) ||
            (!array_key_exists('PAYPAL-TRANSMISSION-ID', $headers)) ||
            (!array_key_exists('PAYPAL-CERT-URL', $headers)) ||
            (!array_key_exists('PAYPAL-TRANSMISSION-SIG', $headers)) ||
            (!array_key_exists('PAYPAL-TRANSMISSION-TIME', $headers))
        ) {
            Log::error("PAYPAL_WEBHOOK: Missing headers. exit!!!!");
            exit();
        }
        Log::debug("PAYPAL_WEBHOOK: Verify webhook signature start");

        $mode = config('paypal.mode');

        $response = Http::withHeaders([
            'Accept' => 'application/json',
            'Accept-Language' => 'en_US',
            'Content-Type' => 'application/x-www-form-urlencoded'
        ])->withBasicAuth(config('paypal.' . $mode . '.client_id'), config('paypal.' . $mode . '.client_secret'))
            ->post(config('paypal.' . $mode . '.api_url') . 'oauth2/token?grant_type=client_credentials');

        if ($response->successful()) {
            Log::debug("BODY IS:" . $response->body());
            $body_json = $response->json();
            $access_token = $body_json['access_token'];
            Log::debug("TOKEN IS:" . $access_token);

            Log::debug("Verify Webhook signature");
            $requestBodyDecode = json_decode($requestBody);
            $request_data = array(
                "transmission_id" => $headers['PAYPAL-TRANSMISSION-ID'],
                "transmission_time" => $headers['PAYPAL-TRANSMISSION-TIME'],
                "cert_url" => $headers['PAYPAL-CERT-URL'],
                "auth_algo" => $headers['PAYPAL-AUTH-ALGO'],
                "transmission_sig" => $headers['PAYPAL-TRANSMISSION-SIG'],
                "webhook_id" => config('paypal.' . $mode . '.webhook_id'),
                "webhook_event" => $requestBodyDecode
            );

            $response2 = Http::withHeaders([
                'Accept' => 'application/json',
                'Accept-Language' => 'en_US',
                'Authorization' => 'Bearer ' . $access_token
            ])->withBody(json_encode($request_data), 'application/json')
                ->post(config('paypal.' . $mode . '.api_url') . 'notifications/verify-webhook-signature');
            if ($response2->successful()) {
                Log::debug("BODY IS:" . $response2->body());
                $body_json2 = $response2->json();

                if ($body_json2['verification_status'] == "SUCCESS") {
                    Log::debug("PAYPAL_WEBHOOK: Sig OK.");

                    $eventType = $requestBodyDecode->event_type;
                    Log::debug("PAYPAL_WEBHOOK: event:" . $eventType);
                    if ($eventType == "CHECKOUT.ORDER.APPROVED") {

                        /*if (isset($requestBodyDecode->resource->billing_agreement_id)) {
                        //subscription
                        Log::debug("Using billing_agreement_id (subscription)");
                        $paymentSystemID = $requestBodyDecode->resource->billing_agreement_id;
                    } else {
                        //checkout
                        Log::debug("Using order id");
                        $paymentSystemID = $requestBodyDecode->resource->id;
                        $order_id = $requestBodyDecode->resource->reference_id;
                    }*/

                        $paymentSystemID = $requestBodyDecode->resource->id;

                        Log::debug("PAYPAL_WEBHOOK: transid:" . $paymentSystemID);
                        $pg_trans_row = DB::table('payment_gateway_trans')
                            ->where('gateway_trans_id', $paymentSystemID)
                            ->where('status', 'pending')
                            ->first();

                        if ($pg_trans_row) {
                            Log::debug("PAYPAL_WEBHOOK: pg trans info: " . var_export($pg_trans_row, true));
                            $paid_amt = $requestBodyDecode->resource->amount->total;
                            // if ($eventType == "PAYMENT.SALE.COMPLETED") {
                            //     $paid_amt = $requestBodyDecode->resource->amount->total;
                            //     $currency_paid = $requestBodyDecode->resource->amount->currency;
                            // } elseif ($eventType == "CHECKOUT.ORDER.APPROVED") {
                            //     $paid_amt = $requestBodyDecode->resource->purchase_units[0]->amount->value;
                            //     $currency_paid = $requestBodyDecode->resource->purchase_units[0]->amount->currency_code;
                            // }
                            // if (!$paid_amt >= $pg_trans_row->amount) {
                            //     Log::debug("PAYPAL_WEBHOOK: Error! Incorrect amount: $paid_amt");
                            //     exit();
                            // }
                            // if ($currency_paid != $pg_trans_row->currency) {
                            //     Log::debug("PAYPAL_WEBHOOK: Error! Incorrect currency: $currency_paid");
                            //     exit();
                            // }
                            Log::debug("PAYPAL_WEBHOOK: VALID PAYMENT!!!");
                            DB::table('payment_gateway_trans')
                                ->where('gateway_trans_id', $paymentSystemID)
                                ->update(['status' => 'paid', 'trans_detail' => date("Y-m-d H:i:s") . ": Webhook Received. " . $pg_trans_row->trans_detail]);

                            // $net_amt = round($paid_amt);
                            // $data = ['user_id' => $pg_trans_row->uid, 'amount' => $net_amt, 'charges' => $charges, 'currency' => $currency_paid, 'amount_base' => $net_amt, 'type' => $pg_trans_row->payment_type, 'ref_id' => $pg_trans_row->ref_id, 'pg_trans_id' => $pg_trans_row->payment_trans_id, 'gateway' => 'paypal', 'trans_detail' => '', 'notes' => ''];
                            //PaymentHelper::addPayment($data);
                        if($requestBodyDecode->resource->purchase_units[0]->custom_id){
                            $bookingId = $requestBodyDecode->resource->purchase_units[0]->custom_id;
                            Log::debug("Invoice_id:" . $bookingId);
                            Log::debug("PAYPAL_WEBHOOK Invoice payment status: paid");

                                    $record = new InvoicePayment([
                                        'invoice_id' => $bookingId,
                                        'amount' => $paid_amt,
                                        'payment_date' => now(),
                                        'pay_mode' => 'paypal',
                                        'trans_id' => $paymentSystemID,
                                        'staff_id' => 0
                                    ]);
                                    $record->save();

                                    $invoice = Invoice::find($bookingId);
                                    $total_payment = InvoicePayment::where('invoice_id', $bookingId)->sum('amount');
                                    if ($invoice->cart_total - $total_payment <= 0) {
                                        $invoice->status = "paid";
                                        $invoice->save();
                                    }
                        }else{
                            $order = Orders::where('payment_id', $paymentSystemID)->first();
                            $order->status = "paid";
                            $order->save();
                            Log::debug("Marking Order #".$order->id." as PAID");

                            $adsData = OrderItems::where('order_id', '=', $order->id)->get();
                            foreach ($adsData as $data) {
                                //Adding student to student_online_course table
                                if ($order->order_type == "online_course") {
                                    if (StudentOnlineCourse::where(['student_id' => $order->user_id, 'online_course_id' => $data->online_course_id])->exists()) {
                                        Log::debug('Paypal payment status :: Student already enrolled for this course!');
                                    } else {
                                        $enrollment = StudentOnlineCourse::create([
                                            'student_id' => $order->user_id,
                                            'online_course_id' => $data->online_course_id,
                                            'staff_id' => 0
                                        ]);
                                        Log::debug('Adding Student online course enrollment: Student:'. $order->user_id." Course:".$data->online_course_id);
                                    }
                                }
                            }
                            //Sending email to admin
                            $msg_details = "<p><b>New Order Placed</b></p><p> Order details: <a href='".route('admin.orders.view-order',$$order->id)."'>".$$order->id."</a>";
                            if ($msg_details) {
                                $email_message = "Dear Admin,<br><br>" . $msg_details;
                                $recipient = new AdminRecipient();
                                try{
                                  //$recipient->notify(new AdminAlert("New Order Placed", $email_message));
                                  user_notify($recipient, "New Order Placed", $email_message);
                                }catch (\Exception $e) {
                                    $message = $e->getMessage();
                                    \Log::debug("Mail Error: (New Order Placed) ".$message);   
                                }
                            }
                        }

                        } else {
                            Log::error("PAYPAL_WEBHOOK: Error! pg trans row not found in db");
                        }
                    }
                } else {
                    Log::error("Webhook signature verification failed");
                }
            } else {
                $response2->throw();
            }
        } else {
            $response->throw();
        }
    }
}
