<?php
namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Auth\User;
use App\Models\Auth\PaymentGatewayTrans;
use App\Models\Auth\CurrencyRate;
use App\Models\Auth\OrderItems;
use App\Recipients\AdminRecipient;
use App\Models\Auth\Products;
use App\Models\Auth\Invoice;
use App\Models\Auth\InvoicePayment;
use App\Models\Auth\Shipping;
use App\Models\Auth\Course;
use App\Models\Auth\OnlineCourse;
use App\Models\Auth\StudentOnlineCourse;
use App\Models\Auth\Orders;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use App\Helpers\OrderHelper;
use Session;
use Stripe;
use Flash;
use Log;
use Response;
use Illuminate\Support\Facades\Mail;
use Razorpay\Api\Api;
use Redirect;

class RazorpayController extends Controller
{
    public function razorpay()
    {        
        return view('index');
    }

    public function payment(Request $request)
    {

        Log::debug("------RazorPay Payment Process Started------");
        $input = $request->all();        
        $api = new Api(env('RAZOR_KEY'), env('RAZOR_SECRET'));

        // $orderData = [
        //     'receipt'         => $PaymentGatewayTrans->id,
        //     'amount'          => $fee, // 39900 rupees in paise
        //     'currency'        => $request->currency
        // ];

        // $razorpayOrder = $api->order->create($orderData);
        // echo "<pre>";
        // print_r($razorpayOrder['id']);
        // echo "------------------";


        $payment = $api->payment->fetch($input['razorpay_payment_id']);

        if(count($input)  && !empty($input['razorpay_payment_id'])) 
        {
            try 
            {
                $response = $api->payment->fetch($input['razorpay_payment_id'])->capture(array('amount'=>$payment['amount']));
                $event_str = var_export($response, true);
                Log::debug("\n--------- FETCH DETAILS -----------\n" . $event_str . "\n--------------");
                if($response['status']=='captured'){
                Log::debug("RazorPay- Status: captured. ID:".$response['id']);
                $user_id = \Auth::user()->id;
                $re = $request->address_id;
                $users_det = User::where('id', '=', $user_id)->first();
//Invoice payment
        if ($request->product_type == "invoice") {
            Log::debug("RazorPay payment type: Invoice");
            $PaymentGatewayTrans = PaymentGatewayTrans::create([
                'user_id' =>  auth()->user()->id,
                'payer_email' =>  auth()->user()->email,
                'gateway'  => "razorpay",
                'currency' => $request->currency,
                'amount' => $request->total_amount,
                'status' => "pending",
                'gateway_trans_id' => $response['id'],
                'trans_detail' => "Invoice Payment"
            ]);
            Log::debug("RazorPay- Redirecting to success page");
            return redirect()->route("frontend.invoice.payment.success");
        }
//Invoice payment
            else{
                Log::debug("RazorPay payment type: Product Purchase");
                $cart_total = $request->cart_total;
                Log::debug("Cart Total is :" .$request->currency.$cart_total);

                $base = $request->total_amount / $request->currency_rate;
                $cart = session()->get('cart');
                $order = new Orders;
                $order->user_id = $user_id;
                $order->create_date = Carbon::now();
                $order->order_type = $request->product_type;
                $order->shipping_to = $request->shipping_to;
                $order->total = $request->total_amount;
                $order->total_base = $request->total_amount;
                $order->payment_type = "razorpay";
                $order->payment_id = $response['id'];
                $order->currency = $request->currency;
                $order->status = "pending";

                if ($order->save()) {
                  //Log::debug(DB::enableQueryLog());
                  $subtotal = 0;
                  $tax = 0;
                  $shipping = 0;

                  $admin_products = array();
                  $seller_products = array();
                  foreach (session('cart') as $key => $cartItem) {
                    if ($cartItem['type'] == 'physical' ||  $cartItem['type'] == 'digital') {
                      $product = Products::where('id', '=', $key)->first();
                      if ($product->offer_price != 0) {
                        $price =  $product->offer_price;
                      } else {
                        $price =  $product->price;
                      }
                    } else if ($cartItem['type'] == 'coaching') {
                      $product = Course::where('id', '=', $key)->first();
                      if ($product->offer_price != 0) {
                        $price =  $product->offer_price;
                      } else {
                        $price =  $product->fees;
                      }
                    } else if ($cartItem['type'] == 'online_course') {
                      $product = OnlineCourse::where('id', '=', $key)->first();
                      if ($product->offer_price != 0) {
                        $price =  $product->offer_price;
                      } else {
                        $price =  $product->fees;
                      }
                    }

                    $order_detail = new OrderItems;
                    $order_detail->order_id  = $order->id;
                    $order_detail->seller_id = $product->seller;
                    if ($cartItem['type'] == 'physical' ||  $cartItem['type'] == 'digital') {
                      $order_detail->product_id = $product->id;
                    } else if ($cartItem['type'] == 'coaching') {
                      $order_detail->coaching_id = $product->id;
                    } else if ($cartItem['type'] == 'online_course') {
                      $order_detail->online_course_id = $product->id;
                    }
                    $order_detail->qty = $cartItem['quantity'];
                    $order_detail->price = $price * $cartItem['quantity'];
                    $order_detail->price_base = $price * $cartItem['quantity'];
                    $order_detail->currency = $request->currency;
                    $order_detail->status = "pending";
                    $order_detail->details = $cartItem['details'];
                    $order_detail->shipping_cost = $cartItem['shipping'];
                    $order_detail->save();
                  }

                  $PaymentGatewayTrans = PaymentGatewayTrans::create([
                    'user_id' =>  auth()->user()->id,
                    'payer_email' =>  auth()->user()->email,
                    'gateway'  => "razorpay",
                    'currency' => $request->currency,
                    'amount' => $request->total_amount,
                    'status' => "pending",
                    'gateway_trans_id' => $response['id'],
                    'trans_detail' => "Product Purchase"
                  ]);
                  
                  session()->forget('cart');
                  Log::debug("RazorPay- Redirecting to success page");
                  return redirect()->route("frontend.payment.success");
                }
            }
                
            }else{
                Log::debug("RazorPay- Redirecting to failed page");
                return redirect()->route("frontend.payment.cancel");
            }
        } 
        catch (\Exception $e) 
            {
                return  $e->getMessage();
                \Session::put('error',$e->getMessage());
                return redirect()->back();
            }            
        }
        Log::debug("------RazorPay Payment Process Ended------");
    }



    function webhook() {
        Log::debug("---------------------webhook Start ------------");
        $post = file_get_contents('php://input');
        $data = json_decode($post, true);

        if (json_last_error() !== 0) {
            Log::debug("Post data json parse error");
            exit();
        }

        Log::debug("Validate signature");

        $api = new Api(env('RAZOR_KEY'), env('RAZOR_SECRET'));;

        try {
            $api->utility->verifyWebhookSignature($post, $_SERVER['HTTP_X_RAZORPAY_SIGNATURE'], env('RAZOR_WEBHOOK_SECRET'));
        } catch (\Razorpay\Api\Errors\SignatureVerificationError $e) {
            Log::debug("Razorpay Signature error: " . $e->getMessage());
            exit();
        }

        Log::debug("Process Event");
        Log::debug("Webhook Event: ".$data['event']);
        if ($data['event'] == 'payment.captured') {
            Log::debug("Event is: payment.authorized");

            //verify if we need to consume it as late authorized 
            $max_capture_delay = 10 * 60; //10min
            $payment_created_time = $data['payload']['payment']['entity']['created_at'];

            if ((time() - $payment_created_time) > $max_capture_delay) {
                Log::debug("Event delayed, ignoring event");
                exit();
            }

            $payment_entity = $data['payload']['payment']['entity'];
            $from = $payment_entity['notes']['from'];
            $bookingId = $payment_entity['notes']['bookingid'];
            $razorpay_payment_id = $payment_entity['id'];
            $amt_paid = $payment_entity['amount']/100;

            Log::debug("Payment Gateway Ref no:" . $razorpay_payment_id);
            $event_str = var_export($data['payload']['payment']['entity'], true);
            Log::debug("\n--------- EVENT DETAILS -----------\n" . $event_str . "\n--------------");
            if (!$razorpay_payment_id) {
                Log::debug("ERROR: No Payment Ref no.");
                exit();
            }

            if($from=='invoice_payment'){
                Log::debug("Invoice_id:" . $bookingId);
                Log::debug("Razorpay webhook Invoice payment status: paid");

                $record = new InvoicePayment([
                    'invoice_id' => $bookingId,
                    'amount' => $amt_paid,
                    'payment_date' => now(),
                    'pay_mode' => 'razorpay',
                    'trans_id' => $razorpay_payment_id,
                    'staff_id' => 0
                ]);
                $record->save();

        $invoice = Invoice::find($bookingId);
        $total_payment = InvoicePayment::where('invoice_id', $bookingId)->sum('amount');
        if ($invoice->cart_total - $total_payment <= 0) {
          $invoice->status = "paid";
          $invoice->save();
        }
      } else {
        $order = Orders::where('payment_id', $razorpay_payment_id)->first();
        $order->status = "paid";
        $order->save();
        OrderHelper::paid($order->id);
        Log::debug("Razorpay webhook Order payment status: paid. Amount:" . $amt_paid . " for payment_id: " . $razorpay_payment_id);
      }
      DB::enableQueryLog();
      Log::debug("Razorpay Webhook status: payment.authorized.completed");
      PaymentGatewayTrans::where('gateway_trans_id', $razorpay_payment_id)->update(['status' => "paid"]);
      Log::debug(DB::getQueryLog());
      Log::debug("------RazorPay Webhook Ended------");
    } elseif ($data['event'] == 'payment.failed') {
      Log::debug("Event is: payment.failed");

            $payment_entity = $data['payload']['payment']['entity'];
            $txn_id = $payment_entity['notes']['txn_id'];
            $razorpay_payment_id = $payment_entity['id'];

            Log::debug("Payment Gateway Ref no:" . $razorpay_payment_id);

            $event_str = var_export($data['payload']['payment']['entity'], true);
            Log::debug("\n--------- EVENT DETAILS -----------\n" . $event_str . "\n--------------");

            if (!$razorpay_payment_id) {
                Log::debug("ERROR: No Ref no.");
                exit();
            }
        } else {
            Log::debug("Ignoring this Event. ".$data['event']);
            exit();
        }
    }


}