<?php

namespace App\Http\Controllers;
use App\Models\StaffAditionalDocument;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;

class StaffAditionalDocumentController extends Controller
{

    public function updateStaffAdditionalDoc(Request $request)
    {

     $staff_id = $request->staff_id;
    
        if (StaffAditionalDocument::where('staff_id', $staff_id)->count() >=6) {
            return back()->with('error', 'You can only upload up to 5 documents.');
        }
    
        $request->validate([
            'document_title' => 'required|string|max:191',
            'document_file' => 'required|file|mimes:jpg,jpeg,png,pdf|max:' . (config('app.staff_doc_max_size') * 1024)], [
    'document_file.max' => 'The document file may not be greater than ' . config('app.staff_doc_max_size') . ' MB.',
]);
    
        if ($request->hasFile('document_file')) {
            $file = $request->file('document_file');
            $originalFileName = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $extension = strtolower($file->getClientOriginalExtension()); 
    
            $filename = Str::slug($originalFileName) . '.' . $extension; 
            $filepath = $file->storeAs('/staff_doc', $filename, 'public');
    
            // Store in database (without deleting old records)
            StaffAditionalDocument::create([
                'staff_id' => $staff_id,
                'document_title' => $request->input('document_title'),
                'document_path' => $filepath,
            ]);
    
            return back()->withFlashSuccess( 'Document uploaded successfully.');
        }
    
        return back()->withFlashDanger( 'File upload failed.');
    }
    
    //delete the document 
    public function deleteadditionalDoc(Request $request, $id , $staff_id)
    {
     
        // Find document by ID
        $doc_details = StaffAditionalDocument::where('id', $id)->where('staff_id',$staff_id)->first();

        if ($doc_details) {
            // Check if file exists before deleting
            if (!empty($doc_details->document_path) && Storage::disk('public')->exists($doc_details->document_path)) {
                Storage::disk('public')->delete($doc_details->document_path);
            }

            // Delete the document record from the database
            $doc_details->delete();

            return redirect()->back()->withFlashSuccess('Document deleted successfully');
        }

        return redirect()->back()->withFlashDanger('Document not found.');
    }

    //download 
    public function downloadDocument($id)
    {
        $document = StaffAditionalDocument::findOrFail($id);
        $path = storage_path("app/public/" . $document->document_path);
    
        if (!file_exists($path)) {
            return back()->withFlashDanger('error', 'File not found.');
        }
    
        return response()->download($path);
    }
    
}
