<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\StaffDependentDetails;

class StaffDependentDetailsController extends Controller
{
    public function create(Request $request)
    {
        $staffId = $request->staff_id;
    
        return view('backend.auth.user.detailed_profile_modal.add_staff_dependent_detail_modal' , compact('staffId'));
    }

    //  Store a new work experience in the database
    public function dependentdetailstore(Request $request)
    {
        // Debugging: Print validation errors
        $request->validate([
            'staff_id' => 'required|exists:staff_details,staff_id',
            'dep_name' => 'required|string|max:191',
            'relationship' => 'required|string|max:191',
            'date_of_birth' => 'nullable|string',
           
        ]);
    
        $dependent_details = new StaffDependentDetails();
        $dependent_details->staff_id=$request->staff_id;
        $dependent_details->dep_name = $request->dep_name ;
        $dependent_details->relationship = $request->relationship;
        $dependent_details->date_of_birth = $request->date_of_birth 
        ? \Carbon\Carbon::createFromFormat('d-m-Y', $request->date_of_birth)->format('Y-m-d'):null;
        $dependent_details->save();

        return redirect()->back()
            ->with('success', 'Work experience added successfully.');
    }

    public function loadDependentEditModal(Request $request)
    {
       
        $dependent_id = $request->query('id');
        $dependent_details = StaffDependentDetails::where('id' , $dependent_id)->first();

        return view('backend.auth.user.detailed_profile_modal.edit_staff_dependent_detail_modal' , [
            'dependent_details' =>  $dependent_details
        ]);
    }
    
    public function updatedependentinfo(Request $request)
    {
    
         $request->validate([
            'dep_name' => 'required|string|max:191',
            'relationship' => 'required|string|max:191',
           
        ]);
    
        $dependent_details = StaffDependentDetails::find($request->dependent_id);
        if (!$dependent_details) {
            return redirect()->back()->withErrors(['error' => 'Dependent record not found!']);
        }
        $dependent_details->dep_name = $request->dep_name ;
        $dependent_details->relationship = $request->relationship;
       $dependent_details->date_of_birth = $request->date_of_birth
        ? \Carbon\Carbon::parse($request->date_of_birth)->format('Y-m-d')
        : null;

        $dependent_details->save();
        // Redirect with success message
        return redirect()->back()
            ->with('success', 'Dependent details updated successfully!');

    }
     //  Delete a work experience
     public function destroy( Request $request , $dependent_id)
     {
        $dependent_details = StaffDependentDetails::find($dependent_id);
     
         if (!$dependent_details) {
             return redirect()->back()->with('error', 'Work experience not found.');
         }
     
         $dependent_details->delete();
     
         return redirect()->back()
         ->with('success', 'Dependent deleted successfully.');
     }
 
}
