<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\StaffEduDetails;

class StaffEduDetailsController extends Controller
{
  
    public function create(Request $request)
    {
        $staffId = $request->staff_id;
        return view('backend.auth.user.detailed_profile_modal.add_staff_education_detail_modal', compact('staffId'));
    }


   
    public function staffeducationdetailstore(Request $request)
{


        $request->validate([
            'staff_id' => 'required|integer',
            'institute_name' => 'required|string|max:255',
            'degree' => 'required|string',
            'course_specialization' => 'required|string',
        ]);

        $education = new StaffEduDetails();
        $education->staff_id = $request->staff_id;
        $education->degree = $request->degree;
        $education->institute_name = $request->institute_name;
        $education->course_specialization = $request->course_specialization;
        $education->completion_date =$request->completion_date ? \Carbon\Carbon::createFromFormat('d-m-Y', $request->completion_date)->format('Y-m-d'): null;
        $education->save();

        
        return redirect()->back()
            ->withFlashSuccess(__('strings.frontend.user.profile_updated'));
    

}


public function loadEducationEditModal(Request $request)
{
    
    $edu_id = $request->query('id');
    $education = StaffEduDetails::where('id', $edu_id)->first();

    return view('backend.auth.user.detailed_profile_modal.edit_staff_education_detail_modal' , [
        'education' => $education
    ]);
}



public function updatestaffeducationinfo(Request $request)
{
  
        $request->validate([
            'education_id' => 'required|integer',  // Ensure education_id is provided
            'institute_name' => 'required|string|max:255',
            'degree' => 'required|string',
            'course_specialization' => 'required|string',
        ]);

        // Find the existing education record by ID
        $education = StaffEduDetails::find($request->education_id);

        // If no record found, return an error response
        if (!$education) {
            return redirect()->back()->withErrors(['error' => 'Education record not found!']);
        }

        // Update fields
        $education->degree = $request->degree;
        $education->institute_name = $request->institute_name;
        $education->course_specialization = $request->course_specialization;
        $education->completion_date =$request->completion_date ?   \Carbon\Carbon::parse($request->completion_date)->format('Y-m-d') : null;
        $education->save();

        // Redirect with success message
        return redirect()->back()
        ->withFlashSuccess(__('strings.frontend.user.profile_updated'));
   
}

    public function deleteEducationInfo( Request $request ,$education_id)
    {
        $edu_details = StaffEduDetails::find($request->education_id);
        $edu_details->delete();
        return redirect()->back()
        ->with('success', 'Work experience deleted successfully.');
    
    }


}