<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\StaffWorkExp; // Import Model





class StaffWorkExpController extends Controller

{
    

    // Show the form to add a new work experience
    public function create(Request $request)
    {
        $staffId = $request->staff_id;
        return view('backend.auth.user.detailed_profile_modal.add_staff_work_exp_detail_modal', compact('staffId'));
    }

    //  Store a new work experience in the database
    public function workexpstore(Request $request)
    {
       
       $request->validate([
            'staff_id' => 'required|exists:staff_details,staff_id',
            'company_name' => 'required|string|max:191',
            'job_title' => 'required|string|max:191',
            'job_descp' => 'nullable|string',
            'relevant' => 'nullable|string|max:191',
        ]);
    
      $workExpdetails= new  StaffWorkExp();
      $workExpdetails->staff_id = $request->staff_id;
      $workExpdetails->company_name = $request->company_name;
      $workExpdetails->job_title = $request->job_title;
      $workExpdetails->job_descp = $request->job_descp;
      $workExpdetails->from_date = $request->from_date ? \Carbon\Carbon::createFromFormat('d-m-Y' , $request->from_date )->format('Y-m-d'):null;
      $workExpdetails->to_date = $request->to_date ? \Carbon\Carbon::createFromFormat('d-m-Y' , $request->to_date)->format('Y-m-d'):null;
      $workExpdetails->relevant = $request->relevant;

      $workExpdetails->save();
      return redirect()->back()
      ->withFlashSuccess(__('strings.frontend.user.profile_updated'));
    }
    
 
    // load modal before edit
    public function workexpedit(Request $request)
    {
       $work_exp_id = $request->query('id');
       $workExpDet= StaffWorkExp::where('id' , $work_exp_id)->first();
   
        return view('backend.auth.user.detailed_profile_modal.edit_staff_exp_detail_modal', [
            'workExpDet' => $workExpDet
        ]);
        
    }

    public function updatestaffworkexpinfo(Request $request)
{
    // Validate input
    $request->validate([
        'company_name' => 'required|string|max:191',
        'job_title'    => 'required|string|max:191',
        'job_descp'    => 'nullable|string',
        'relevant'     => 'nullable|string|max:191',
    ]);

    // Retrieve and update the record
    $workExpdetails = StaffWorkExp::find($request->workexp_id);
      $workExpdetails->company_name = $request->company_name;
      $workExpdetails->job_title = $request->job_title;
      $workExpdetails->job_descp = $request->job_descp;
         $workExpdetails->from_date = $request->from_date ? \Carbon\Carbon::createFromFormat('d-m-Y' , $request->from_date )->format('Y-m-d'):null;
      $workExpdetails->to_date = $request->to_date ? \Carbon\Carbon::createFromFormat('d-m-Y' , $request->to_date)->format('Y-m-d'):null;
    //   $workExpdetails->from_date = $request->from_date ? \Carbon\Carbon::parse($request->from_date)->format('Y-m-d'):null;
    //   $workExpdetails->to_date = $request->to_date ? \Carbon\Carbon::parse($request->to_date)->format('Y-m-d'):null;
      $workExpdetails->relevant = $request->relevant;

      $workExpdetails->save();

      return redirect()->back()
      ->withFlashSuccess(__('strings.frontend.user.profile_updated'));
}  

    //  Delete a work experience
    public function destroy( Request $request , $workexp_id)
    {
        $workExp = StaffWorkExp::find($workexp_id);
    
        if (!$workExp) {
            return redirect()->back()->with('error', 'Work experience not found.');
        }
    
        $workExp->delete();
        return redirect()->back()
    ->with('success', 'Work experience deleted successfully.');

    }
    

}

