<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Auth\User;
use App\Models\Auth\PaymentGatewayTrans;
use App\Models\Auth\CurrencyRate;
use App\Models\Auth\OrderItems;
use App\Recipients\AdminRecipient;
use App\Models\Auth\Products;
use App\Notifications\Frontend\AdminAlert;
use App\Models\Auth\Invoice;
use App\Models\Auth\InvoicePayment;
use App\Models\Auth\StudentOnlineCourse;
use App\Models\Auth\Orders;
use App\Helpers\OrderHelper;
use Illuminate\Support\Carbon;
use Session;
use Stripe;
use Flash;
use Log;
use Response;
use Illuminate\Support\Facades\Mail;

class StripeController extends Controller
{

    public function invoice()
    {
        return view("vendor.mail.html.invoice");
    }

    public function stripe(Request $request)
    {

        Stripe\Stripe::setApiKey(env('STRIPE_SECRET'));

        $cart_amt = $request->fee;
        $ref_id = $request->ref_id;
        $amt = $cart_amt;
        $gtwy_currency = $request->currency;

        //todo: must handle products & membership seperately. so that every time new product is not created. use existing product only
        $stripe = new Stripe\StripeClient(env('STRIPE_SECRET'));
        $product_id = $stripe->products->create([
            'name' => $request->itemname,
        ]);

        /*if (!$product_id) {
        $this->debug_log_ipn("ERROR: Unable to create product. Item: $itemname Amt: $amt, Ref: $ref_id");
        die("Error occured");
        }*/

        if ($request->from == "product_purchase") {
            $session = Stripe\Checkout\Session::create([
                //'payment_method_types' => ['card'],
                'line_items' => [[
                    'price_data' => [
                        'currency' => $gtwy_currency,
                        'product' => $product_id,
                        'unit_amount' => $amt,
                    ],
                    'quantity' => 1,
                ]],
                'payment_intent_data' => [
                    'metadata' => [
                        "user_id" => $request->user_id,
                        "booking_id" => $request->booking_id,
                        'from' => "product_purchase"
                    ],
                ],
                'customer_email' => $request->email,
                'mode' => $request->mode,
                'client_reference_id' => $ref_id,
                'success_url' => route("frontend.payment.success"),
                'cancel_url' => route("frontend.payment.cancel"),
            ]);
            Log::debug("Stripe Product Purchase:" . $session);
        }
        if ($request->from == "invoice_payment") {
            $session = Stripe\Checkout\Session::create([
                //'payment_method_types' => ['card'],
                'line_items' => [[
                    'price_data' => [
                        'currency' => $gtwy_currency,
                        'product' => $product_id,
                        'unit_amount' => $amt,
                    ],
                    'quantity' => 1,
                ]],
                'payment_intent_data' => [
                    'metadata' => [
                        "user_id" => $request->user_id,
                        "booking_id" => $request->booking_id,
                        'from' => "invoice_payment"
                    ],
                ],
                'customer_email' => $request->email,
                'mode' => $request->mode,
                'client_reference_id' => $ref_id,
                'success_url' => route("frontend.invoice.payment.success"),
                'cancel_url' => route("frontend.invoice.payment.cancel"),
            ]);
            Log::debug("Stripe Invoice Payment:" . $session);
        }


        //$this->debug_log_ipn("Redirecting to stripe...");

        echo "<html>";
        echo "<head><title>Redirecting to Payment Gateway</title></head>";
        echo '<script src="https://js.stripe.com/v3/"></script>';
        echo '<script type="text/javascript">'
            . 'function doredirect() {'
            . 'var stripe = Stripe(\'' . env('STRIPE_KEY') . '\');'
            . 'stripe.redirectToCheckout({'
            . ' sessionId: \'' . $session->id . '\''
            . '}).then(function (result) {'
            . '});'
            . '}'
            . '</script>';
        echo "<body onLoad=\"javascript:doredirect()\">";
        echo "<center>Please wait… You are being redirected to Stripe website</center>";
        echo "</body></html>";
        die;
    }


    public function webhook(Request $request, Response $response)
    {

        Log::debug("STRIPE_WEBHOOK: Start");        
        Stripe\Stripe::setApiKey(env('STRIPE_SECRET'));

        $payload = @file_get_contents('php://input');
        $event = null;

        $webhookSecret = env('STRIPE_WEBHOOK_SECRET');
        if ($webhookSecret) {
            try {

                $event = \Stripe\Event::constructFrom(
                    json_decode($payload, true)
                );
                Log::debug("STRIPE_WEBHOOK: Payload: " . $payload);
            } catch (\Exception $e) {
                http_response_code(400);
                Log::debug("STRIPE_WEBHOOK: http_response_code(400)");
                exit();
            }
        }
        Log::debug("STRIPE_WEBHOOK: get event data");
        $payment_id = $event->data->object->id;
        $from = $event->data->object->metadata->from;
        $bookingId = $event->data->object->metadata->booking_id;
        $mem_exp = $event->data->object->metadata->expiry_date;
        $user_id = $event->data->object->metadata->user_id;
        $ref_id = $event->data->object->client_reference_id;
        $billing_reason = $event->data->object->billing_reason;
        $amt_paid = $event->data->object->amount_paid;

        Log::debug("STRIPE_WEBHOOK from:" . $from);


        switch ($event->type) {
            case 'charge.succeeded':
                Log::debug("STRIPE_WEBHOOK status: charge succeeded");
                if ($from == "product_purchase") {
                    Log::debug("ORder_id:" . $bookingId);

                    // Orders::where('id', '=', $bookingId)
                    //     ->update(['status' => "paid", 'payment_id' => $payment_id]);
                    Log::debug("STRIPE_WEBHOOK payment status: paid");

                    $order = Orders::find($bookingId);
                    $order->status = "paid";
                    $order->payment_id = $payment_id;
                    $order->save();

                    // $adsData = OrderItems::where('order_id', '=', $bookingId)->get();
                    // foreach ($adsData as $data) {

                    //     //Adding student to student_online_course table
                    //     if ($order->order_type == "online_course") {
                    //         if (StudentOnlineCourse::where(['student_id' => $order->user_id, 'online_course_id' => $data->online_course_id])->exists()) {
                    //             Log::debug('Stripe payment status :: Student already enrolled for this course!');
                    //         } else {
                    //             $enrollment = StudentOnlineCourse::create([
                    //                 'student_id' => $order->user_id,
                    //                 'online_course_id' => $data->online_course_id,
                    //                 'staff_id' => 0
                    //             ]);
                    //         }
                    //     }
                    // }
                    OrderHelper::paid($order->id);
                    
                    $msg_details = "<p><b>New Order Placed</b></p><p> Order details: <a href='".route('admin.orders.view-order',$bookingId)."'>".$bookingId."</a>";
                    if ($msg_details) {
                        $email_message = "Dear Admin,<br><br>" . $msg_details;
                        $recipient = new AdminRecipient();
                        try{
                          //$recipient->notify(new AdminAlert("New Order Placed", $email_message));
                          user_notify($recipient, "New Order Placed", $email_message);
                        }catch (\Exception $e) {
                            $message = $e->getMessage();
                            \Log::debug("Mail Error: (New Order Placed) ".$message);   
                        }
                    }

                    //Email
                    // $event_det = Notificationtemplates::where('event', '=', 'product_purchase')->first();
                    // if($event_det->email_enable){
                    //     $userData = User::find($user_id);
                    //     $orderData = $order_det = Orders::where('id','=',$bookingId)->first();

                    //     $currency = CurrencyRate::where('code','=',$orderData->currency)->first();
                    //     $items = OrderItems::where('order_id','=',$bookingId)->get();
                    //     $items_det = array();
                    //     $slr = "";
                    //     for ($i=0; $i <count($items); $i++) { 
                    //          $item_id = $items[$i]->product_id;
                    //           $items_det[] = Products::where('id','=',$item_id)->first();

                    //         //Seller mail
                    //             $sellerData = User::where('id', $items[$i]->seller_id)->first(['email']);
                    //             $seller_mail = $sellerData->email;
                    //             $recepient = $seller_mail;
                    //             // $orderData = Orders::join('order_items', 'order_items.order_id', '=', 'orders.id')
                    //             //     ->where('seller_id', $items[$i]->seller_id)
                    //             //     ->where('orders.id', $bookingId)
                    //             //     ->get();
                    //             $data = ['data'=>$items_det,'orderData'=>$orderData,'items'=>$items,'currency'=>$currency,'email'=>$recepient];
                    //             $user['to'] = $recepient;
                    //             $user['subject'] = "You have got a new Order";
                    //             if($recepient!= $slr){
                    //                 Mail::send('vendor.mail.html.seller-invoice',$data,function($messages) use ($user){
                    //                     $messages->to($user['to']);
                    //                     $messages->subject($user['subject']);
                    //                 });
                    //             }
                    //             $slr=$seller_mail;
                    //             //Seller mail
                    //         }

                    //     $name = $userData->first_name . ' ' . $userData->last_name;

                    //     $toid = $userData->email;

                    //     $data = ['data'=>$items_det,'orderData'=>$orderData,'items'=>$items,'currency'=>$currency,'buyer_name'=>$name,'email'=>$toid];
                    //     $user['to'] = $toid;
                    //     $user['subject'] = $event_det->email_subject." #".$orderData->order_num;
                    //     Mail::send('vendor.mail.html.invoice',$data,function($messages) use ($user){
                    //         $messages->to($user['to']);
                    //         $messages->subject($user['subject']);
                    //     });
                    //     Log::debug("Product purchase Mail::to:" . $toid);

                    // }
                }
                if ($from == "invoice_payment") {
                    Log::debug("Invoice_id:" . $bookingId);
                    Log::debug("STRIPE_WEBHOOK Invoice payment status: paid");

                            $record = new InvoicePayment([
                                'invoice_id' => $bookingId,
                                'amount' => $amt_paid,
                                'payment_date' => now(),
                                'pay_mode' => 'stripe',
                                'trans_id' => $payment_id,
                                'staff_id' => 0
                            ]);
                            $record->save();

                            $invoice = Invoice::find($bookingId);
                            $total_payment = InvoicePayment::where('invoice_id', $bookingId)->sum('amount');
                            if ($invoice->cart_total - $total_payment <= 0) {
                                $invoice->status = "paid";
                                $invoice->save();
                            }
                    
                }
                break;

            case 'checkout.session.completed':
                Log::debug("STRIPE_WEBHOOK status: checkout.session.completed");
                PaymentGatewayTrans::where('id', $ref_id)
                    ->update(['status' => "paid", 'gateway_trans_id' => $payment_id]);
                break;
            // ... handle other event types
            default:
                // Unhandled event type
        }

        http_response_code(200);
        //});

    }
}
