<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\Auth\Invoice;
use App\Models\Auth\InvoiceItems;
use App\Mail\MailSend;
use Illuminate\Support\Facades\Mail;
use App\Models\Auth\countries;

class UpgradeDataController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */

    public function __construct(){}

    public function updateOldInvoicesDataRequest() {
        
        $old_invoices = DB::table('invoice_old')->get();
        // Storing invoices in invoice and invoice_items table
        if(count($old_invoices)){
            foreach($old_invoices as $invoice){
                echo "Invoice ID". $invoice->id."<br>";
                $new_invoice = new Invoice;
                $new_invoice->id = $invoice->id;
                $new_invoice->invoice_num = $invoice->invoice_num;
                $new_invoice->student_id = $invoice->student_id;
                $new_invoice->batch_id = $invoice->batch_id;
                $new_invoice->currency = config('app.currency');
                $amt_with_tax = $tax1_rate = $tax2_rate = 0;
                if($invoice->tax1_amount){
                    $amt_with_tax = $invoice->cart_total - $invoice->discount;
                    $amt_with_tax -= $invoice->tax1_amount;
                    $tax1_rate = ($invoice->tax1_amount / $amt_with_tax) * 100;
                    $new_invoice->tax1_name = $invoice->tax1_name;
                    $new_invoice->tax1_rate = $tax1_rate;
                    $new_invoice->tax1_value = $invoice->tax1_amount;
                    $new_invoice->tax1_value_base = $invoice->tax1_amount;
                }
                if($invoice->tax2_amount){
                    $amt_with_tax = $invoice->cart_total - $invoice->discount;
                    $amt_with_tax -= $invoice->tax2_amount;
                    $tax2_rate = ($invoice->tax2_amount / $amt_with_tax) * 100;
                    $new_invoice->tax2_name = $invoice->tax2_name;
                    $new_invoice->tax2_rate = $tax2_rate;
                    $new_invoice->tax2_value = $invoice->tax2_amount;
                    $new_invoice->tax2_value_base = $invoice->tax2_amount;
                }
                $new_invoice->total_tax = $invoice->tax1_amount + $invoice->tax2_amount;
                $new_invoice->total_tax_base = $invoice->tax1_amount + $invoice->tax2_amount;
                $new_invoice->tax_type = "exclusive";
                $new_invoice->sub_total = $invoice->sub_total;
                $new_invoice->sub_total_base = $invoice->sub_total;
                $new_invoice->discount = $invoice->discount;
                $new_invoice->discount_base = $invoice->discount;
                $new_invoice->grand_total = $invoice->cart_total;
                $new_invoice->grand_total_base = $invoice->cart_total;
                $new_invoice->due_date = $invoice->due_date;
                $new_invoice->status = $invoice->status;
                $new_invoice->terms = $invoice->terms;
                $new_invoice->terms_conditions = $invoice->terms_conditions;
                $new_invoice->created_at = $invoice->created_at;
                $new_invoice->updated_at = $invoice->updated_at;
                $new_invoice->save();
                for($i = 1; $i <= 21; $i++){
                    ${"item$i"} = "";
                    ${"item$i"."_amount"} = "";
                    ${"item$i"."_amount"} = "";
                    if(isset($invoice->{"item$i"}) && !empty($invoice->{"item$i"})){
                        $new_invoice_item = new InvoiceItems;
                        $new_invoice_item->invoice_id = $invoice->id;
                        $new_invoice_item->currency = config('app.currency');
                        $new_invoice_item->item = $invoice->{"item$i"};
                        $new_invoice_item->item_amount = $invoice->{"item$i"."_amount"};
                        $new_invoice_item->item_amount_base = $invoice->{"item$i"."_amount"};
                        $new_invoice_item->save();
                    }
                }
            }
            echo "All Invoices are Updated!!";
        } else{
            echo "Old Invoices Data is Empty!!";
        }

    }
}
