<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\Auth\User;
use App\Models\Auth\UserDetails;
use Log;

/**
 * Class WatiWebhookController.
 */
class WatiWebhookController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */

    public function __construct()
    {
    }

    private function splitFullMobile($full_mob) {
        $MOB_LENGTH = 10;
        $ret[0] = "";//dialcode
        $ret[1] = "";//mobile
        if(strlen($full_mob) > $MOB_LENGTH) {
            $ret[0] = substr($full_mob, 0, strlen($full_mob) - $MOB_LENGTH);
            $ret[1] = substr($full_mob, strlen($full_mob) - $MOB_LENGTH);
        } else {
            $ret[1] = $full_mob;
        }
        return $ret;
    }

    public function index(Request $request) {
        Log::debug("WatiWebhookController REQUEST FROM: ".$_SERVER['REMOTE_ADDR'] ?? $_SERVER['REMOTE_ADDR']);
        //Log::debug($request->all());

        if($request->input('id') && $request->input('eventType') && $request->input('waId')) {
            if($request->input('eventType') == 'newContactMessageReceived') {
                Log::debug($request->all());                
                $request_id = $request->input('id');
                if(DB::table("wati_webhook_calls")->where('request_id', $request_id)->exists()) {
                    Log::debug("WatiWebhookController: Duplicate Request: $request_id");
                } else {

                    DB::table("wati_webhook_calls")->insert([
                        'request_id' => $request_id,
                        'details' => "Event Type: ".$request->input('eventType'),
                        'created_at' => date("Y-m-d H:i:s")
                    ]);

                    //Check if mobile already exists
                    if(DB::table('users')->whereRaw("concat(`dialcode`,`mobile`) = ?", [$request->input('waId')])->exists()) {
                        Log::debug("WatiWebhookController: Mobile already exists: ".$request->input('waId'));
                    } else {
                        Log::debug("WatiWebhookController: NEW LEAD: ".$request->input('waId'));
                        $mobile = $this->splitFullMobile($request->input('waId'));
                        $lead_status = get_default_lead_status();
                        $branch = 1;
                        $user = User::create([
                            'first_name' => preg_replace('/[^A-Za-z0-9\- ]/', '', $request->input('senderName')),
                            'dialcode' => $mobile[0],
                            'mobile' => $mobile[1],
                            'is_lead' => 1,
                            'lead_source' => 'WhatsApp',
                            'created_mode' => "api",
                            'branch' => $branch,
                            'lead_status' => $lead_status
                        ]);

                        UserDetails::create([
                            'userid' => $user->id,
                            'lead_source_detail' => 'Wati.io'
                        ]);

                        /*
                        if (get_site_config('whatsapp_enabled')) {
                            $numbers = [$mobile[0].$mobile[1]]; 

                            $hook = 'lead_welcome_web2lead';

                            send_whatsapp_message($numbers, $hook, $user->id);
                        }
                        */
                    }
                }
            }
        }
    }

}