<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\MailTemplates;
use App\Recipients\AdminRecipient;
use App\Models\Auth\User;
use App\Models\Auth\Lead;
use App\Repositories\Backend\Auth\UserRepository;
use App\Notifications\Backend\UserAlert;
use App\Notifications\Frontend\AdminAlert;
use App\Mail\MailSend;
use Illuminate\Support\Facades\Mail;
use App\Models\Auth\LeadActivity;
use App\Models\SMSTemplates;
use Illuminate\Validation\Rule;
use Log;

/**
 * Class WebtoleadController.
 */
class WebtoleadController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */

    public function __construct()
    {
    }

    public function webToLeadTracking(Request $request)
    {
        // $validator = \Validator::make($request->all(), [
        //     'wl_first_name' => 'required|max:50',
        //     'wl_last_name' => 'max:50',
        //     // 'wl_email' => 'required|email|unique:users,email',
        //     // 'wl_mobile' => 'max:11',
        //     'wl_city' => 'max:50',
        //     'wl_current_course' => 'max:100',
        //     'wl_course_interested' => 'max:100',
        // ],
        // [
        //     'wl_first_name.required' => 'The first name field is required.',
        //     'wl_first_name.max' => 'The first name may not be greater than 50 characters.',
        //     'wl_last_name.max' => 'The last name may not be greater than 50 characters.',
        //     'wl_email.required' => 'The email field is required.',
        //     'wl_email.email' => 'The email must be valid email address',
        //     'wl_email.unique' => 'The email has already been taken.',
        //     'wl_mobile.required' => 'The mobile field is required.',
        //     'wl_mobile.max' => 'The mobile number may not be greater than 11 characters.',
        //     'wl_mobile.digits_between' => 'The mobile number should be between '.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH'),
        //     'wl_city.max' => 'The city may not be greater than 50 characters.',
        //     'wl_current_course.max' => 'The Currently Studying Course may not be greater than 100 characters.',
        //     'wl_course_interested.max' => 'The Course Interested to Study may not be greater than 100 characters.',
        // ]);

        if(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email'){
            $validator =  \Validator::make($request->all(), [
                'wl_first_name' => 'required|max:50',
                'wl_last_name' => 'max:50',
                'wl_city' => 'max:50',
                'wl_current_course' => 'max:100',
                'wl_course_interested' => 'max:100',
                
                'wl_email' => 'required|email|unique:users,email',
                'wl_mobile' => ['nullable', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH'), 'unique:users,mobile']
            ],
            [
                'wl_first_name.required' => 'The first name field is required.',
                'wl_first_name.max' => 'The first name may not be greater than 50 characters.',
                'wl_last_name.max' => 'The last name may not be greater than 50 characters.',
                'wl_email.required' => 'The email field is required.',
                'wl_email.email' => 'The email must be valid email address',
                'wl_email.unique' => 'The email has already been taken.',
                'wl_mobile.unique' => 'The mobile number has already been taken.',
                'wl_mobile.required' => 'The mobile field is required.',
                'wl_mobile.max' => 'The mobile number may not be greater than 11 characters.',
                'wl_mobile.digits_between' => 'The mobile number should be between '.config('app.USER_MOBILE_MIN_LENGTH').' and '.config('app.USER_MOBILE_MAX_LENGTH').' digits.',
                'wl_city.max' => 'The city may not be greater than 50 characters.',
                'wl_current_course.max' => 'The Currently Studying Course may not be greater than 100 characters.',
                'wl_course_interested.max' => 'The Course Interested to Study may not be greater than 100 characters.',
            ]);
        } elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_and_mobile'){
            $validator =  \Validator::make($request->all(), [
                'wl_first_name' => 'required|max:50',
                'wl_last_name' => 'max:50',
                'wl_city' => 'max:50',
                'wl_current_course' => 'max:100',
                'wl_course_interested' => 'max:100',

                'wl_email' => 'required|email|unique:users,email',
                'wl_mobile' => ['required', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH'), 'unique:users,mobile']
            ],
            [
                'wl_first_name.required' => 'The first name field is required.',
                'wl_first_name.max' => 'The first name may not be greater than 50 characters.',
                'wl_last_name.max' => 'The last name may not be greater than 50 characters.',
                'wl_email.required' => 'The email field is required.',
                'wl_email.email' => 'The email must be valid email address',
                'wl_email.unique' => 'The email has already been taken.',
                'wl_mobile.unique' => 'The mobile number has already been taken.',
                'wl_mobile.required' => 'The mobile field is required.',
                'wl_mobile.max' => 'The mobile number may not be greater than 11 characters.',
                'wl_mobile.digits_between' => 'The mobile number should be between '.config('app.USER_MOBILE_MIN_LENGTH').' and '.config('app.USER_MOBILE_MAX_LENGTH').' digits.',
                'wl_city.max' => 'The city may not be greater than 50 characters.',
                'wl_current_course.max' => 'The Currently Studying Course may not be greater than 100 characters.',
                'wl_course_interested.max' => 'The Course Interested to Study may not be greater than 100 characters.',
            ]
            );
        } elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_or_mobile'){
            if($request->get('wl_email') == "" && $request->get('wl_mobile') == ""){
                return redirect()->route('frontend.web-lead-error-page')->withErrors('Email or Mobile is Required')->withInput();
            } else{
                $validator =  \Validator::make($request->all(), [
                    'wl_first_name' => 'required|max:50',
                    'wl_last_name' => 'max:50',
                    'wl_city' => 'max:50',
                    'wl_current_course' => 'max:100',
                    'wl_course_interested' => 'max:100',

                    'wl_email' => 'nullable|email|unique:users,email',
                    'wl_mobile' => ['nullable', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').'and '.config('app.USER_MOBILE_MAX_LENGTH'), 'unique:users,mobile']
                ],
                    [
                        'wl_first_name.required' => 'The first name field is required.',
                        'wl_first_name.max' => 'The first name may not be greater than 50 characters.',
                        'wl_last_name.max' => 'The last name may not be greater than 50 characters.',
                        'wl_email.required' => 'The email field is required.',
                        'wl_email.email' => 'The email must be valid email address',
                        'wl_email.unique' => 'The email has already been taken.',
                        'wl_mobile.unique' => 'The mobile number has already been taken.',
                        'wl_mobile.required' => 'The mobile field is required.',
                        'wl_mobile.max' => 'The mobile number may not be greater than 11 characters.',
                        'wl_mobile.digits_between' => 'The mobile number should be between '.config('app.USER_MOBILE_MIN_LENGTH').' and '.config('app.USER_MOBILE_MAX_LENGTH').' digits.',
                        'wl_city.max' => 'The city may not be greater than 50 characters.',
                        'wl_current_course.max' => 'The Currently Studying Course may not be greater than 100 characters.',
                        'wl_course_interested.max' => 'The Course Interested to Study may not be greater than 100 characters.',
                    ]
                );
            }
        } elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'mobile'){
            $validator =  \Validator::make($request->all(), [
                'wl_first_name' => 'required|max:50',
                'wl_last_name' => 'max:50',
                'wl_city' => 'max:50',
                'wl_current_course' => 'max:100',
                'wl_course_interested' => 'max:100',

                'wl_email' => 'nullable|email|unique:users,email',
                'wl_mobile' => ['required', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH'), 'unique:users,mobile']
            ],
                [
                    'wl_first_name.required' => 'The first name field is required.',
                    'wl_first_name.max' => 'The first name may not be greater than 50 characters.',
                    'wl_last_name.max' => 'The last name may not be greater than 50 characters.',
                    'wl_email.required' => 'The email field is required.',
                    'wl_email.email' => 'The email must be valid email address',
                    'wl_email.unique' => 'The email has already been taken.',
                    'wl_mobile.required' => 'The mobile field is required.',
                    'wl_mobile.unique' => 'The mobile number has already been taken.',
                    'wl_mobile.max' => 'The mobile number may not be greater than 11 characters.',
                    'wl_mobile.digits_between' => 'The mobile number should be between '.config('app.USER_MOBILE_MIN_LENGTH').' and '.config('app.USER_MOBILE_MAX_LENGTH').' digits.',
                    'wl_city.max' => 'The city may not be greater than 50 characters.',
                    'wl_current_course.max' => 'The Currently Studying Course may not be greater than 100 characters.',
                    'wl_course_interested.max' => 'The Course Interested to Study may not be greater than 100 characters.',
                ]);            
        }

        //Google Recaptcha Validation
        if(get_site_config('recaptcha_site_key')!="" && get_site_config('recaptcha_secret_key')!="" && get_site_config('web_to_lead_captcha')==1){
            $request->validate([
                'g-recaptcha-response' => 'required',
            ], [
                'g-recaptcha-response.required' => 'Please complete the reCAPTCHA verification.',
            ]);
        
            $response = \Http::asForm()->post('https://www.google.com/recaptcha/api/siteverify', [
                'secret' => env('GOOGLE_RECAPTCHA_SECRET'),
                'response' => $request->input('g-recaptcha-response'),
            ]);
        
            $responseBody = $response->json();
            if (!$responseBody['success']) {
                $errorCodes = $responseBody['error-codes'] ?? [];
                $errorMessage = 'reCAPTCHA validation failed.';
                if (in_array('timeout-or-duplicate', $errorCodes)) {
                    $errorMessage = 'The reCAPTCHA has timed out or is a duplicate. Please try again.';
                } elseif (in_array('invalid-input-response', $errorCodes)) {
                    $errorMessage = 'The reCAPTCHA response is invalid. Please try again.';
                }
                //return redirect()->route('frontend.web-lead-error-page')->withErrors($validator)->withInput();
                return back()->withErrors(['g-recaptcha-response' => $errorMessage])->withInput();
            }
        }
        //Google Recaptcha Validation

        if ($validator->fails()) {
            return redirect()->route('frontend.web-lead-error-page')->withErrors($validator)->withInput();
        }

        $client_ip = $_SERVER['REMOTE_ADDR'] ?? $_SERVER['REMOTE_ADDR'];
        \Log::debug("WEBTOLEAD DATA RECEIVED From: $client_ip WITH DATA: " . var_export($_POST, true));
        $web_lead_enabled = get_site_config('web_lead_enabled');
        $insert_qry = $insert__details_qry = $notes = $wl_first_name = $wl_last_name = $wl_email = $wl_mobile = $wl_city = $wl_gender = $wl_dialcode = $wl_alt_contact = $wl_country_of_citizenship = $wl_country_pref = $wl_dob = $wl_current_course = $wl_study_level = $wl_accommodation = $wl_study_permit = $wl_course_interested = $wl_staff = $wl_redirect_url = $wl_staff_branch= $wl_whatsapp_dialcode = $wl_whatsapp= $wl_intake= $wl_qualification= $wl_lead_passout_year = $wl_score = '';

        if ($web_lead_enabled == 1 && filter_var($request->input('wl_email'), FILTER_VALIDATE_EMAIL) && filter_var($request->input('wl_first_name'), FILTER_SANITIZE_STRING)) {
            $web_lead_redirect_url = get_site_config('web_lead_redirect_url');
            // $web_lead_assign_to = get_site_config('web_lead_assign_to');
            // $web_lead_first_name_enabled = get_site_config('web_lead_first_name_enabled');
            // $web_lead_last_name_enabled = get_site_config('web_lead_last_name_enabled');
            // $web_lead_email_enabled = get_site_config('web_lead_email_enabled');
            // $web_lead_mobile_enabled = get_site_config('web_lead_mobile_enabled');
            // $web_lead_city_enabled = get_site_config('web_lead_city_enabled');
            $web_lead_assign_to = $request->wl_staff;
            $wl_redirect_url = $request->wl_redirect_url;
            $web_lead_form_name = $request->wl_form_name;
            $web_lead_assign_to_branch = $request->wl_staff_branch;
            $lead_status = get_default_lead_status();

            // $insert_qry = "INSERT INTO leads SET assigned_to='{$web_lead_assign_to}',status='{$lead_status}', created_at='" . date('Y-m-d H:i:s') . "', lead_source='Website', ";
            $insert_qry = "INSERT INTO users SET assigned_to='{$web_lead_assign_to}',branch='{$web_lead_assign_to_branch}',lead_status='{$lead_status}', created_at='" . date('Y-m-d H:i:s') . "', lead_source='WebForm2Lead', is_lead='1',created_mode='web2lead',";
            $insert__details_qry = "INSERT INTO user_details SET lead_source_detail='{$web_lead_form_name}',created_at='" . date('Y-m-d H:i:s') . "', ";
            $data = $request->except(['_token', 'submit']);
            $params = $details_params = array();
            foreach ($data as $key => $value) {
                if ($key == 'wl_first_name' && $wl_first_name == '') {
                    $wl_first_name = $value; //$request->input('wl_first_name');
                    $insert_qry .= " first_name =? ,";
                    $params[] = $wl_first_name;
                    $refcode = generate_refcode($wl_first_name);
                    $insert_qry .= " refcode =? ,";
                    $params[] = $refcode;
                } else if ($key == 'wl_last_name' && $wl_last_name == '') {
                    $wl_last_name = $value; //$request->input('wl_last_name');
                    $insert_qry .= " last_name =? ,";
                    $params[] = $wl_last_name;
                } else if ($key == 'wl_email' && $wl_email == '') {
                    $wl_email = $value; //$request->input('wl_email');
                    $insert_qry .= " email =? ,";
                    $params[] = $wl_email;
                } else if ($key == 'wl_mobile' && $wl_mobile == '') {
                    $wl_mobile = $value; //$request->input('wl_mobile');
                    $insert_qry .= " mobile =? ,";
                    $params[] = $wl_mobile;
                } else if ($key == 'wl_city' && $wl_city == '') {
                    $wl_city = $value; //$request->input('wl_city');
                    //$insert_qry .= " address =? ,";
                    $insert_qry .= " address_1 =? ,";
                    $params[] = $wl_city;
                }

                //Added newly added fields
                else if ($key == 'wl_gender' && $wl_gender == '') {
                    if($value){
                        $wl_gender = $value;
                    }else{
                         $wl_gender = "male";
                    }
                    $insert_qry .= " gender =? ,";
                    $params[] = $wl_gender;
                } else if ($key == 'wl_dialcode' && $wl_dialcode == '') {
                    $wl_dialcode = $value;
                    $insert_qry .= " dialcode =? ,";
                    $params[] = $wl_dialcode;
                }
                else if ($key == 'wl_whatsapp_dialcode' && $wl_whatsapp_dialcode == '') {
                    $wl_whatsapp_dialcode = $value;
                    $insert_qry .= " whatsapp_dialcode =? ,";
                    $params[] = $wl_whatsapp_dialcode;
                }
                else if ($key == 'wl_whatsapp' && $wl_whatsapp == '') {
                    $wl_whatsapp = $value;
                    $insert_qry .= " whatsapp =? ,";
                    $params[] = $wl_whatsapp;
                }
                 else if ($key == 'wl_alt_contact' && $wl_alt_contact == '') {
                    $wl_alt_contact = $value;
                    $insert_qry .= " alternate_contact =? ,";
                    $params[] = $wl_alt_contact;
                } else if ($key == 'wl_country_of_citizenship' && $wl_country_of_citizenship == '') {
                    $wl_country_of_citizenship = $value;
                    if($wl_country_of_citizenship !=""){
                        $insert_qry .= " country =? ,";
                        $params[] = $wl_country_of_citizenship;
                    }else{
                        $insert_qry .= " country =? ,";
                        $params[] = config('app.USER_DEFAULT_COUNTRY');
                    }
                } else if ($key == 'wl_country_pref' && $wl_country_pref == '') {
                    $wl_country_pref = $value;
                    $insert_qry .= " country_interested =? ,";
                    $params[] = $wl_country_pref;
                } else if ($key == 'wl_dob' && $wl_dob == '') {
                    $wl_dob = $value;
                    $insert_qry .= " birthday =? ,";
                    // $insert_qry .= " date_of_birth =? ,";
                    $params[] = $wl_dob;
                } else if ($key == 'wl_current_course' && $wl_current_course == '') {
                    $wl_current_course = $value;
                    $insert__details_qry .= " current_course =? ,";
                    $details_params[] = $wl_current_course;
                } else if ($key == 'wl_study_level' && $wl_study_level == '') {
                    $wl_study_level = $value;
                    $insert_qry .= " overseas_study_level =? ,";
                    $params[] = $wl_study_level;
                } else if ($key == 'wl_course_interested' && $wl_course_interested == '') {
                    $wl_course_interested = $value;
                    $insert_qry .= " overseas_course_intersted =? ,";
                    $params[] = $wl_course_interested;
                }
                else if ($key == 'wl_intake' && $wl_intake == '') {
                    if (!empty($value)) {
                        $wl_intake = $value;
                        $intatake_arr =  explode(" ", $wl_intake);
                    } else {
                        $intatake_arr = array(null, null);
                    }
                    $insert__details_qry .= " intake_year =? ,";
                    $details_params[] = $intatake_arr[1];
                    $insert__details_qry .= " intake_month =? ,";
                    $details_params[] = $intatake_arr[0];
                }
                else if ($key == 'wl_qualification' && $wl_qualification == '') {
                    $wl_qualification = $value;
                    $insert__details_qry .= " highest_level_education =? ,";
                    $details_params[] = $wl_qualification;
                }
                else if ($key == 'wl_lead_passout_year' && $wl_lead_passout_year == '') {
                    $wl_lead_passout_year = $value;
                    $insert__details_qry .= " passout_year =? ,";
                    $details_params[] = $wl_lead_passout_year;
                }
                else if ($key == 'wl_score' && $wl_score == '') {
                    $wl_score = $value;
                    $insert__details_qry .= " qualification_score =? ,";
                    $details_params[] = $wl_score;
                }
                 else if ($key == 'wl_accommodation' && $wl_accommodation == '') {
                    $wl_accommodation = $value;
                    $insert__details_qry .= " accommodation =? ,";
                    $details_params[] = $wl_accommodation;
                } else if ($key == 'wl_study_permit' && $wl_study_permit == '') {
                    $wl_study_permit = $value;
                    $insert__details_qry .= " study_permit =? ,";
                    $details_params[] = $wl_study_permit;
                }
                //Added newly added fields

                else if ($key != '' && $key != 'wl_staff' && $key != 'wl_redirect_url' && $key != 'wl_staff_branch' && $key != 'wl_form_name' && $value != '') {
                    $notes .= $key . ': ' . $value . '<br />';
                }
            }

            if ($notes != '') {
                $insert__details_qry .= " lead_notes =? ,";
                $details_params[] = $notes;
            }
            $insert_qry = rtrim($insert_qry, ', ');
            \Log::debug("WEBTOLEAD Query:" . $insert_qry);
            \Log::debug("WEBTOLEAD Params:" . implode(" , ", $params));
            DB::insert($insert_qry, $params);
            $leadid = DB::getPdo()->lastInsertId();

             //Checking custom attributes
                $custom_attributes = DB::table('custom_attributes')->where('web_to_lead', 1)->orderBy('display_order','asc')->get(["custom_attributes.*"]);
                $attributes_json = "";
                if(count($custom_attributes)){
                    $all_atts = array();
                    foreach($custom_attributes as $attrs){
                        $name = $attrs->attr_name;
                        $all_atts[$attrs->attr_name] = $request->$name;
                        if($attrs->laravel_rules){
                            $request->validate([
                                "$attrs->attr_name" => "$attrs->laravel_rules",
                            ]);
                        }
                    }
                    $attributes_json = json_encode($all_atts);
                }
                if ($attributes_json != '') {
                    $insert__details_qry .= " user_data_js =? ,";
                    $details_params[] = $attributes_json;
                }
            //Checking custom attributes

            //adding to details table
            if($leadid){
                $insert__details_qry .= " userid =? ,";
                $details_params[] = $leadid;
                $insert__details_qry = rtrim($insert__details_qry, ', ');
                \Log::debug("WEBTOLEAD Query:" . $insert__details_qry);
                \Log::debug("WEBTOLEAD Params:" . implode(" , ", $details_params));
                DB::insert($insert__details_qry, $details_params);
            }

            $lead = User::find($leadid);
            // $lead->assignRole('user');
            
            //Notify admin
            $msg_details = "New Web to Lead Form Submitted.<br /><br />Name: " . $wl_first_name . ' ' . $wl_last_name . "<br />email: " . $wl_email . "<br />Mobile: " . $wl_dialcode . ' ' . $wl_mobile . "<br />Gender: " . $wl_gender;
            //     if ($msg_details) {
            //         $email_message = "Dear Admin,<br><br>" . $msg_details;
            //         $recipient = new AdminRecipient();
            //         try{
            //           $recipient->notify(new AdminAlert("New Web to Lead", $email_message));
            //         }catch (\Exception $e) {
            //             $message = $e->getMessage();
            //             \Log::debug("Mail Error: (ADMIN MAIL - Web to Lead Generated) ".$message);   
            //         }
            // }

            $notify_emails = get_site_config('event_notification_email');
            if($notify_emails) {
                send_event_notification_email(explode(",", $notify_emails), "New Web to Lead", $msg_details);
            } 

            $leaddetails = User::find($leadid);

            //Email to lead
            if (get_site_config('lead_welcome_email_web2lead')) {
                //send welcome email
                \Log::debug("Lead: sending Web to Lead generated mail to user");
                $mail_tpl = MailTemplates::find("LEAD_WELCOME_WEB2LEAD");
                if ($mail_tpl && $mail_tpl->status) {
                    $email_message = $mail_tpl->message;
                    $full_name = $wl_first_name . ' ' . $wl_last_name;
                    $email_message = str_ireplace("#sitename#", app_name(), $email_message);
                    $email_message = str_ireplace("#siteurl#", url(''), $email_message);
                    $email_message = str_ireplace("#first_name#", $wl_first_name, $email_message);
                    $email_message = str_ireplace("#full_name#", $full_name, $email_message);
                    $email_message = str_ireplace("#email#", $wl_email, $email_message);
                    $email_message = str_ireplace("#mobile#", $wl_dialcode . ' ' . $wl_mobile, $email_message);
                    try {
                        // $leaddetails = Lead::find($leadid);
                        //$leaddetails->notify(new UserAlert($mail_tpl->subject, $email_message));
                        user_notify($leaddetails, $mail_tpl->subject, $email_message);
                        \Log::debug("Web to Lead: mail sent to user- " . $email_message);
                        LeadActivity::create(['lead_id' => $leaddetails->id, 'date' => date("Y-m-d H:i:s"), 'detail' => "Email Sent: Subject:" . $mail_tpl->subject . "<br>Message:" . $email_message]);
                    } catch (\Exception $e) {
                        $message = $e->getMessage();
                        \Log::debug("Mail Error: (NEW WEB TO LEAD) " . $message);
                    }
                }
            }
                if (get_site_config('whatsapp_enabled')) {
                    $numbers = [$leaddetails->whatsapp_dialcode.$leaddetails->whatsapp];

                    $hook = 'lead_welcome_web2lead';

                    send_whatsapp_message($numbers, $hook, $leaddetails->id);
                }


                $sms_tpl = SMSTemplates::find("LEAD_WELCOME_WEB2LEAD");
                if ($sms_tpl && $sms_tpl->status) {
                    $sms_message = $sms_tpl->message;
                    $sms_message = str_ireplace("#sitename#", app_name(), $sms_message);
                    $sms_message = str_ireplace("#siteurl#", url(''), $sms_message);
                    $sms_message = str_ireplace("#first_name#", $request->get('first_name'), $sms_message);
                    $sms_message = str_ireplace("#full_name#", $request->get('first_name')." ".$request->get('last_name'), $sms_message);
                    $sms_message = str_ireplace("#email#", $request->get('email'), $sms_message);
                    $sms_message = str_ireplace("#password#", $request->get('password'), $sms_message);
                    try {
                        $leaddetails->notify(new UserAlert($sms_tpl->message, $sms_message));
                    } catch (\Exception $e) {
                        $message = $e->getMessage();
                        \Log::debug("Mail Error: (CONVERT LEAD)" . $message);
                    }
                }
            }

            if($wl_redirect_url){
                return redirect()->to($wl_redirect_url);
            } else{
                return redirect()->to($web_lead_redirect_url);
            }
        // }
        return redirect()->route('index');
    }
}
