<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Http;
use App\Models\WhatsAppMessage;
use App\Models\Auth\User;
use App\Models\UserActivity;
use App\Models\Auth\UserNotification;
use DB;

class WhatsAppWebhookController extends Controller
{
    /**
     * GET /webhook/whatsapp (verification)
     * Meta (Facebook) will call this once when you set up the webhook.
     */
    public function verify(Request $request)
    {
 
        $verifyToken = env('WHATSAPP_WEBHOOK_TOKEN', '');

        if (
            $request->get('hub_mode') === 'subscribe' &&
            $request->get('hub_verify_token') === $verifyToken
        ) {
            return response($request->get('hub_challenge'), 200);
        }

        return response('Forbidden', 403);
    }

	private function splitFullMobile($full_mob) {
        $MOB_LENGTH = 10;
        $ret[0] = "";//dialcode
        $ret[1] = "";//mobile
        if(strlen($full_mob) > $MOB_LENGTH) {
            $ret[0] = substr($full_mob, 0, strlen($full_mob) - $MOB_LENGTH);
            $ret[1] = substr($full_mob, strlen($full_mob) - $MOB_LENGTH);
        } else {
            $ret[1] = $full_mob; 
        }
        return $ret;
    }

    /**
     * POST /webhook/whatsapp (events)
     * Receives messages/status events from WhatsApp.
     */
    public function receive(Request $request)
    {
        $data = $request->all();
        Log::debug("--------WhatsApp Webhook payload--------" . json_encode($data));

        $entry = $data['entry'][0] ?? null;
        $changes = $entry['changes'][0] ?? null;
        $value = $changes['value'] ?? null;

        if (!$value) {
            return response('EVENT_RECEIVED', 200);
        }

        if (isset($value['messages']) && !empty($value['messages'])) {
            $contact = $value['contacts'][0] ?? [];
            $message = $value['messages'][0];

            $wa_id = $message['from'] ?? null; 
            $name  = $contact['profile']['name'] ?? null;
            $text  = $message['text']['body']
                ?? ($message['interactive']['list_reply']['title']
                ?? ($message['button']['text'] ?? ''));

            if ($wa_id) {
                $dialcode = substr($wa_id, 0, -10);
                $mobile   = substr($wa_id, -10);
                Log::debug("Mobile No is ". $mobile);
                $user = DB::table('users')->where('mobile', $mobile)->first();
                if ($user) {
                    Log::debug("--------User Information--------" . json_encode($user));
                    $user_id = $user->id;
                    $msg = WhatsAppMessage::create([
                        'wa_id'        => $wa_id,
                        'mobile'       => $mobile, 
                        'user_id'      => $user_id,
                        'message'      => $text,
                        'direction'    => 'inbound',
                    ]);

                    UserActivity::create([
                        'user_id'   => $user_id,
                        'type'      => 'whatsapp_received',
                        'detail'   => $text,
                    ]);

                    // Send Notification
                    $subject = "Incoming Messages From Whatsapp";
                    send_in_app_notification(
                        $user_id, 
                        $user_id,
                        "INCOMING_MESSAGES_FROM_WHATSAPP_WEBHOOK", 
                        $subject, 
                        $text,
                        "whatsapp_incoming",
                        false,
                        $user_id
                    );     
                    

                } else {
                    Log::debug("------- User Does not exist ------ for mobile: {$mobile}");
                    $lead_status = get_default_lead_status();
                    $branch = 1;
                    $user = User::create([
                        'first_name' => preg_replace('/[^A-Za-z0-9\- ]/', '', $name),
                        'dialcode' => $dialcode,
                        'mobile' => $mobile,
                        'is_lead' => 1,
                        'lead_source' => 'WhatsApp',
                        'created_mode' => "whatsapp_cloud_api",
                        'branch' => $branch,
                        'lead_status' => $lead_status
                    ]);

                    Log::debug("--------User ID is--------" . $user->id);
                    
                    $msg = WhatsAppMessage::create([
                        'wa_id'        => $wa_id,
                        'mobile'       => $mobile,
                        'user_id'      => $user->id,
                        'message'      => $text,
                        'direction'    => 'inbound',
                    ]);

                    $notify_emails = get_site_config('event_notification_email');
                    if($notify_emails) {
                        send_event_notification_email(explode(",", $notify_emails), "New Whatsapp Lead", $text);
                    } 

                    /*
                    if (get_site_config('whatsapp_enabled')) {
                        $numbers = [$dialcode.$mobile]; 

                        $hook = 'lead_welcome_web2lead';

                        send_whatsapp_message($numbers, $hook, $user->id);
                    }
                    */

                }
            }
        }
        return response('EVENT_RECEIVED', 200);
    }

}
