<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Auth\AuthenticationException;

/**
 * Class APIAuthenticate.
 */
class APIAuthenticate
{

    public function handle($request, Closure $next)
    {
        $key = $request->header('apikey');

        if (!config('app.api_key') || !$key || $key !== config('app.api_key')) {
            //throw new AuthenticationException('Wrong API Key');
            return response()->json(['message' => 'Wrong API Key'], 401);
        }
        return $next($request);
    }
}
