<?php

namespace App\Http\Requests\Backend\Auth\User;

use Illuminate\Validation\Rule;
use App\Helpers\Frontend\Auth\Socialite;
use Illuminate\Foundation\Http\FormRequest;

class LeadRequest extends FormRequest {

    public function authorize() {
        return true;
    }

    public function rules() {
        return [
            'first_name' => ['required', 'max:50','regex:/^[\pL\s]+$/u'],
            'last_name'  => ['nullable','max:50','regex:/^[\pL\s]+$/u'],
            // 'email' => 'required|email|unique:users',
            // 'mobile' => ['nullable', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH')],
            // 'study_level' => 'required',
            'next_followup' => 'nullable|after:' . date('Y-m-d H:i:s'),
            'date_of_birth' => 'nullable|before:'.now()->subYears(16)->toDateString()
        ];
    }

    public function messages() {
        return [
            'fname.regex' => 'Only letters and space is allowed in First Name',
            'lname.regex' => 'Only letters and space is allowed in Last Name',
            'mobile.unique' => 'Mobile Number already exists',
        ];
    }

}
