<?php

namespace App\Http\Requests\Backend\Auth\User;

use Illuminate\Validation\Rule;
use App\Helpers\Frontend\Auth\Socialite;
use Illuminate\Foundation\Http\FormRequest;

class MeetingRoomRequest extends FormRequest {

    public function authorize() {
        return true;
    }

    public function rules() {
        return [
            'room_name' => 'required|unique:meeting_rooms',
            'zoom_id' => 'required|unique:meeting_rooms'
        ];
    }

    public function messages() {
        return [
            'room_name.unique' => 'Meeting Room is Already Registered',
            'zoom_id.unique' => 'Meeting Room Room is Already Registered',
        ];
    }

}
