<?php

namespace App\Http\Requests\Backend\Auth\User;

use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

/**
 * Class UpdateBasicInfoRequest.
 */
class UpdateAdminBasicInfoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $id = auth()->user()->id;
        return [
            // 'title' => ['required'],
            'first_name'  => ['required', 'max:50'],
            'last_name'  => ['required', 'max:50'],
            'email' => ['required', 'email:filter,filter_unicode', 'unique:users,email,'.$id, 'max:191'],
            // 'mobile'  => ['required', 'digits:10'],
            'mobile' => ['required', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH')],
        ];
    }
}
