<?php

namespace App\Http\Requests\Backend\Auth\User;

use Illuminate\Foundation\Http\FormRequest;

/**
 * Class UpdateUserRequest.
 */
class UpdateUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        if($this->user()->isAdmin() || $this->user()->isAgent() || $this->user()->can('students'))
            return true;
        return false;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'first_name' => ['required', 'max:50','regex:/^[\pL\s]+$/u'],
            'middle_name' => ['nullable', 'max:50','regex:/^[\pL\s]+$/u'],
            'last_name'  => ['required', 'max:50','regex:/^[\pL\s]+$/u'],
            // 'email' => ['required', 'email', 'max:100'],
            // 'mobile' => ['required', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH')],
            'birthday' => 'nullable|before:'.now()->subYears(16)->toDateString(),
            'study_level' => 'required',
        ];
    }
    public function messages()
    {
        return [
            'first_name.regex' => 'Only letters and space is allowed in First Name',
            'middle_name.regex' => 'Only letters and space is allowed in Middle Name',
            'last_name.regex' => 'Only letters and space is allowed in Last Name',
        ];
    }
}
