<?php

namespace App\Http\Requests\Frontend\Auth;

use Illuminate\Validation\Rule;
use Arcanedev\NoCaptcha\Rules\CaptchaRule;
use Illuminate\Foundation\Http\FormRequest;

/**
 * Class RegisterRequest.
 */
class RegisterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'first_name'           => ['required', 'string', 'max:50','regex:/^[\pL\s]+$/u'],
            'last_name'           => ['required', 'max:50','regex:/^[\pL\s]+$/u'],
            'email'                => ['required', 'string', 'email', 'max:100', Rule::unique('users')],
            'mobile'                => ['required', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH')],
            'password'             => ['required', 'string', 'min:6', 'max:20'],
            //'g-recaptcha-response' => ['required_if:captcha_status,true', new CaptchaRule()],
        ];
    }

    /**
     * @return array
     */
    public function messages()
    {
        return [
            'first_name.regex' => 'Only letters and space is allowed in First Name',
            'last_name.regex' => 'Only letters and space is allowed in Last Name',
            //'g-recaptcha-response.required_if' => __('validation.required', ['attribute' => 'captcha']),
        ];
    }
}
