<?php

namespace App\Http\Requests\Frontend\User;

use Illuminate\Validation\Rule;
use App\Helpers\Frontend\Auth\Socialite;
use Illuminate\Foundation\Http\FormRequest;
 
class CertificateRequest extends FormRequest
{
     public function authorize()
    {
        return true;
    }
   
    public function rules()
    {
  return [
    'start_date'=> 'date_format:d/m/Y',
    'end_date'=> 'date_format:d/m/Y|after:start_date',
    'userid'=> 'unique:certificate_request,userid',
    ];
    }

    public function messages()
    {
    return [
         'end_date.after'=> 'Course End Date Must be greater than Start Date',
         'userid.unique'=>'You Certificate request already exists'
    ]; 

    }
}
 


