<?php
//This file is not used!

namespace App\Http\Requests\Frontend\User;

use Illuminate\Validation\Rule;
use App\Helpers\Frontend\Auth\Socialite;
use Illuminate\Foundation\Http\FormRequest;

/**
 * Class StudyAbroadDocsRequest.
 */
class StudyAbroadDocsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {

        $single_file_max = config('app.doc_single_max_size') * 1024;
        $allsem_file_max = config('app.doc_allsem_max_size') * 1024;

        return [
            'class10' => 'nullable|mimes:pdf|max:'.$single_file_max,
            'class10_marks_sheet' => 'nullable|mimes:pdf|max:'.$single_file_max,
            'class12' => 'nullable|mimes:pdf|max:'.$single_file_max,
            'class12_marks_sheet' => 'nullable|mimes:pdf|max:'.$single_file_max,
            'diploma' => 'nullable|mimes:pdf|max:'.$single_file_max,
            'diploma_marks_sheet' => 'nullable|mimes:pdf|max:'.$single_file_max,
            'grad_all_sem' => 'nullable|mimes:pdf|max:'.$allsem_file_max,
            'grad_degree' => 'nullable|mimes:pdf|max:'.$single_file_max,
            'grad_transcripts' => 'nullable|mimes:pdf|max:'.$single_file_max,
            'pg_all_sem' => 'nullable|mimes:pdf|max:'.$allsem_file_max,
            'pg_degree' => 'nullable|mimes:pdf|max:'.$single_file_max,
            'pg_transcripts' => 'nullable|mimes:pdf|max:'.$single_file_max,
            'lang_ielts' => 'nullable|mimes:pdf|max:'.$single_file_max,
            'lang_pte' => 'nullable|mimes:pdf|max:'.$single_file_max,
            'gre' => 'nullable|mimes:pdf|max:'.$single_file_max,
            'gmat' => 'nullable|mimes:pdf|max:'.$single_file_max,
        ];

    }

    public function attributes()
    {
        return [
            'class10' => '10th Certificate',
            'class10_marks_sheet' => '10th Marks Sheet',
            'class12' => '12th Certificate',
            'class12_marks_sheet' => '12th Marks Sheet',
            'diploma' => 'Diploma Certificate',
            'diploma_marks_sheet' => 'Diploma Marks Sheet',
            'grad_all_sem' => 'Bachelors All Semester',
            'grad_degree' => 'Bachelors Certificate',
            'grad_transcripts' => 'Bachelors Marks Sheet',
            'pg_all_sem' => 'Masters All Semester',
            'pg_degree' => 'Masters Certificate',
            'pg_transcripts' => 'Masters Marks Sheet',
            'lang_ielts' => 'IELTS Certificate',
            'lang_pte' => 'PTE Certificate',
            'gre' => 'GRE Certificate',
            'gmat' => 'GMAT Certificate',
        ];
    }    
}
