<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Redis;
use App\Mail\MailSend;
use Mail;
use Log;

class EmailJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $details;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($details)
    {
        $this->details = $details;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {

        if(env('QUEUE_CONNECTION') == 'redis') {

            $emails_per_sec = env('EMAILS_PER_SEC', 0.13);//default 500 emails per hr
            if($emails_per_sec >= 1) {
              $allow_emails_cnt = round($emails_per_sec);
              $every_x_sec = 1;
            } else {
              $allow_emails_cnt = 1;
              $every_x_sec = ceil(1 / $emails_per_sec);
            }

            //Testing
            //$allow_emails_cnt = 1;
            //$every_x_sec = 60;

            \Log::debug("REDIS THROTTLE: ALLOW ".$allow_emails_cnt." EVERY ".$every_x_sec);            

            Redis::throttle(env('REDIS_EMAIL_KEY'))->block(1)->allow($allow_emails_cnt)->every($every_x_sec)->then(function () {
              //$email = new MailSend();
              if(env('BROADCAST_SMTP_MAIL_HOST') && env('BROADCAST_SMTP_MAIL_PORT') && env('BROADCAST_SMTP_MAIL_USERNAME') && env('BROADCAST_SMTP_MAIL_PASSWORD') && env('BROADCAST_SMTP_MAIL_ENCRYPTION')){
                \Log::debug("REDIS Queue Mail: (BROADCAST MESSAGE) sending through- BROADCAST_SMTP");
                Mail::mailer('broadcast_smtp')->to($this->details)->send($this->details);
              }else{
                \Log::debug("REDIS Queue Mail: (BROADCAST MESSAGE) sending through- SMTP");
                Mail::mailer('smtp')->to($this->details)->send($this->details); 
              } 
                           
            }, function () use($every_x_sec) {
                // Could not obtain lock...
                \Log::debug("REDIS THROTTLE: Could not obtain lock");
                if($every_x_sec < 30) {
                    //Try after 30 sec not before that
                    return $this->release(30);
                } else {
                    //Don't retry till x sec
                    return $this->release($every_x_sec);
                }
            });                
          } 
    }
}
