<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class BroadcastMailSend extends Mailable
{

    use Queueable,
        SerializesModels;

    public $to;
    public $subject;
    public $msg;
    public $email;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($to, $subject, $msg)
    {
        $this->to = [["email" => $to, "address" => $to, "name" => ""]];
        $this->email = $to;
        $this->subject = $subject;
        $this->msg = $msg;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from(config('mail.from.address'), config('mail.from.name'))
            ->subject($this->subject)
            ->view('email.default')
            ->text('email.default_plain')
            ->with(
                [
                    'content' => $this->msg
                ]
            );
    }
}
