<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class MailSend extends Mailable {

    use Queueable,
        SerializesModels;

    public $subject;
    public $msg;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($subject, $msg) {
        $this->subject = $subject;
        $this->msg = $msg;
        \Log::debug("Creating MailSend Mail. SUBJECT:".$subject);
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build() {
        return $this->from(config('mail.from.address'), config('mail.from.name'))
                        ->subject($this->subject)
                        ->replyTo(config('mail.reply_to'))
                        //->replyTo(env('REPLY_TO_ADDRESS'))
                        ->view('email.default')
                        ->text('email.default_plain')
                        ->with(
                            [
                                'content' => $this->msg
                            ]
                        );
    }

}
