<?php

namespace App\Models\Auth;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Batch.
 */
class Batch extends Model
{

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'batch';


    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['code', 'branch', 'course', 'start_date', 'end_date', 'trainer', 'days', 'start_hour', 'start_min', 'end_hour', 'end_min', 'meeting_room', 'totalduration', 'create_date', 'update_date', 'assignment_marks', 'attendance_marks', 'online_course_marks', 'oral_mid_term_exam_marks', 'mid_term_marks', 'oral_end_term_marks', 'end_term_marks','essay_mid_term_marks','essay_end_term_marks', 'online_courses'];


    public function midTermExam()
    {
        return $this->hasOne('\App\Models\Auth\Exam', 'batch_id', 'id')->midTermExam();
    }

    public function endTermExam()
    {
        return $this->hasOne('\App\Models\Auth\Exam', 'batch_id', 'id')->endTermExam();
    }

    public function mockExam()
    {
        return $this->hasMany('\App\Models\Auth\Exam', 'batch_id', 'id')->mockExam();
    }
}
