<?php

namespace App\Models\Auth;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Batch.
 */
class BatchStudents extends Model {

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'batch_students';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['batch', 'student'];

    public function student() {

        return $this->hasOne('\App\Models\Auth\User', 'id', 'student');
    }

    public function batchObj() {

        return $this->hasOne('\App\Models\Auth\Batch', 'id', 'batch');
    }

    public static function getOnlineCourseObjByStudentId($studentId) {
        if ($studentId > 0) {
            $batchStudentObj = BatchStudents::with('batchObj')->where('student', '=', $studentId)->where('batch', '>', 0)->first();
            if (!empty($batchStudentObj)) {
                $batchObj = (!empty($batchStudentObj->batchObj)) ? $batchStudentObj->batchObj : array();
                if (!empty($batchObj)) {
                    $batchOnlineCourses = !empty($batchObj->online_courses) ? explode(',', $batchObj->online_courses) : array();
                    if (!empty($batchOnlineCourses)) {
                        return OnlineCourse::getCourseObjByIds($batchOnlineCourses);
                    }
                }
            }
        }
        return array();
    }

    public static function getOnlineCourseObjByStudentIdAndBatchId($studentId, $batchId) {
        \Log::debug("------:getOnlineCourseObjByStudentIdAndBatchId($studentId, $batchId)");
        if ($studentId > 0) {
            $batchStudentObj = BatchStudents::with('batchObj')->where('student', '=', $studentId)->where('batch', '=', $batchId)->first();
            if (!empty($batchStudentObj)) {
                \Log::debug(":batchstudent ok");
                $batchObj = (!empty($batchStudentObj->batchObj)) ? $batchStudentObj->batchObj : array();
                if (!empty($batchObj)) {
                    \Log::debug(":batchobj ok");
                    $batchOnlineCourses = !empty($batchObj->online_courses) ? explode(',', $batchObj->online_courses) : array();
                    if (!empty($batchOnlineCourses)) {
                        \Log::debug(":batchOnlineCourses ok. Ret ids:" . print_r($batchOnlineCourses, true));
                        return OnlineCourse::getCourseObjByIds($batchOnlineCourses);
                    }
                }
            }
        }
        return array();
    }

    public static function getOnlineCourseObjByStudentIdAndOnlineCourseId($studentId, $courseId) {
        \Log::debug("------:getOnlineCourseObjByStudentIdAndOnlineCourseId($studentId, $courseId)");
        if ($studentId > 0) {
            $batchStudentObjs = BatchStudents::with('batchObj')->where('student', '=', $studentId)->where('batch', '>', 0)->get();
            if (!empty($batchStudentObjs)) {
                foreach ($batchStudentObjs as $batchStudentObj) {
                    $batchObj = (!empty($batchStudentObj->batchObj)) ? $batchStudentObj->batchObj : array();
                    if (!empty($batchObj)) {
                        $batchOnlineCourses = !empty($batchObj->online_courses) ? explode(',', $batchObj->online_courses) : array();
                        if (!empty($batchOnlineCourses)) {
                            if (in_array($courseId, $batchOnlineCourses)) {
                                \Log::debug(":couserid found in one of the batch");
                                return OnlineCourse::getCourseWithChaptersObjById($courseId);
                            }
                        }
                    }
                }
            }
        }
        return array();
    }

    public static function hasAccessToCourse($studentId, $courseId) {
        if ($studentId > 0) {
            $batchStudentObj = BatchStudents::with('batchObj')->where('student', '=', $studentId)->where('batch', '>', 0)->first();
            if (!empty($batchStudentObj)) {
                $batchObj = (!empty($batchStudentObj->batchObj)) ? $batchStudentObj->batchObj : array();
                if (!empty($batchObj)) {
                    $batchOnlineCourses = !empty($batchObj->online_courses) ? explode(',', $batchObj->online_courses) : array();
                    return (in_array($courseId, $batchOnlineCourses)) ? 1 : 0;
                }
            }
        }
        return 0;
    }

}
