<?php

namespace App\Models\Auth;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Course.
 */
class Chapters extends Model
{
    protected $table = 'online_course_chapters';
    protected $primaryKey = "id";

    public function scopeActive($query)
    {
        return $query->where('status', '=', 1);
    }
    public function scopeDisplayOrder($query){

        return $query->orderBy('display_order','ASC');
    }

    public static function getChapterById($id)
    {
            if ($id > 0) {
                return Chapters::where('id', '=', $id)->first();
            }
            return '';
    }
    
    public static function addOrUpdateChapter($data,$chapterId=0){
        if(!empty($data)){
            if ($chapterId > 0) {
                $newObj = Chapters::where('id', '=', $chapterId)->first();
            } else {
                $newObj = new Chapters();
            }
            $newObj->online_course_id = $data['online_course_id'];
            $newObj->title = $data['title'];

            if (isset($data['file1']) && (!empty($data['file1']))) {
                $newObj->file1 = $data['file1'];
                $newObj->file1_type = $data['file1_type'];
            }
            if (isset($data['file2']) && (!empty($data['file2']))) {
                $newObj->file2 = $data['file2'];
                $newObj->file2_type = $data['file2_type'];
            }
            if (isset($data['file3']) && (!empty($data['file3']))) {
                $newObj->file3 = $data['file3'];
                $newObj->file3_type = $data['file3_type'];
            }
            $newObj->summary = $data['summary'];
            $newObj->duration = $data['duration'];
            $newObj->status = 1;
            if (isset($data['status'])) {
                $newObj->status = $data['status'];
            }
            $newObj->display_order = $data['display_order'];
            $newObj->save();
            return $newObj->id;
        }
        return 0;
    }

    public function onlineCourse()
    {
        return $this->belongsTo('\App\Models\Auth\OnlineCourse', 'online_course_id', 'id')->active();
    }

    public function quiz()
    {
        return $this->hasMany('\App\Models\Auth\ChaptersQuiz', 'chapter_id', 'id')->displayOrder();
    }
}
