<?php

namespace App\Models\Auth;

use Illuminate\Database\Eloquent\Model;

/**
 * Class ChaptersQuiz.
 */
class ChaptersQuiz extends Model
{
    protected $table = 'online_course_chapters_quiz';
    protected $primaryKey = "id";

    public function scopeActive($query)
    {
        return $query->where('status', '=', 1);
    }

    public function scopeDisplayOrder($query)
    {

        return $query->orderBy('display_order', 'ASC');
    }

    public static function getChaptersQuizById($id)
    {
        if ($id > 0) {
            return ChaptersQuiz::where('id', '=', $id)->first();
        }
        return '';
    }

    public static function addOrUpdateChapterQuiz($data, $quizId = 0)
    {
        if (!empty($data)) {
            if ($quizId > 0) {
                $newObj = ChaptersQuiz::where('id', '=', $quizId)->first();
            } else {
                $newObj = new ChaptersQuiz();
            }
            $newObj->chapter_id = $data['chapter_id'];
            $newObj->question = $data['question'];
            $newObj->question_file = !empty($data['question_file']) ? $data['question_file'] : '';
            $answer_options = $data['answer_options'];
            $answer_cols =  array();
            for($i=1;$i<=8;$i++){
                $answer_cols[] = 'option'.$i;
            }
            $answer_options = array_combine($answer_cols,$answer_options);
            if(is_array($answer_options)){
                foreach ($answer_options as $key=>$value){
                    $newObj->$key = !empty($value) ? $value : NULL;
                }
            }
            $newObj->answers = !empty($data['answers']) ? implode(',',$data['answers']): '';
            $newObj->answer_type = $data['answer_type'];
            $newObj->display_order = $data['display_order'];
            $newObj->status = 1;
            if (isset($data['status'])) {
                $newObj->status = $data['status'];
            }
            $newObj->save();
            return $newObj->id;
        }
        return 0;
    }

    public function chapterObj()
    {
        return $this->belongsTo('\App\Models\Auth\Chapters', 'chapter_id', 'id')->active();
    }
}
