<?php

namespace App\Models\Auth;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Batch.
 */
class Exam extends Model
{

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'exam';


    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['batch_id', 'type', 'exam_date', 'chapters', 'objective_question_count', 'objective_question_mark','essay_question_count','essay_question_mark','comprehension_question_count','comprehension_question_mark', 'total_questions', 'total_marks', 'duration'];

    public static function insertOrUpdate($data, $batchId = 0)
    {
        if (($batchId > 0) && (!empty($data))) {
            $examObj = Exam::where('type', '=', $data['type'])->where('batch_id', '=', $batchId)->first();
            if (empty($examObj)) {
                $examObj = new Exam();
                $examObj->type = $data['type'];
                $examObj->batch_id = $batchId;
            }            
            
            $examObj->exam_date = $data['exam_date'];
            $examObj->chapters = $data['chapters'];
            $examObj->duration = $data['duration'];
            $examObj->objective_question_count = $data['objective_question_count'];
            $examObj->objective_question_mark = $data['objective_question_mark'];
            $examObj->essay_question_count = $data['essay_question_count'];
            $examObj->essay_question_mark = $data['essay_question_mark'];
            $examObj->comprehension_question_count = $data['comprehension_question_count'];
            $examObj->comprehension_question_mark = $data['comprehension_question_mark'];
            $examObj->total_questions = $data['total_questions'];
            $examObj->total_marks = $data['total_marks'];
            $result = $examObj->save();
            return $examObj->id;
        }
    }

    public function scopeEndTermExam($query)
    {
        return $query->where('type', '=', 'end');
    }

    public function scopeMidTermExam($query)
    {
        return $query->where('type', '=', 'mid');
    }
    
    public function scopeMockExam($query)
    {
        return $query->where('type', '=', 'mock');
    }
    
}
