<?php

namespace App\Models\Auth;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Model;
use App\Models\Auth\Traits\Method\LeadMethod;

/**
 * Class Lead.
 */
class Lead extends Model
{

    use Notifiable, LeadMethod;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'leads';


    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['title', 'first_name', 'last_name', 'mobile', 'email', 'address', 'lead_type', 'status', 'course', 'country', 'country_pref', 'branch', 'qualification', 'cgpa', 'ielts', 'toefl', 'pte', 'lead_source', 'lead_source_detail', 'description', 'created_by', 'lead_assigned_at', 'assigned_to','gender','date_of_birth','dialcode','alternate_contact','whatsapp','current_course','study_level','accommodation','study_permit','next_followup','course_interested','intake_year','intake_month','work_experience','gre','duolingo','created_at','city','passout_year','lead_campaign_name'];
}
