<?php

namespace App\Models\Auth;
use Illuminate\Database\Eloquent\Model;

/**
 * Class QuestionAnswerComprehension.
 */
class QuestionAnswerComprehension extends Model
{
    protected $table = 'q_a_comprehension_text';
    protected $primaryKey = "id";



    public static function addOrUpdateComprehension($data, $com_id = 0)
    {
        if (!empty($data)) {
            if ($com_id > 0) {
                $newObj = QuestionAnswerComprehension::where('id', '=', $com_id)->where('status', '=' , '1')->first();
            } else {
                $newObj = new QuestionAnswerComprehension();
            }
            $newObj->title = $data['title'];
            $newObj->content = $data['content'];
            $newObj->course_id = $data['course_id'];
            $newObj->chapter = $data['chapter'];
            $newObj->chapter_notes = $data['chapter_notes'];
            $newObj->save();
            return $newObj->id;
        }
        return 0;
    }
    
    
}
