<?php

namespace App\Models\Auth;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Course.
 */
class QuestionsAnswers extends Model
{
    protected $table = 'q_a';
    protected $primaryKey = "id";

    public function scopeActive($query)
    {
        return $query->where('status', '=', 1);
    }

    public function course()
    {
        return $this->hasOne('\App\Models\Auth\Course', 'id', 'course_id');
    }

    public static function addOrUpdateQuestionsAndAnswers($data, $qaId = 0)
    {
        if (!empty($data)) {
            if ($qaId > 0) {
                $newObj = QuestionsAnswers::where('id', '=', $qaId)->first();
            } else {
                $newObj = new QuestionsAnswers();
            }
            $newObj->question_model = $data['question_model'];
            $newObj->comprehension_id = $data['comprehension_id'];
            $newObj->chapter = $data['chapter'];
            $newObj->chapter_notes = $data['chapter_notes'];
            $newObj->course_id = $data['course_id'];
            $newObj->question = $data['question'];
            $newObj->category = $data['category'];
            $newObj->question_type = $data['question_type'];
            $newObj->question_file = !empty($data['question_file']) ? $data['question_file'] : '';
            $newObj->question_file_type = !empty($data['question_file_type']) ? $data['question_file_type'] : 'none';
            $answer_options = $data['answer_options'];
            $answer_cols =  array();
            for($i=1;$i<=8;$i++){
                $answer_cols[] = 'option'.$i;
            }
            $answer_options = array_combine($answer_cols,$answer_options);
            if(is_array($answer_options)){
                foreach ($answer_options as $key=>$value){
                    $newObj->$key = !empty($value) ? $value : NULL;
                }
            }
            $newObj->answers = !empty($data['answers']) ? implode(',',$data['answers']): '';
            $newObj->answer_type = $data['answer_type'];
            //$newObj->display_order = $data['display_order'];
            $newObj->status = 1;
            if (isset($data['status'])) {
                $newObj->status = $data['status'];
            }
            $newObj->save();
            return $newObj->id;
        }
        return 0;
    }
}
